/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.rental.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentalSettlementStateEnum;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalEntity;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalService;
import com.ejianc.business.proequipmentcorpout.rental.vo.OutRentRentalVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"outRentRental"})
@Api(value="\u79df\u91d1\u8ba1\u7b97\u4e3b\u8868", tags={"\u79df\u91d1\u8ba1\u7b97\u4e3b\u8868"})
public class OutRentRentalController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IRentReceiptsApi receiptsApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutRentRentalService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRentRentalVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OutRentRentalVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveRental(saveOrUpdateVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRentRentalVO> queryDetail(@RequestParam Long id) {
        OutRentRentalEntity entity = (OutRentRentalEntity)((Object)this.service.selectById(id));
        OutRentRentalVO vo = (OutRentRentalVO)BeanMapper.map((Object)((Object)entity), OutRentRentalVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRentRentalVO> pushCost(@RequestBody OutRentRentalVO vo) {
        return CommonResponse.success((String)"\u6ca1\u6709\u5b9e\u9645\u6210\u672c\u63a8\u9001\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRentRentalVO> vos) {
        this.service.delRental(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutRentRentalVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRentRentalVO.class));
        this.setDefaultName(pageData.getRecords());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    private void setDefaultName(List<OutRentRentalVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (OutRentRentalVO vo : list) {
                vo.setSettlementStateName(RentalSettlementStateEnum.getEnumByCode(vo.getSettlementState()).getDescription());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(vo.getBillState())) {
                    vo.setBillStateName("\u5ba1\u6838\u4e2d");
                }
                if (BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(vo.getBillState())) {
                    vo.setBillStateName("\u5ba1\u6838\u4e2d");
                }
                vo.setRentHarborTypeName(OutRentConstants.getOutContractRentHarborTypeMap(vo.getRentHarborType()));
            }
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, OutRentRentalVO.class);
        this.setDefaultName(voList);
        beans.put("records", voList);
        ExcelExport.getInstance().export("OutRentRental-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refOutRentRentalData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRentRentalVO>> refOutRentRentalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("meterRentTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("settlementState", new Parameter("eq", (Object)RentalSettlementStateEnum.\u672a\u7ed3\u7b97.getCode()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            _con = JSONObject.parseObject((String)condition);
            if (!_con.containsKey((Object)"contractId")) {
                throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        } else {
            throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        param.getParams().put("contractId", new Parameter("eq", _con.get((Object)"contractId")));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRentRentalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/automaticRental"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRentRentalVO> automaticRental(@RequestBody OutRentRentalVO vo) {
        OutRentRentalVO outRentRentalVO = this.service.automaticRental(vo);
        return CommonResponse.success((String)"\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\u6210\u529f\uff01", (Object)outRentRentalVO);
    }

    @RequestMapping(value={"/pushHistoryData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> savePriceContractCollect(HttpServletRequest request) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(1, 3)));
        queryParam.getParams().put("rent_harbor_type", new Parameter("eq", (Object)1));
        List entityList = this.service.queryList(queryParam);
        this.logger.info("\u67e5\u51fa\u79df\u51fa\u79df\u91d1\u8ba1\u7b97\u5355\u6570\u636e\u96c6\uff1a{}", (Object)JSONObject.toJSONString((Object)entityList));
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            for (OutRentRentalEntity entity : entityList) {
                OutRentRentalVO outRentRentalVO = (OutRentRentalVO)BeanMapper.map((Object)((Object)entity), OutRentRentalVO.class);
                this.logger.info("\u63a8\u9001\u9879\u76ee\u65b9\u6570\u636eoutRentRentalVO\uff1a{}", (Object)JSONObject.toJSONString((Object)outRentRentalVO));
                outRentRentalVO.setOrgId(outRentRentalVO.getOutOrgId());
                outRentRentalVO.setOrgName(outRentRentalVO.getOutOrgName());
                outRentRentalVO.setOrgCode(outRentRentalVO.getOutOrgCode());
                outRentRentalVO.setRentType(outRentRentalVO.getRentHarborType());
                outRentRentalVO.setRentTypeName(outRentRentalVO.getRentHarborTypeName());
                CommonResponse response = this.receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON((Object)outRentRentalVO), RentReceiptsEnum.\u79df\u91d1\u8ba1\u7b97\u5355.getName());
                if (response.isSuccess()) continue;
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success((String)"\u6210\u529f\u63a8\u9001\uff1a{}\u6761\u6570\u636e");
    }
}

