/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.order.service.impl;

import com.ejianc.business.proequipmentcorprent.order.bean.RentOrderEntity;
import com.ejianc.business.proequipmentcorprent.order.service.IRentOrderService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentOrder")
public class RentOrderBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IRentOrderService rentOrderService;
    private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/corpRentOrder/deleteOrder";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        RentOrderEntity orderEntity = (RentOrderEntity)((Object)this.rentOrderService.selectById(billId));
        orderEntity.setCommitId(InvocationInfoProxy.getUserid());
        this.rentOrderService.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentOrderEntity orderEntity = (RentOrderEntity)((Object)this.rentOrderService.selectById(billId));
        Boolean pushFlag = this.rentOrderService.pushBillToSupCenter(orderEntity, billTypeCode);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushFlag);
        if (pushFlag.booleanValue()) {
            if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
                orderEntity.setCommitId(InvocationInfoProxy.getUserid());
            }
        } else {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5931\u8d25");
        }
        orderEntity.setReceiveState(0);
        this.rentOrderService.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentOrderEntity orderEntity = (RentOrderEntity)((Object)this.rentOrderService.selectById(billId));
        if (orderEntity.getReceiveState() == 0) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u4e0b\u6e38\u64cd\u4f5c\uff0c\u4e0d\u5141\u8bb8\u56de\u9000!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentOrderEntity orderEntity = (RentOrderEntity)((Object)this.rentOrderService.selectById(billId));
        return this.rentOrderService.updatePushBill(orderEntity, billTypeCode, "/ejc-supbusiness-web/openapi/corpRentOrder/deleteOrder");
    }
}

