/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalDayEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalMonthEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalQuantitiesEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentalSettlementStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterDetailService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentRentalService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentParameterVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentRental")
public class RentRentalBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentRentalService service;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IRentParameterService parameterService;
    @Autowired
    private IRentParameterDetailService rentParameterDetailService;
    @Autowired
    private IRentContractService contractService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentRentalEntity entity = (RentRentalEntity)((Object)this.service.selectById(billId));
        this.logger.info("\u63a8\u9001\u6210\u672c---");
        if ("1".equals(entity.getRentalType())) {
            List<RentParameterVO> rentParameterList = this.parameterService.getRentParameterByContractId(entity.getContractId(), entity.getId(), entity.getRentalDate());
            ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
            for (RentParameterVO rentParameterVO : rentParameterList) {
                RentParameterEntity rentParameterEntity = (RentParameterEntity)((Object)BeanMapper.map((Object)rentParameterVO, RentParameterEntity.class));
                RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
                detailEntity.setSourceType(RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode());
                detailEntity.setSourceId(entity.getId());
                detailEntity.setOperationDate(entity.getRentalDate());
                QueryParam detailParam = new QueryParam();
                detailParam.getParams().put("parameterId", new Parameter("eq", (Object)rentParameterEntity.getId()));
                detailParam.getOrderMap().put("createTime", "desc");
                List detailList = this.rentParameterDetailService.queryList(detailParam, false);
                if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                    detailEntity.setEquipmentState(((RentParameterDetailEntity)((Object)detailList.get(0))).getEquipmentState());
                } else {
                    detailEntity.setEquipmentState(rentParameterEntity.getEquipmentState());
                }
                detailEntity.setParameterId(rentParameterEntity.getId());
                parameterDetailList.add(detailEntity);
            }
            if (CollectionUtils.isNotEmpty(parameterDetailList)) {
                this.rentParameterDetailService.saveOrUpdateBatch(parameterDetailList);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
        }
        RentRentalEntity entity = (RentRentalEntity)((Object)this.service.selectById(billId));
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        if (contractEntity != null && PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode().equals(contractEntity.getContractPerformanceState())) {
            return CommonResponse.error((String)"\u5408\u540c\u5df2\u7ec8\u6b62\uff0c\u8be5\u5355\u636e\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (RentalSettlementStateEnum.\u5df2\u7ed3\u7b97.getCode().equals(entity.getSettlementState())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u7ed3\u7b97\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        if (entity.getContractId() != null) {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(RentRentalEntity::getContractId, (Object)entity.getContractId());
            lambda.orderByDesc(BaseEntity::getCreateTime);
            List list = this.service.list((Wrapper)lambda);
            RentRentalEntity rentRentalEntity = (RentRentalEntity)((Object)list.get(0));
            if (!entity.getId().equals(rentRentalEntity.getId())) {
                throw new BusinessException("\u53ea\u80fd\u64a4\u56de\u6700\u65b0\u7684\u7ed3\u7b97\u5355\uff01");
            }
        }
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-Id---{}", (Object)entity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(entity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(RentRentalEntity::getRelationFlag, (Object)"0");
        this.service.update((Wrapper)updateWrapper);
        if ("1".equals(entity.getRentalType())) {
            List sourceIdList;
            ArrayList parameterIdList = new ArrayList();
            List<RentRentalDayEntity> dayList = entity.getRentRentalDayList();
            List<RentRentalMonthEntity> monthList = entity.getRentRentalMonthList();
            List<RentRentalQuantitiesEntity> qList = entity.getRentRentalQuantitiesList();
            if (CollectionUtils.isNotEmpty(dayList)) {
                sourceIdList = dayList.stream().map(RentRentalDayEntity::getSourceId).collect(Collectors.toList());
                parameterIdList.addAll(sourceIdList);
            }
            if (CollectionUtils.isNotEmpty(monthList)) {
                sourceIdList = monthList.stream().map(RentRentalMonthEntity::getSourceId).collect(Collectors.toList());
                parameterIdList.addAll(sourceIdList);
            }
            if (CollectionUtils.isNotEmpty(qList)) {
                sourceIdList = qList.stream().map(RentRentalQuantitiesEntity::getSourceId).collect(Collectors.toList());
                parameterIdList.addAll(sourceIdList);
            }
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("parameterId", new Parameter("in", parameterIdList));
            detailParam.getParams().put("source_id", new Parameter("eq", (Object)billId));
            detailParam.getOrderMap().put("createTime", "desc");
            List parameterDetailList = this.rentParameterDetailService.queryList(detailParam, false);
            if (CollectionUtils.isNotEmpty((Collection)parameterDetailList)) {
                this.rentParameterDetailService.removeByIds(parameterDetailList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            }
        }
        return CommonResponse.success();
    }
}

