/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.appearance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.appearance.bean.AppearanceEntity;
import com.ejianc.business.proequipmentcorprent.appearance.bean.AppearanceSubEntity;
import com.ejianc.business.proequipmentcorprent.appearance.service.IAppearanceService;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterDetailService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="appearance")
public class AppearanceBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAppearanceService service;
    @Autowired
    private IRentParameterService rentParameterService;
    @Autowired
    private IRentParameterDetailService rentParameterDetailService;
    @Autowired
    private IRentContractService contractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        AppearanceEntity e = (AppearanceEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u4f7f\u7528\u8bb0\u5f55\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AppearanceEntity e = (AppearanceEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
        }
        ArrayList<RentParameterEntity> parameterList = new ArrayList<RentParameterEntity>();
        List<AppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
        for (AppearanceSubEntity subEntity : appearanceSubList) {
            RentParameterEntity parameterEntity = new RentParameterEntity();
            parameterEntity.setId(subEntity.getSourceId());
            if (6 != subEntity.getState()) {
                parameterEntity.setRentEndDate(e.getAppearanceDate());
            }
            parameterEntity.setOutDate(e.getAppearanceDate());
            parameterEntity.setOperationDate(new Date());
            parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u9000\u573a.getCode());
            parameterEntity.setUseType(2);
            if (6 != subEntity.getState()) {
                ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
                RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
                detailEntity.setSourceType(RentParameterTypeEnum.\u9000\u573a\u5355.getCode());
                detailEntity.setSourceId(e.getId());
                detailEntity.setOperationDate(subEntity.getRentEndDate());
                detailEntity.setEquipmentState(RentEquipmentStateEnum.\u9000\u573a.getCode());
                detailEntity.setParameterId(subEntity.getSourceId());
                parameterDetailList.add(detailEntity);
                parameterEntity.setRentParameterDetailList(parameterDetailList);
            }
            parameterList.add(parameterEntity);
        }
        this.rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.\u9000\u573a\u5355.getCode());
        boolean pushFlag = false;
        if (!pushFlag) {
            e.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        } else {
            e.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        }
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u4f7f\u7528\u8bb0\u5f55\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AppearanceEntity entity = (AppearanceEntity)((Object)this.service.selectById(billId));
        if (entity.getNotSignature().booleanValue()) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        if (contractEntity != null && PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode().equals(contractEntity.getContractPerformanceState())) {
            return CommonResponse.error((String)"\u5408\u540c\u5df2\u7ec8\u6b62\uff0c\u8be5\u5355\u636e\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        List<AppearanceSubEntity> appearanceSubList = entity.getAppearanceSubList();
        if (CollectionUtils.isNotEmpty(appearanceSubList)) {
            for (AppearanceSubEntity appearanceSubEntity : appearanceSubList) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("equipment_exit_code", new Parameter("eq", (Object)appearanceSubEntity.getEquipmentExitCode()));
                queryParam.getParams().put("contract_id", new Parameter("ne", (Object)entity.getContractId()));
                queryParam.getOrderMap().put("create_time", "desc");
                List list = this.rentParameterService.queryList(queryParam);
                this.logger.info("\u67e5\u51fa\u76f8\u540c\u51fa\u5382\u7f16\u7801\uff0c\u4e0d\u540c\u5408\u540c\u7684\u8bbe\u5907\u53f0\u8d26\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)list));
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    RentParameterEntity outRentParameterEntity = (RentParameterEntity)((Object)list.get(0));
                    if (!appearanceSubEntity.getId().equals(outRentParameterEntity.getSourceId())) {
                        return CommonResponse.error((String)"\u53f0\u8d26\u5df2\u6709\u65b0\u7684\u8bbe\u5907\uff0c\u4e0d\u652f\u6301\u64a4\u56de\uff01");
                    }
                }
                QueryParam parameterDetailQuery = new QueryParam();
                parameterDetailQuery.getParams().put("parameterId", new Parameter("eq", (Object)appearanceSubEntity.getSourceId()));
                parameterDetailQuery.getOrderMap().put("createTime", "desc");
                List detailEntityList = this.rentParameterDetailService.queryList(queryParam, false);
                if (!CollectionUtils.isNotEmpty((Collection)detailEntityList)) continue;
                RentParameterDetailEntity detailEntity = (RentParameterDetailEntity)((Object)detailEntityList.get(0));
                if (6 == appearanceSubEntity.getState() || billId.equals(detailEntity.getSourceId())) continue;
                return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25:\u8be5\u5355\u636e\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u6216\u5df2\u505a\u79df\u91d1\u8ba1\u7b97\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AppearanceEntity e = (AppearanceEntity)((Object)this.service.selectById(billId));
        List<AppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
        List<Long> parameterIdList = appearanceSubList.stream().filter(item -> 6 != item.getState()).map(AppearanceSubEntity::getSourceId).collect(Collectors.toList());
        List parameterIdListTz = appearanceSubList.stream().filter(item -> 6 == item.getState()).map(AppearanceSubEntity::getSourceId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(parameterIdList)) {
            this.rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.\u9000\u573a\u5355.getCode(), e.getId());
        }
        if (CollectionUtils.isNotEmpty(parameterIdListTz)) {
            QueryParam saveParam = new QueryParam();
            saveParam.getParams().put("id", new Parameter("in", parameterIdList));
            List saveList = this.rentParameterService.queryList(saveParam, false);
            for (RentParameterEntity saveEntity : saveList) {
                saveEntity.setOutDate(null);
                saveEntity.setOperationDate(new Date());
                saveEntity.setEquipmentState(RentEquipmentStateEnum.\u505c\u79df.getCode());
            }
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(e.getBillPushFlag())) {
            CommonResponse<String> commonResponse = this.service.updatePushBill(e, billTypeCode);
            this.logger.info("\u4f9b\u65b9\u7ed3\u679c" + JSONObject.toJSONString(commonResponse));
            if (!commonResponse.isSuccess()) {
                throw new BusinessException(commonResponse.getMsg());
            }
        }
        e.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success();
    }
}

