/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentalSettlementStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentRentalService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentRentalVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"rentRental"})
@Api(value="\u79df\u91d1\u8ba1\u7b97\u4e3b\u8868", tags={"\u79df\u91d1\u8ba1\u7b97\u4e3b\u8868"})
public class RentRentalController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRentRentalService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentRentalVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody RentRentalVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveRental(saveOrUpdateVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentRentalVO> queryDetail(@RequestParam Long id) {
        RentRentalEntity entity = (RentRentalEntity)((Object)this.service.selectById(id));
        RentRentalVO vo = (RentRentalVO)BeanMapper.map((Object)((Object)entity), RentRentalVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentRentalVO> pushCost(@RequestBody RentRentalVO vo) {
        return CommonResponse.success((String)"\u6ca1\u6709\u5b9e\u9645\u6210\u672c\u63a8\u9001\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentRentalVO> vos) {
        this.service.delRental(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RentRentalVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentRentalVO.class));
        this.setDefaultName(pageData.getRecords());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    private void setDefaultName(List<RentRentalVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (RentRentalVO vo : list) {
                vo.setSettlementStateName(RentalSettlementStateEnum.getEnumByCode(vo.getSettlementState()).getDescription());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(vo.getBillState())) {
                    vo.setBillStateName("\u5ba1\u6838\u4e2d");
                }
                if (!BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(vo.getBillState())) continue;
                vo.setBillStateName("\u5ba1\u6838\u4e2d");
            }
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, RentRentalVO.class);
        this.setDefaultName(voList);
        beans.put("records", voList);
        ExcelExport.getInstance().export("RentRental-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refRentRentalData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentRentalVO>> refRentRentalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("meterRentTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("settlementState", new Parameter("eq", (Object)RentalSettlementStateEnum.\u672a\u7ed3\u7b97.getCode()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            _con = JSONObject.parseObject((String)condition);
            if (!_con.containsKey((Object)"contractId")) {
                throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        } else {
            throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        param.getParams().put("contractId", new Parameter("eq", _con.get((Object)"contractId")));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentRentalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/automaticRental"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentRentalVO> automaticRental(@RequestBody RentRentalVO vo) {
        RentRentalVO rentRentalVO = this.service.automaticRental(vo);
        return CommonResponse.success((String)"\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\u6210\u529f\uff01", (Object)rentRentalVO);
    }
}

