/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.rental.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentalSettlementStateEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalDayEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalMonthEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalQuantitiesEntity;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalService;
import com.ejianc.business.proequipmentcorpout.rental.vo.OutRentRentalVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRentRental")
public class OutRentRentalBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRentRentalService service;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IOutRentParameterService parameterService;
    @Autowired
    private IOutRentParameterDetailService outRentParameterDetailService;
    @Autowired
    private IRentReceiptsApi receiptsApi;
    @Autowired
    private IOutRentContractService contractService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRentRentalEntity entity = (OutRentRentalEntity)((Object)this.service.selectById(billId));
        this.logger.info("\u63a8\u9001\u6210\u672c---");
        if ("1".equals(entity.getRentalType())) {
            List<OutRentParameterVO> rentParameterList = this.parameterService.getRentParameterByContractId(entity.getContractId(), entity.getId(), entity.getRentalDate());
            ArrayList<OutRentParameterDetailEntity> parameterDetailList = new ArrayList<OutRentParameterDetailEntity>();
            for (OutRentParameterVO rentParameterVO : rentParameterList) {
                OutRentParameterEntity rentParameterEntity = (OutRentParameterEntity)((Object)BeanMapper.map((Object)rentParameterVO, OutRentParameterEntity.class));
                OutRentParameterDetailEntity detailEntity = new OutRentParameterDetailEntity();
                detailEntity.setSourceType(RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode());
                detailEntity.setSourceId(entity.getId());
                detailEntity.setOperationDate(entity.getRentalDate());
                QueryParam detailParam = new QueryParam();
                detailParam.getParams().put("parameterId", new Parameter("eq", (Object)rentParameterEntity.getId()));
                detailParam.getOrderMap().put("createTime", "desc");
                List detailList = this.outRentParameterDetailService.queryList(detailParam, false);
                if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                    detailEntity.setEquipmentState(((OutRentParameterDetailEntity)((Object)detailList.get(0))).getEquipmentState());
                } else {
                    detailEntity.setEquipmentState(rentParameterEntity.getEquipmentState());
                }
                detailEntity.setParameterId(rentParameterEntity.getId());
                parameterDetailList.add(detailEntity);
            }
            if (CollectionUtils.isNotEmpty(parameterDetailList)) {
                this.outRentParameterDetailService.saveOrUpdateBatch(parameterDetailList);
            }
        }
        if (entity.getRentHarborType() == 1) {
            OutRentRentalVO outRentRentalVO = (OutRentRentalVO)BeanMapper.map((Object)((Object)entity), OutRentRentalVO.class);
            this.logger.info("\u63a8\u9001\u9879\u76ee\u65b9\u6570\u636eoutRentRentalVO\uff1a{}", (Object)JSONObject.toJSONString((Object)outRentRentalVO));
            outRentRentalVO.setOrgId(outRentRentalVO.getOutOrgId());
            outRentRentalVO.setOrgName(outRentRentalVO.getOutOrgName());
            outRentRentalVO.setOrgCode(outRentRentalVO.getOutOrgCode());
            outRentRentalVO.setRentType(outRentRentalVO.getRentHarborType());
            outRentRentalVO.setRentTypeName(outRentRentalVO.getRentHarborTypeName());
            CommonResponse response = this.receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON((Object)outRentRentalVO), RentReceiptsEnum.\u79df\u91d1\u8ba1\u7b97\u5355.getName());
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse response;
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01" + resp.getMsg()));
        }
        OutRentRentalEntity entity = (OutRentRentalEntity)((Object)this.service.selectById(billId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)entity.getContractId()));
        List parameterEntityList = this.parameterService.queryList(queryParam);
        this.parameterService.checkNoEffectData(parameterEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()), billId, entity.getContractId());
        if (RentalSettlementStateEnum.\u5df2\u7ed3\u7b97.getCode().equals(entity.getSettlementState())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u7ed3\u7b97\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        if (contractEntity != null && PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode().equals(contractEntity.getContractPerformanceState())) {
            return CommonResponse.error((String)"\u5408\u540c\u5df2\u7ec8\u6b62\uff0c\u8be5\u5355\u636e\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        QueryWrapper listQueryOrderByTime = new QueryWrapper();
        listQueryOrderByTime.eq((Object)"contract_id", (Object)entity.getContractId());
        listQueryOrderByTime.orderByDesc((Object)"create_time");
        List listOrderByTime = this.service.list((Wrapper)listQueryOrderByTime);
        if (CollectionUtils.isNotEmpty((Collection)listOrderByTime) && null != listOrderByTime.get(0)) {
            this.logger.info("\u67e5\u51fa\u79df\u91d1\u8ba1\u7b97\u5355\u96c6\u5408\uff1a{},billId\uff1a{}", (Object)JSONObject.toJSONString((Object)listOrderByTime), (Object)billId);
            this.logger.info(billId + "");
            this.logger.info(((OutRentRentalEntity)((Object)listOrderByTime.get(0))).getId() + "");
            if (!(((OutRentRentalEntity)((Object)listOrderByTime.get(0))).getId() + "").equals(billId + "")) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u8be5\u5408\u540c\u4e0b\u6700\u65b0\u7684\u79df\u91d1\u8ba1\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
        }
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-Id---{}", (Object)entity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(entity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(OutRentRentalEntity::getRelationFlag, (Object)"0");
        this.service.update((Wrapper)updateWrapper);
        if ("1".equals(entity.getRentalType())) {
            List sourceIdList;
            ArrayList parameterIdList = new ArrayList();
            List<OutRentRentalDayEntity> dayList = entity.getRentRentalDayList();
            List<OutRentRentalMonthEntity> monthList = entity.getRentRentalMonthList();
            List<OutRentRentalQuantitiesEntity> qList = entity.getRentRentalQuantitiesList();
            if (CollectionUtils.isNotEmpty(dayList)) {
                sourceIdList = dayList.stream().map(OutRentRentalDayEntity::getSourceId).collect(Collectors.toList());
                parameterIdList.addAll(sourceIdList);
            }
            if (CollectionUtils.isNotEmpty(monthList)) {
                sourceIdList = monthList.stream().map(OutRentRentalMonthEntity::getSourceId).collect(Collectors.toList());
                parameterIdList.addAll(sourceIdList);
            }
            if (CollectionUtils.isNotEmpty(qList)) {
                sourceIdList = qList.stream().map(OutRentRentalQuantitiesEntity::getSourceId).collect(Collectors.toList());
                parameterIdList.addAll(sourceIdList);
            }
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("parameterId", new Parameter("in", parameterIdList));
            detailParam.getParams().put("source_id", new Parameter("eq", (Object)billId));
            detailParam.getOrderMap().put("createTime", "desc");
            List parameterDetailList = this.outRentParameterDetailService.queryList(detailParam, false);
            if (CollectionUtils.isNotEmpty((Collection)parameterDetailList)) {
                this.outRentParameterDetailService.removeByIds(parameterDetailList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            }
        }
        if (entity.getRentHarborType() == 1 && !(response = this.receiptsApi.delReceipts(entity.getId(), RentReceiptsEnum.\u79df\u91d1\u8ba1\u7b97\u5355.getName())).isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        return CommonResponse.success();
    }
}

