/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorprent.appearance.bean.AppearanceEntity;
import com.ejianc.business.proequipmentcorprent.appearance.bean.AppearanceSubEntity;
import com.ejianc.business.proequipmentcorprent.appearance.service.IAppearanceService;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStartEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopSubEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.mapper.RentParameterMapper;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentStartService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentStopService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterDetailService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentRentalService;
import com.ejianc.business.proequipmentcorprent.rent.vo.EquipmentNewDateVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentParameterVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentParameterService")
public class RentParameterServiceImpl
extends BaseServiceImpl<RentParameterMapper, RentParameterEntity>
implements IRentParameterService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RentParameterMapper rentParameterMapper;
    @Autowired
    private IRentParameterDetailService rentParameterDetailService;
    @Autowired
    private IRentEquipmentStartService startService;
    @Autowired
    private IRentEquipmentStopService stopService;
    @Autowired
    private IAppearanceService appearanceService;
    @Autowired
    private IRentRentalService rentRentalService;

    @Override
    public RentParameterEntity selectByContractIdOrderTime(Long contractId, Long acceptanceId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        if (acceptanceId != null) {
            query.eq((Object)"acceptance_id", (Object)acceptanceId);
        }
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"bill_state", new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        query.orderByDesc((Object)"operation_date");
        List list = this.rentParameterMapper.selectList((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            RentParameterEntity entity = (RentParameterEntity)((Object)list.get(0));
            return entity;
        }
        return null;
    }

    @Override
    public CommonResponse<String> selectValidationNewDate(Long contractId, Date myDate, Long id) {
        List<EquipmentNewDateVO> list = this.rentParameterMapper.queryNewDate(InvocationInfoProxy.getTenantid(), contractId, myDate);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (CollectionUtils.isNotEmpty(list)) {
            EquipmentNewDateVO dateVO = list.get(0);
            if (id == null) {
                if (dateVO.getNum() > 1) {
                    return CommonResponse.error((String)("\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e" + dateVO.getType() + "\u5355\u636e\u4e2d\u7684\u521b\u5efa\u65e5\u671f" + sdf.format(dateVO.getPerformDate())));
                }
                return CommonResponse.error((String)("\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e" + dateVO.getType() + "\u5355\u636e\u4e2d\u7684" + dateVO.getType() + "\u65e5\u671f" + sdf.format(dateVO.getPerformDate())));
            }
            if (!id.equals(dateVO.getId())) {
                if (dateVO.getNum() > 1) {
                    return CommonResponse.error((String)("\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e" + dateVO.getType() + "\u5355\u636e\u4e2d\u7684\u521b\u5efa\u65e5\u671f" + sdf.format(dateVO.getPerformDate())));
                }
                return CommonResponse.error((String)("\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e" + dateVO.getType() + "\u5355\u636e\u4e2d\u7684" + dateVO.getType() + "\u65e5\u671f" + sdf.format(dateVO.getPerformDate())));
            }
        }
        return CommonResponse.success();
    }

    @Override
    public EquipmentNewDateVO selectAbandonDate(Long contractId, Date myDate) {
        List<EquipmentNewDateVO> list = this.rentParameterMapper.queryNewDate(InvocationInfoProxy.getTenantid(), contractId, myDate);
        if (CollectionUtils.isNotEmpty(list)) {
            EquipmentNewDateVO dateVO = list.get(0);
            return dateVO;
        }
        return null;
    }

    @Override
    public void deleteAcceptanceId(Long acceptanceId) {
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.eq((Object)"acceptance_id", (Object)acceptanceId);
        List entitys = super.list((Wrapper)deleteWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entitys)) {
            super.removeByIds((Collection)entitys.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
        }
    }

    @Override
    public EquipmentNewDateVO selectValidationNewDateList(Long contractId, Date myDate, Long id) {
        List<EquipmentNewDateVO> list = this.rentParameterMapper.queryNewDate(InvocationInfoProxy.getTenantid(), contractId, myDate);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (CollectionUtils.isNotEmpty(list)) {
            EquipmentNewDateVO dateVO = list.get(0);
            if (id == null) {
                return dateVO;
            }
            if (!id.equals(dateVO.getId())) {
                return dateVO;
            }
        }
        return null;
    }

    @Override
    public EquipmentNewDateVO selectValidationNewDateSub(Long contractId) {
        List<EquipmentNewDateVO> list = this.rentParameterMapper.queryNewDateList(InvocationInfoProxy.getTenantid(), contractId);
        if (CollectionUtils.isNotEmpty(list)) {
            EquipmentNewDateVO dateVO = list.get(0);
            return dateVO;
        }
        return null;
    }

    @Override
    public void changeParameter(List<RentParameterEntity> parameterList, String sourceType) {
        this.logger.info("\u8fdb\u5165\u8bbe\u5907\u53f0\u8d26\u53d8\u66f4\u65b9\u6cd5\uff0c\u53d8\u66f4\u7c7b\u578b\uff1a{}\uff0c\u53d8\u66f4\u53c2\u6570\uff1a{}", (Object)RentParameterTypeEnum.getEnumByCode(sourceType).getDescription(), (Object)JSONObject.toJSONString(parameterList));
        if (CollectionUtils.isEmpty(parameterList)) {
            return;
        }
        HashMap<Long, RentParameterEntity> map = new HashMap<Long, RentParameterEntity>();
        ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
        for (RentParameterEntity entity : parameterList) {
            map.put(entity.getId(), entity);
            for (RentParameterDetailEntity detailEntity : entity.getRentParameterDetailList()) {
                detailEntity.setParameterId(entity.getId());
            }
            parameterDetailList.addAll(entity.getRentParameterDetailList());
        }
        QueryParam queryParam = new QueryParam();
        List parameterIdList = parameterList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        queryParam.getParams().put("id", new Parameter("in", parameterIdList));
        List saveList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)saveList)) {
            for (RentParameterEntity saveEntity : saveList) {
                RentParameterEntity entity = (RentParameterEntity)((Object)map.get(saveEntity.getId()));
                saveEntity.setEquipmentState(entity.getEquipmentState());
                if (RentParameterTypeEnum.\u542f\u7528\u5355.getCode().equals(sourceType)) {
                    saveEntity.setStartDate(entity.getStartDate());
                    if (null != entity.getMeterRentDate()) {
                        saveEntity.setMeterRentDate(entity.getMeterRentDate());
                    }
                } else if (RentParameterTypeEnum.\u505c\u7528\u5355.getCode().equals(sourceType)) {
                    saveEntity.setStopDate(entity.getStopDate());
                } else if (RentParameterTypeEnum.\u9000\u573a\u5355.getCode().equals(sourceType)) {
                    saveEntity.setOutDate(entity.getOutDate());
                } else if (RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode().equals(sourceType)) {
                    if (RentEquipmentStateEnum.\u542f\u7528.getCode().equals(saveEntity.getEquipmentState())) {
                        saveEntity.setStartDate(entity.getOperationDate());
                    } else if (RentEquipmentStateEnum.\u505c\u7528.getCode().equals(saveEntity.getEquipmentState())) {
                        saveEntity.setStopDate(entity.getOperationDate());
                    } else if (RentEquipmentStateEnum.\u9000\u573a.getCode().equals(saveEntity.getEquipmentState())) {
                        saveEntity.setOutDate(entity.getOperationDate());
                    }
                }
                saveEntity.setOperationDate(new Date());
            }
            this.logger.info("\u63d2\u5165\u6570\u636e------" + JSONObject.toJSONString((Object)saveList));
            super.saveOrUpdateBatch((Collection)saveList);
        }
        if (CollectionUtils.isNotEmpty(parameterDetailList)) {
            this.rentParameterDetailService.saveOrUpdateBatch(parameterDetailList);
        }
    }

    @Override
    public void cancelParameter(List<Long> parameterIdList, String sourceType, Long sourceId) {
        this.logger.info("\u8fdb\u5165\u8bbe\u5907\u53f0\u8d26\u64a4\u56de\u65b9\u6cd5\uff0c\u64a4\u9500\u7c7b\u578b\uff1a{}\uff0c\u64a4\u9500\u5355\u636eid\uff1a{}\uff0c\u64a4\u9500\u53c2\u6570\uff1a{}", new Object[]{RentParameterTypeEnum.getEnumByCode(sourceType).getDescription(), sourceId, JSONObject.toJSONString(parameterIdList)});
        this.rentParameterDetailService.delParameterDetail(sourceId, sourceType);
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("parameterId", new Parameter("in", parameterIdList));
        detailParam.getOrderMap().put("createTime", "desc");
        List parameterDetailList = this.rentParameterDetailService.queryList(detailParam, false);
        LinkedHashMap<Long, RentParameterDetailEntity> map = new LinkedHashMap<Long, RentParameterDetailEntity>();
        for (RentParameterDetailEntity detailEntity : parameterDetailList) {
            if (map.containsKey(detailEntity.getParameterId())) continue;
            map.put(detailEntity.getParameterId(), detailEntity);
        }
        QueryParam saveParam = new QueryParam();
        saveParam.getParams().put("id", new Parameter("in", parameterIdList));
        List saveList = super.queryList(saveParam, false);
        for (RentParameterEntity saveEntity : saveList) {
            RentParameterDetailEntity detailEntity = (RentParameterDetailEntity)((Object)map.get(saveEntity.getId()));
            saveEntity.setEquipmentState(detailEntity.getEquipmentState());
            if (RentEquipmentStateEnum.\u542f\u7528.getCode().equals(detailEntity.getEquipmentState())) {
                saveEntity.setStartDate(detailEntity.getOperationDate());
                if (RentParameterTypeEnum.\u505c\u7528\u5355.getCode().equals(sourceType)) {
                    saveEntity.setStopDate(null);
                }
                if (RentParameterTypeEnum.\u9000\u573a\u5355.getCode().equals(sourceType)) {
                    saveEntity.setOutDate(null);
                }
            } else if (RentEquipmentStateEnum.\u505c\u7528.getCode().equals(detailEntity.getEquipmentState())) {
                saveEntity.setStopDate(detailEntity.getOperationDate());
                if (RentParameterTypeEnum.\u542f\u7528\u5355.getCode().equals(sourceType)) {
                    saveEntity.setStartDate(null);
                }
                if (RentParameterTypeEnum.\u9000\u573a\u5355.getCode().equals(sourceType)) {
                    saveEntity.setOutDate(null);
                }
            } else if (RentEquipmentStateEnum.\u9000\u573a.getCode().equals(detailEntity.getEquipmentState())) {
                saveEntity.setOutDate(detailEntity.getOperationDate());
            }
            saveEntity.setOperationDate(new Date());
        }
        super.saveOrUpdateBatch((Collection)saveList);
    }

    @Override
    public void checkValidation(List<Long> parameterIdList, String sourceType, Long sourceId, Long contractId, Date myDate) {
        List appearanceEntityList;
        List stopEntityList;
        List startEntityList;
        this.logger.info("\u8fdb\u884c\u5355\u636e\u4fdd\u5b58\u524d\u6821\u9a8c\uff0c\u6821\u9a8c\u53c2\u6570\uff1aparameterIdList\uff1a{}\uff0csourceType\uff1a{}\uff0csourceTypeName:{}\uff0csourceId:{}\uff0ccontractId:{}\uff0cmyDate\uff1a{}", new Object[]{JSONObject.toJSONString(parameterIdList), sourceType, RentParameterTypeEnum.getEnumByCode(sourceType).getDescription(), sourceId, contractId, myDate});
        if (CollectionUtils.isEmpty(parameterIdList)) {
            return;
        }
        String sourceTypeName = RentParameterTypeEnum.\u542f\u7528\u5355.getCode().equals(sourceType) ? "\u542f\u7528" : (RentParameterTypeEnum.\u505c\u7528\u5355.getCode().equals(sourceType) ? "\u505c\u7528" : (RentParameterTypeEnum.\u9000\u573a\u5355.getCode().equals(sourceType) ? "\u9000\u573a" : (RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode().equals(sourceType) ? "\u79df\u91d1\u8ba1\u7b97" : "")));
        QueryParam parameterParam = new QueryParam();
        parameterParam.getParams().put("id", new Parameter("in", parameterIdList));
        List parameterEntityList = super.queryList(parameterParam, false);
        HashMap<Long, RentParameterEntity> parameterEntityMap = new HashMap<Long, RentParameterEntity>();
        StringBuilder sb = new StringBuilder();
        for (RentParameterEntity entity : parameterEntityList) {
            parameterEntityMap.put(entity.getId(), entity);
            if ((!RentParameterTypeEnum.\u542f\u7528\u5355.getCode().equals(sourceType) || !RentEquipmentStateEnum.\u542f\u7528.getCode().equals(entity.getEquipmentState())) && (!RentParameterTypeEnum.\u505c\u7528\u5355.getCode().equals(sourceType) || !RentEquipmentStateEnum.\u505c\u7528.getCode().equals(entity.getEquipmentState()))) continue;
            sb.append("\u8bbe\u5907[").append(entity.getEquipmentName()).append("]\u3001");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
            sb.append("\u5df2").append(sourceTypeName).append("\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e");
            throw new BusinessException(sb.toString());
        }
        QueryParam checkQueryParam = new QueryParam();
        checkQueryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        checkQueryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        if (sourceId != null) {
            checkQueryParam.getParams().put("id", new Parameter("ne", (Object)sourceId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(startEntityList = this.startService.queryList(checkQueryParam, false)))) {
            for (Object rentEquipmentStartEntity : startEntityList) {
                for (Object rentEquipmentStartSubEntity : ((RentEquipmentStartEntity)((Object)rentEquipmentStartEntity)).getRentEquipmentStartSubList()) {
                    if (!parameterIdList.contains(rentEquipmentStartSubEntity.getSourceId())) continue;
                    throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u542f\u7528\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(stopEntityList = this.stopService.queryList(checkQueryParam, false)))) {
            for (Object rentEquipmentStopEntity : stopEntityList) {
                for (Object rentEquipmentStopSubEntity : ((RentEquipmentStopEntity)((Object)rentEquipmentStopEntity)).getRentEquipmentStopSubList()) {
                    if (!parameterIdList.contains(rentEquipmentStopSubEntity.getSourceId())) continue;
                    throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u505c\u7528\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(appearanceEntityList = this.appearanceService.queryList(checkQueryParam, false)))) {
            for (AppearanceEntity appearanceEntity : appearanceEntityList) {
                for (AppearanceSubEntity appearanceSubEntity : appearanceEntity.getAppearanceSubList()) {
                    if (!parameterIdList.contains(appearanceSubEntity.getSourceId())) continue;
                    throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u9000\u573a\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
                }
            }
        }
        checkQueryParam.getParams().put("rentalType", new Parameter("eq", (Object)"1"));
        List rentalEntityList = this.rentRentalService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)rentalEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u79df\u91d1\u8ba1\u7b97\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
        }
        QueryParam dateParam = new QueryParam();
        dateParam.getParams().put("parameterId", new Parameter("in", parameterIdList));
        dateParam.getOrderMap().put("createTime", "desc");
        List parameterDetailList = this.rentParameterDetailService.queryList(dateParam, false);
        LinkedHashMap<Long, RentParameterDetailEntity> map = new LinkedHashMap<Long, RentParameterDetailEntity>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (RentParameterDetailEntity detailEntity : parameterDetailList) {
            if (map.containsKey(detailEntity.getParameterId())) continue;
            map.put(detailEntity.getParameterId(), detailEntity);
            if (myDate.after(detailEntity.getOperationDate())) continue;
            RentParameterEntity entity = (RentParameterEntity)((Object)parameterEntityMap.get(detailEntity.getParameterId()));
            sb.append("\u8bbe\u5907[").append(entity.getEquipmentName()).append("]").append(sourceTypeName).append("\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e").append(sdf.format(detailEntity.getOperationDate())).append(",");
            if (!RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode().equals(sourceType)) continue;
            throw new BusinessException(sourceTypeName + "\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e" + sdf.format(detailEntity.getOperationDate()));
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
            throw new BusinessException(sb.toString());
        }
    }

    @Override
    public void checkNoEffectData(List<Long> parameterIdList, Long sourceId, Long contractId) {
        List appearanceEntityList;
        List stopEntityList;
        List startEntityList;
        this.logger.info("\u8fdb\u884c\u5355\u636e\u64a4\u56de\u524d\u6821\u9a8c\uff0c\u6821\u9a8c\u53c2\u6570\uff1aparameterIdList\uff1a{}\uff0csourceId:{}\uff0ccontractId:{}", new Object[]{JSONObject.toJSONString(parameterIdList), sourceId, contractId});
        QueryParam checkQueryParam = new QueryParam();
        checkQueryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        checkQueryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        if (sourceId != null) {
            checkQueryParam.getParams().put("id", new Parameter("ne", (Object)sourceId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(startEntityList = this.startService.queryList(checkQueryParam, false)))) {
            for (Object rentEquipmentStartEntity : startEntityList) {
                for (Object rentEquipmentStartSubEntity : ((RentEquipmentStartEntity)((Object)rentEquipmentStartEntity)).getRentEquipmentStartSubList()) {
                    if (!parameterIdList.contains(rentEquipmentStartSubEntity.getSourceId())) continue;
                    throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u542f\u7528\u5355\uff0c\u65e0\u6cd5\u64a4\u56de\u5355\u636e\uff01");
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(stopEntityList = this.stopService.queryList(checkQueryParam, false)))) {
            for (Object rentEquipmentStopEntity : stopEntityList) {
                for (RentEquipmentStopSubEntity rentEquipmentStopSubEntity : ((RentEquipmentStopEntity)((Object)rentEquipmentStopEntity)).getRentEquipmentStopSubList()) {
                    if (!parameterIdList.contains(rentEquipmentStopSubEntity.getSourceId())) continue;
                    throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u505c\u7528\u5355\uff0c\u65e0\u6cd5\u64a4\u56de\u5355\u636e\uff01");
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(appearanceEntityList = this.appearanceService.queryList(checkQueryParam, false)))) {
            for (AppearanceEntity appearanceEntity : appearanceEntityList) {
                for (AppearanceSubEntity appearanceSubEntity : appearanceEntity.getAppearanceSubList()) {
                    if (!parameterIdList.contains(appearanceSubEntity.getSourceId())) continue;
                    throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u9000\u573a\u5355\uff0c\u65e0\u6cd5\u64a4\u56de\u5355\u636e\uff01");
                }
            }
        }
        checkQueryParam.getParams().put("rentalType", new Parameter("eq", (Object)"1"));
        List rentalEntityList = this.rentRentalService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)rentalEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u79df\u91d1\u8ba1\u7b97\u5355\uff0c\u65e0\u6cd5\u64a4\u56de\u5355\u636e\uff01");
        }
    }

    @Override
    public void checkValidationSub(List<Long> parameterIdList, Map<Long, Date> detailMap, String sourceType, Long sourceId, Long contractId, Date myDate) {
        List appearanceEntityList;
        List stopEntityList;
        List startEntityList;
        this.logger.info("\u8fdb\u884c\u5355\u636e\u4fdd\u5b58\u524d\u6821\u9a8c\uff0c\u6821\u9a8c\u53c2\u6570\uff1aparameterIdList\uff1a{}\uff0csourceType\uff1a{}\uff0csourceTypeName:{}\uff0csourceId:{}\uff0ccontractId:{}\uff0cmyDate\uff1a{}", new Object[]{JSONObject.toJSONString(parameterIdList), sourceType, RentParameterTypeEnum.getEnumByCode(sourceType).getDescription(), sourceId, contractId, myDate});
        if (CollectionUtils.isEmpty(parameterIdList)) {
            return;
        }
        String sourceTypeName = RentParameterTypeEnum.\u542f\u7528\u5355.getCode().equals(sourceType) ? "\u542f\u7528" : (RentParameterTypeEnum.\u505c\u7528\u5355.getCode().equals(sourceType) ? "\u505c\u7528" : (RentParameterTypeEnum.\u9000\u573a\u5355.getCode().equals(sourceType) ? "\u9000\u573a" : (RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode().equals(sourceType) ? "\u79df\u91d1\u8ba1\u7b97" : "")));
        QueryParam parameterParam = new QueryParam();
        parameterParam.getParams().put("id", new Parameter("in", parameterIdList));
        List parameterEntityList = super.queryList(parameterParam, false);
        HashMap<Long, RentParameterEntity> parameterEntityMap = new HashMap<Long, RentParameterEntity>();
        StringBuilder sb = new StringBuilder();
        for (RentParameterEntity entity : parameterEntityList) {
            parameterEntityMap.put(entity.getId(), entity);
            if ((!RentParameterTypeEnum.\u542f\u7528\u5355.getCode().equals(sourceType) || !RentEquipmentStateEnum.\u542f\u7528.getCode().equals(entity.getEquipmentState())) && (!RentParameterTypeEnum.\u505c\u7528\u5355.getCode().equals(sourceType) || !RentEquipmentStateEnum.\u505c\u7528.getCode().equals(entity.getEquipmentState()))) continue;
            sb.append("\u8bbe\u5907[").append(entity.getEquipmentName()).append("]\u3001");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
            sb.append("\u5df2").append(sourceTypeName).append("\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e");
            throw new BusinessException(sb.toString());
        }
        QueryParam checkQueryParam = new QueryParam();
        checkQueryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        checkQueryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        if (sourceId != null) {
            checkQueryParam.getParams().put("id", new Parameter("ne", (Object)sourceId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(startEntityList = this.startService.queryList(checkQueryParam, false)))) {
            for (Object rentEquipmentStartEntity : startEntityList) {
                for (Object rentEquipmentStartSubEntity : ((RentEquipmentStartEntity)((Object)rentEquipmentStartEntity)).getRentEquipmentStartSubList()) {
                    if (!parameterIdList.contains(rentEquipmentStartSubEntity.getSourceId())) continue;
                    throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u542f\u7528\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(stopEntityList = this.stopService.queryList(checkQueryParam, false)))) {
            for (Object rentEquipmentStopEntity : stopEntityList) {
                for (Object rentEquipmentStopSubEntity : ((RentEquipmentStopEntity)((Object)rentEquipmentStopEntity)).getRentEquipmentStopSubList()) {
                    if (!parameterIdList.contains(rentEquipmentStopSubEntity.getSourceId())) continue;
                    throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u505c\u7528\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(appearanceEntityList = this.appearanceService.queryList(checkQueryParam, false)))) {
            for (AppearanceEntity appearanceEntity : appearanceEntityList) {
                for (AppearanceSubEntity appearanceSubEntity : appearanceEntity.getAppearanceSubList()) {
                    if (!parameterIdList.contains(appearanceSubEntity.getSourceId())) continue;
                    throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u9000\u573a\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
                }
            }
        }
        checkQueryParam.getParams().put("rentalType", new Parameter("eq", (Object)"1"));
        List rentalEntityList = this.rentRentalService.queryList(checkQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)rentalEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u79df\u91d1\u8ba1\u7b97\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff01");
        }
        QueryParam dateParam = new QueryParam();
        dateParam.getParams().put("parameterId", new Parameter("in", parameterIdList));
        dateParam.getOrderMap().put("createTime", "desc");
        List parameterDetailList = this.rentParameterDetailService.queryList(dateParam, false);
        LinkedHashMap<Long, RentParameterDetailEntity> map = new LinkedHashMap<Long, RentParameterDetailEntity>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (RentParameterDetailEntity detailEntity : parameterDetailList) {
            if (map.containsKey(detailEntity.getParameterId())) continue;
            map.put(detailEntity.getParameterId(), detailEntity);
            if (detailMap.containsKey(detailEntity.getParameterId()) && null != detailMap.get(detailEntity.getParameterId())) {
                myDate = detailMap.get(detailEntity.getParameterId());
            }
            if (myDate.after(detailEntity.getOperationDate())) continue;
            RentParameterEntity entity = (RentParameterEntity)((Object)parameterEntityMap.get(detailEntity.getParameterId()));
            sb.append("\u8bbe\u5907[").append(entity.getEquipmentName()).append("]").append(sourceTypeName).append("\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e").append(sdf.format(detailEntity.getOperationDate())).append(",");
            if (!RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode().equals(sourceType)) continue;
            throw new BusinessException(sourceTypeName + "\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e" + sdf.format(detailEntity.getOperationDate()));
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
            throw new BusinessException(sb.toString());
        }
    }

    @Override
    public List<RentParameterVO> getRentParameterByContractId(Long contractId, Long sourceId, Date endDate) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("equipmentState", new Parameter("ne", (Object)RentEquipmentStateEnum.\u5f85\u542f\u7528.getCode()));
        List list = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        List<Long> parameterIdList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.checkValidation(parameterIdList, RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode(), sourceId, contractId, endDate);
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("parameterId", new Parameter("in", parameterIdList));
        detailParam.getParams().put("operationDate", new Parameter("le", (Object)endDate));
        detailParam.getOrderMap().put("operationDate", "desc");
        detailParam.getOrderMap().put("createTime", "desc");
        List parameterDetailList = this.rentParameterDetailService.queryList(detailParam, false);
        HashMap map = new HashMap();
        for (RentParameterDetailEntity detailEntity : parameterDetailList) {
            if (map.containsKey(detailEntity.getParameterId())) {
                ((List)map.get(detailEntity.getParameterId())).add(detailEntity);
                continue;
            }
            ArrayList<RentParameterDetailEntity> packList = new ArrayList<RentParameterDetailEntity>();
            packList.add(detailEntity);
            map.put(detailEntity.getParameterId(), packList);
        }
        for (RentParameterEntity entity : list) {
            List detailEntityList = (List)map.get(entity.getId());
            ArrayList<RentParameterDetailEntity> addDetailList = new ArrayList<RentParameterDetailEntity>();
            for (RentParameterDetailEntity detailEntity : detailEntityList) {
                if (RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode().equals(detailEntity.getSourceType())) {
                    detailEntity.setOperationDate(this.calculationDay(detailEntity.getOperationDate(), 1));
                    addDetailList.add(detailEntity);
                    break;
                }
                addDetailList.add(detailEntity);
            }
            addDetailList.sort(Comparator.comparing(RentParameterDetailEntity::getOperationDate));
            entity.setRentParameterDetailList(addDetailList);
        }
        return BeanMapper.mapList((Iterable)list, RentParameterVO.class);
    }

    private Date calculationDay(Date date, Integer days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, days);
        return calendar.getTime();
    }

    @Override
    public Boolean selectAppearanceCodeList(String factoryCode) {
        List<RentParameterVO> list = ((RentParameterMapper)this.baseMapper).selectAppearanceCodeList(factoryCode);
        if (CollectionUtils.isNotEmpty(list)) {
            return true;
        }
        return false;
    }
}

