/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopSubEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentStopService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterDetailService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="rentEquipmentStop")
public class RentEquipmentStopBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IRentParameterService rentParameterService;
    @Autowired
    private IRentEquipmentStopService stopService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentEquipmentStopService rentEquipmentStopService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRentParameterDetailService rentParameterDetailService;
    @Autowired
    private IRentContractService contractService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/deleteStop";
    private final String OPERATE = "RENT-PROEQUIPMENT-ASTOP";
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    private static final String BILL_TYPE = "BT220221000000004";
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/saveStop";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStopEntity entity = (RentEquipmentStopEntity)((Object)this.rentEquipmentStopService.selectById(billId));
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceId", billId);
            map.put("systemId", ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = this.rentAcceptanceService.updateSupplierStatus(billId, dataInfo, "/ejc-supbusiness-web/openapi/equipmentStop/deleteStop", RequestMethod.POST, entity.getSupplierId().toString(), "RENT-PROEQUIPMENT-ASTOP", BILL_TYPE);
            if (!updateSupplierStatus.booleanValue()) {
                throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.rentEquipmentStopService.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5230\u8bbe\u5907\u505c\u7528\u4e86.....{}", (Object)billId);
        RentEquipmentStopEntity stopEntity = (RentEquipmentStopEntity)((Object)this.stopService.selectById(billId));
        List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
        ArrayList<RentParameterEntity> parameterList = new ArrayList<RentParameterEntity>();
        if (1 == stopEntity.getEntranceRentFlag()) {
            for (RentEquipmentStopSubEntity subEntity : subEntityList) {
                RentParameterEntity parameterEntity = new RentParameterEntity();
                parameterEntity.setId(subEntity.getSourceId());
                parameterEntity.setStopDate(subEntity.getTypeDate());
                parameterEntity.setRentEndDate(subEntity.getTypeDate());
                parameterEntity.setOperationDate(new Date());
                parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u505c\u79df.getCode());
                parameterEntity.setUseType(2);
                ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
                RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
                detailEntity.setSourceType(RentParameterTypeEnum.\u9000\u573a\u5355.getCode());
                detailEntity.setSourceId(stopEntity.getId());
                detailEntity.setOperationDate(subEntity.getTypeDate());
                detailEntity.setEquipmentState(RentEquipmentStateEnum.\u9000\u573a.getCode());
                detailEntity.setParameterId(subEntity.getSourceId());
                parameterDetailList.add(detailEntity);
                parameterEntity.setRentParameterDetailList(parameterDetailList);
                parameterList.add(parameterEntity);
            }
        } else {
            for (RentEquipmentStopSubEntity subEntity : subEntityList) {
                RentParameterEntity parameterEntity = new RentParameterEntity();
                parameterEntity.setId(subEntity.getSourceId());
                parameterEntity.setStopDate(subEntity.getTypeDate());
                parameterEntity.setOperationDate(new Date());
                parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u505c\u7528.getCode());
                parameterEntity.setUseType(2);
                ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
                RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
                detailEntity.setSourceType(RentParameterTypeEnum.\u505c\u7528\u5355.getCode());
                detailEntity.setSourceId(stopEntity.getId());
                detailEntity.setOperationDate(subEntity.getTypeDate());
                detailEntity.setEquipmentState(RentEquipmentStateEnum.\u505c\u7528.getCode());
                detailEntity.setParameterId(subEntity.getSourceId());
                parameterDetailList.add(detailEntity);
                parameterEntity.setRentParameterDetailList(parameterDetailList);
                parameterList.add(parameterEntity);
            }
        }
        this.rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.\u505c\u7528\u5355.getCode());
        this.stopService.updateById((Object)stopEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStopEntity stopEntity = (RentEquipmentStopEntity)((Object)this.stopService.selectById(billId));
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.contractService.selectById(stopEntity.getContractId()));
        if (contractEntity != null && PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode().equals(contractEntity.getContractPerformanceState())) {
            return CommonResponse.error((String)"\u5408\u540c\u5df2\u7ec8\u6b62\uff0c\u8be5\u5355\u636e\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        List<Long> parameterIdList = stopEntity.getRentEquipmentStopSubList().stream().map(RentEquipmentStopSubEntity::getSourceId).collect(Collectors.toList());
        this.rentParameterService.checkNoEffectData(parameterIdList, billId, stopEntity.getContractId());
        List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
        for (RentEquipmentStopSubEntity subEntity : subEntityList) {
            RentParameterDetailEntity detailEntity;
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("parameterId", new Parameter("eq", (Object)subEntity.getSourceId()));
            queryParam.getOrderMap().put("createTime", "desc");
            List detailEntityList = this.rentParameterDetailService.queryList(queryParam, false);
            if (!CollectionUtils.isNotEmpty((Collection)detailEntityList) || billId.equals((detailEntity = (RentParameterDetailEntity)((Object)detailEntityList.get(0))).getSourceId())) continue;
            return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25:\u8be5\u5355\u636e\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u6216\u5df2\u505a\u79df\u91d1\u8ba1\u7b97\uff0c\u8bf7\u68c0\u67e5");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5230\u8bbe\u5907\u505c\u7528\u5f03\u5ba1\u6d41\u7a0b.....{}", (Object)billId);
        RentEquipmentStopEntity stopEntity = (RentEquipmentStopEntity)((Object)this.stopService.selectById(billId));
        List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
        if (1 == stopEntity.getEntranceRentFlag()) {
            for (RentEquipmentStopSubEntity subEntity : subEntityList) {
                RentParameterEntity parameterEntity = (RentParameterEntity)((Object)this.rentParameterService.getById(subEntity.getSourceId()));
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("parameterId", new Parameter("eq", (Object)subEntity.getSourceId()));
                queryParam.getOrderMap().put("createTime", "desc");
                List detailEntityList = this.rentParameterDetailService.queryList(queryParam, false);
                if (!CollectionUtils.isNotEmpty((Collection)detailEntityList)) continue;
                RentParameterDetailEntity detailEntity = (RentParameterDetailEntity)((Object)detailEntityList.get(0));
                this.rentParameterDetailService.removeById(detailEntity.getId());
                RentParameterDetailEntity detailEntity1 = (RentParameterDetailEntity)((Object)detailEntityList.get(1));
                parameterEntity.setStopDate(null);
                parameterEntity.setRentEndDate(null);
                if (RentEquipmentStateEnum.\u542f\u7528.getCode().equals(detailEntity1.getEquipmentState())) {
                    parameterEntity.setOperationDate(new Date());
                    parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u542f\u7528.getCode());
                } else if (RentEquipmentStateEnum.\u505c\u7528.getCode().equals(detailEntity1.getEquipmentState())) {
                    parameterEntity.setOperationDate(new Date());
                    parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u505c\u7528.getCode());
                }
                this.rentParameterService.updateById((Object)parameterEntity);
            }
        } else {
            ArrayList<Long> parameterIdList = new ArrayList<Long>();
            for (RentEquipmentStopSubEntity subEntity : subEntityList) {
                parameterIdList.add(subEntity.getSourceId());
            }
            this.rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.\u505c\u7528\u5355.getCode(), stopEntity.getId());
        }
        stopEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.rentEquipmentStopService.saveOrUpdate((Object)stopEntity, false);
        return CommonResponse.success();
    }
}

