package com.ejianc.business.proequipmentcorppur.asset.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.vo.AmortizeSetVO;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 *  固定资产
 * 
 * @author generator
 * 
 */
public interface IAssetService extends IBaseService<AssetEntity> {

    AssetVO pushAsset(Long billId);
    AssetVO pushAsset(Long billId, OutRentContractEntity contract);

    List<AssetVO> queryAssetPage(Page<AssetVO> page, QueryWrapper wrapper,List<Long> orgIs);

    ExecutionVO targetCost(AssetVO assetVO);

    void updateAssetResidualValue(AmortizeSetVO amortizeSetVO);

    void updateEquipState(List<Long> assetId, int equipmentState, int equipRentState);
}
