package com.ejianc.business.proequipmentcorprent.rent.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 设备台账明细类型
 * 来源类型（0-启用单，1-停用单，2-租金计算，3-退场）
 */
public enum RentParameterTypeEnum {
    /**
     * 设备台账明细类型: 0-启用单
     */
    启用单("0", "启用单"),
    /**
     * 设备台账明细类型: 1-停用单
     */
    停用单("1", "停用单"),
    /**
     * 设备台账明细类型: 2-租金计算单
     */
    租金计算("2", "租金计算单"),
    /**
     * 设备台账明细类型: 3-退场单
     */
    退场单("3", "退场单"),
    /**
     * 设备台账明细类型: 4-验收单
     */
    验收单("4", "验收单"),
    /**
     * 设备台账明细类型: 5-停用单
     */
    退场停用单("5", "退场停用单");


    private String code;
    private String description;
    private static Map<String, RentParameterTypeEnum> enumMap = new HashMap<>();

    RentParameterTypeEnum(String code, String description){
        this.code = code;
        this.description = description;
    }
    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(RentParameterTypeEnum.class).stream().collect(Collectors
                .toMap(RentParameterTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static RentParameterTypeEnum getEnumByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }
}
