package com.ejianc.business.proequipmentcorprent.rent.service;

import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentSettlementEntity;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentSettleRecordVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentSettlementVO;
import com.ejianc.business.proequipmentcorprent.settle.vo.RentInConSettleReportVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 设备租赁结算主表
 * 
 * @author generator
 * 
 */
public interface IRentSettlementService extends IBaseService<RentSettlementEntity> {
    RentSettlementVO saveOrUpdate( RentSettlementVO saveOrUpdateVO);
    boolean queryExist(Long contractId,Long id);
    CommonResponse<Map> getDateMny(Long contractId);
    boolean pushBillToSupCenter(RentSettlementEntity entity);
    CommonResponse<String> updatePushBill(RentSettlementEntity entity);
    String updateBillSupSignSyncInfo(HttpServletRequest request);
    boolean pushSettleToPool(RentSettlementVO vo);
    boolean delSettleFromPool(Long id);
    ExecutionVO targetCost(RentSettlementEntity entity);
    CommonResponse<RentSettlementVO> pushCost(RentSettlementVO rentSettlementVO);
    void costPush(RentSettlementEntity rentSettlementEntity);
    List<RentRentalEntity> queryRental(Long contractId,String settleDate);
    /*
     * 参数控制集成方法
     * */
    ParamsCheckVO checkParams(RentSettlementVO vo);
    /*
     * 合同金额控结算金额
     * */
    List<ParamsCheckVO> checkParamsMnyList(RentContractEntity rentContractEntity, RentSettlementVO vo);
    CommonResponse<String> pushTargetCost(Long id);

    RentSettleRecordVO queryDetailRecord(Long contractId);
    void updateContractPoolSettle(RentSettlementVO vo, Boolean type);
    void delete( List<Long> settleIds);

    Map<String, Object> count(Map<String, Object> paramMap);

    List<RentInConSettleReportVO> pageList(Map<String, Object> paramMap);
}
