package com.ejianc.business.proequipmentcorpout.rental.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentalSettlementStateEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalDayEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalMonthEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalQuantitiesEntity;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalService;
import com.ejianc.business.proequipmentcorpout.rental.vo.OutRentRentalVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;
import java.util.stream.Collectors;

@Service("outRentRental") 
public class OutRentRentalBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOutRentRentalService service;
	@Autowired
	private ICostDetailApi costDetailApi;
	/** 设备台账 */
	@Autowired
	private IOutRentParameterService parameterService;
	@Autowired
	private IOutRentParameterDetailService outRentParameterDetailService;
	@Autowired
	private IRentReceiptsApi receiptsApi;
	@Autowired
	private IOutRentContractService contractService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutRentRentalEntity entity = service.selectById(billId);
		logger.info("推送成本---");
//		service.costPush(entity);
		if ("1".equals(entity.getRentalType())) {
			// 5. 处理设备台账
			List<OutRentParameterVO> rentParameterList = parameterService.getRentParameterByContractId(entity.getContractId(),
							entity.getId(), entity.getRentalDate());

			// 处理子表
			List<OutRentParameterDetailEntity> parameterDetailList = new ArrayList<>();
			for (OutRentParameterVO rentParameterVO : rentParameterList) {
				OutRentParameterEntity rentParameterEntity = BeanMapper.map(rentParameterVO, OutRentParameterEntity.class);
				OutRentParameterDetailEntity detailEntity = new OutRentParameterDetailEntity();
				detailEntity.setSourceType(RentParameterTypeEnum.租金计算.getCode());
				detailEntity.setSourceId(entity.getId());
				detailEntity.setOperationDate(entity.getRentalDate());
				QueryParam detailParam = new QueryParam();
				detailParam.getParams().put("parameterId", new Parameter(QueryParam.EQ, rentParameterEntity.getId()));
				detailParam.getParams().put("operationDate", new Parameter(QueryParam.LE, entity.getRentalDate()));
				detailParam.getOrderMap().put("operationDate", QueryParam.DESC);
				List<OutRentParameterDetailEntity> detailList = outRentParameterDetailService.queryList(detailParam, false);
				if(CollectionUtils.isNotEmpty(detailList)){
					detailEntity.setEquipmentState(detailList.get(0).getEquipmentState());
					detailEntity.setParameterId(rentParameterEntity.getId());
					parameterDetailList.add(detailEntity);
				}else{
					//正常不会走到此处
					detailEntity.setEquipmentState(rentParameterEntity.getEquipmentState());
				}
			}
			if (CollectionUtils.isNotEmpty(parameterDetailList)) {
				// 插入操作记录
				outRentParameterDetailService.saveOrUpdateBatch(parameterDetailList);
			}
		}

		//推送项目方
		if(entity.getRentHarborType() == 1) { //内租 推项目验收
			OutRentRentalVO outRentRentalVO = BeanMapper.map(entity, OutRentRentalVO.class);
			logger.info("推送项目方数据outRentRentalVO：{}", JSONObject.toJSONString(outRentRentalVO));
			//将租出单位信息赋值给组织
			outRentRentalVO.setOrgId(outRentRentalVO.getOutOrgId());
			outRentRentalVO.setOrgName(outRentRentalVO.getOutOrgName());
			outRentRentalVO.setOrgCode(outRentRentalVO.getOutOrgCode());

			outRentRentalVO.setRentType(outRentRentalVO.getRentHarborType());
			outRentRentalVO.setRentTypeName(outRentRentalVO.getRentHarborTypeName());
			CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(outRentRentalVO), RentReceiptsEnum.租金计算单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("当前单据已被下游业务引用，不能弃审！"+resp.getMsg());
        }
		OutRentRentalEntity entity = service.selectById(billId);
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, entity.getContractId()));
		List<OutRentParameterEntity> parameterEntityList = parameterService.queryList(queryParam);
		parameterService.checkNoEffectData(parameterEntityList.stream().map(OutRentParameterEntity::getId).collect(Collectors.toList()), billId, entity.getContractId());
        if (RentalSettlementStateEnum.已结算.getCode().equals(entity.getSettlementState())){
			return CommonResponse.error("当前单据已结算，不能弃审！");
		}
		OutRentContractEntity contractEntity = contractService.selectById(entity.getContractId());
		if(contractEntity !=null && PerformanceStatusEnum.已终止.getCode().equals(contractEntity.getContractPerformanceState())){
			return CommonResponse.error("合同已终止，该单据不能撤回！");
		}
		QueryWrapper<OutRentRentalEntity> listQueryOrderByTime = new QueryWrapper<>();
		listQueryOrderByTime.eq("contract_id", entity.getContractId());
		listQueryOrderByTime.orderByDesc("create_time");
		List<OutRentRentalEntity> listOrderByTime = service.list(listQueryOrderByTime);
		if (CollectionUtils.isNotEmpty(listOrderByTime) && null != listOrderByTime.get(0)){
			logger.info("查出租金计算单集合：{},billId：{}", JSONObject.toJSONString(listOrderByTime), billId);
			logger.info(billId + "");
			logger.info(listOrderByTime.get(0).getId() + "");
			if (!(listOrderByTime.get(0).getId() + "").equals(billId + "")){
				return CommonResponse.error("当前单据不是该合同下最新的租金计算单，不能弃审/撤回！");
			}
		}

		logger.info("弃审推送成本---");
		logger.info("删除成本中心之前的数据-Id---{}",entity.getId());
		CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(entity.getId());
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			throw new BusinessException(stringCommonResponse.getMsg());
		}
		//更新是否关联
		LambdaUpdateWrapper<OutRentRentalEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(OutRentRentalEntity::getId, entity.getId());
		updateWrapper.set(OutRentRentalEntity::getRelationFlag, "0");//(1:是，0：否)
		service.update(updateWrapper);

		// 处理自动租金计算数据
		if ("1".equals(entity.getRentalType())) {
			List<Long> parameterIdList = new ArrayList<>();
			List<OutRentRentalDayEntity> dayList = entity.getRentRentalDayList(); // 租金计算日租明细
			List<OutRentRentalMonthEntity> monthList = entity.getRentRentalMonthList(); // 租金计算月租明细
			// 租金计算工程量租明细
			List<OutRentRentalQuantitiesEntity> qList = entity.getRentRentalQuantitiesList();
			if (CollectionUtils.isNotEmpty(dayList)) {
				List<Long> sourceIdList = dayList.stream().map(OutRentRentalDayEntity::getSourceId).collect(Collectors.toList());
				parameterIdList.addAll(sourceIdList);
			}
			if (CollectionUtils.isNotEmpty(monthList)) {
				List<Long> sourceIdList = monthList.stream().map(OutRentRentalMonthEntity::getSourceId).collect(Collectors.toList());
				parameterIdList.addAll(sourceIdList);
			}
			if (CollectionUtils.isNotEmpty(qList)) {
				List<Long> sourceIdList = qList.stream().map(OutRentRentalQuantitiesEntity::getSourceId).collect(Collectors.toList());
				parameterIdList.addAll(sourceIdList);
			}

			QueryParam detailParam = new QueryParam();
			detailParam.getParams().put("parameterId", new Parameter(QueryParam.IN, parameterIdList));
			detailParam.getParams().put("source_id",new Parameter(QueryParam.EQ, billId));
			detailParam.getOrderMap().put("operationDate", QueryParam.DESC);
			List<OutRentParameterDetailEntity> parameterDetailList = outRentParameterDetailService.queryList(detailParam, false);
			if(CollectionUtils.isNotEmpty(parameterDetailList)){
				outRentParameterDetailService.removeByIds(parameterDetailList.stream().map(OutRentParameterDetailEntity::getId).collect(Collectors.toList()));
			}
		}
		if(entity.getRentHarborType() == 1) { //内租 推项目验收
			CommonResponse<String> response = receiptsApi.delReceipts(entity.getId(), RentReceiptsEnum.租金计算单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}
		}
		return CommonResponse.success();
	}

}
