/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractChangeEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractChangeAsyncService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractChangeService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="outRentContractChange")
public class OutRentContractChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOutRentContractService outRentContractService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOutRentContractChangeService outRentContractChangeService;
    @Autowired
    private IOutRentContractChangeAsyncService contractChangeAsyncService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OutRentContractChangeEntity e = (OutRentContractChangeEntity)((Object)this.outRentContractChangeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.outRentContractChangeService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u53d8\u66f4\u56de\u8c03\u5904\u7406\u5b8c\u6210\uff01");
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u7ec8\u5ba1\u5ba1\u6279\u524d\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRentContractChangeEntity changeEntity = (OutRentContractChangeEntity)((Object)this.outRentContractChangeService.selectById(billId));
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.outRentContractService.selectById(changeEntity.getContractId()));
        if (null != contractEntity && !contractEntity.getContractPerformanceState().equals(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode())) {
            return CommonResponse.error((String)"\u5f53\u524d\u53d8\u66f4\u5408\u540c\u6240\u5c5e\u7684\u4e3b\u5408\u540c\u72b6\u6001\u4e0d\u662f\u5c65\u7ea6\u4e2d\uff0c\u8be5\u53d8\u66f4\u5408\u540c\u4e0d\u80fd\u8fdb\u884c\u63d0\u4ea4\u64cd\u4f5c\uff01");
        }
        Boolean commitState = false;
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            commitState = true;
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(changeEntity.getChangeDraftType())) {
            CommonResponse<String> rsp = this.outRentContractChangeService.effectiveSaveWriteContract(billId, billTypeCode, commitState);
            if (!rsp.isSuccess()) {
                this.logger.info("\u5408\u540c\u751f\u6548\u56de\u5199\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString(rsp));
                throw new BusinessException("\u5408\u540c\u5ba1\u6838\u5931\u8d25\uff01");
            }
        } else {
            if (commitState.booleanValue()) {
                this.outRentContractChangeService.saveOrUpdate((Object)changeEntity);
            }
            contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u5355\u636e\u5ba1\u6279\u901a\u8fc7.getCode());
            this.outRentContractService.saveOrUpdate((Object)contractEntity, false);
            this.outRentContractService.pushContractToRent(JSONObject.toJSONString((Object)((Object)changeEntity)), OutRentConstants.PUSH_RENT_OPT_TYPE_ADD, "contractChange");
            this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        this.contractChangeAsyncService.asyncWatermarkById(billId);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        Object resp = null;
        OutRentContractChangeEntity changeEntity = (OutRentContractChangeEntity)((Object)this.outRentContractChangeService.selectById(billId));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (!DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(changeEntity.getChangeDraftType()) && !statusList.contains(changeEntity.getSignatureState())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(changeEntity.getSignatureState())) {
            changeEntity.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        }
        changeEntity.setCommitDate(null);
        changeEntity.setCommitUserCode(null);
        changeEntity.setCommitUserName(null);
        this.outRentContractChangeService.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.outRentContractService.selectById(changeEntity.getContractId()));
        contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        this.outRentContractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        this.outRentContractService.pushContractToRent(JSONObject.toJSONString((Object)((Object)changeEntity)), OutRentConstants.PUSH_RENT_OPT_TYPE_DEL, "contractChange");
        return CommonResponse.success((String)"\u6267\u884c\u53d8\u66f4\u5355\u64a4\u56de\u56de\u8c03\u903b\u8f91\u6210\u529f\uff01");
    }
}

