/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.api.ICostSettingApi;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.business.proequipmentcorpout.util.DateUtil;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentSettlementService;
import com.ejianc.business.proequipmentcorprent.settle.vo.RentInConSettleReportVO;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rentIn/settleReport"})
public class RentInSettleReportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentSettlementService service;
    @Autowired
    private ICostSettingApi costSettingApi;
    @Autowired
    private IReceiptAndPaymentRegisterApi receiptAndPaymentRegisterApi;
    @Autowired
    private IOrgApi orgApi;

    @PostMapping(value={"pageList"})
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) throws ParseException {
        Map<String, Object> totalInfo;
        JSONObject resp = new JSONObject();
        Map parameterMap = queryParam.getParams();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (null == parameterMap.get("orgId") || null == parameterMap.get("startDate") || null == parameterMap.get("endDate")) {
            return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u8303\u56f4\u53c2\u6570\uff01");
        }
        CommonResponse settingResp = this.costSettingApi.getSettingInfo(InvocationInfoProxy.getOrgId());
        if (!settingResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u6210\u672c\u671f\u95f4\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        SettingVO setting = (SettingVO)settingResp.getData();
        if (null == setting) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u8fdb\u884c\u6210\u672c\u5176\u95f4\u8bbe\u7f6e\uff01");
        }
        String startDate = ((Parameter)parameterMap.get("startDate")).getValue().toString();
        String endDate = ((Parameter)parameterMap.get("endDate")).getValue().toString();
        CommonResponse orgResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(Long.valueOf(((Parameter)parameterMap.get("orgId")).getValue().toString()));
        if (!orgResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u672c\u4e0b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        paramMap.put("orgIds", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if ("0".equals(setting.getPeriodRule())) {
            int maxDaysOfEndDate = DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)endDate));
            int maxDaysOfStartDate = DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)startDate));
            endDate = endDate + "-" + (maxDaysOfEndDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfEndDate);
            startDate = startDate + "-" + (maxDaysOfStartDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfStartDate);
            startDate = DateUtil.addDay((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)DateUtil.getLastMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)startDate), (String)"yyyy-MM-dd")), (int)1);
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);
            paramMap.put("curYear", endDate.substring(0, 4));
            paramMap.put("lastYearStartDate", DateUtil.addDay((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)DateUtil.getLastMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)(Integer.valueOf(endDate.substring(0, 4)) - 1 + "-01-" + setting.getEndDay())), (String)"yyyy-MM-dd")), (int)1));
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-12-" + setting.getEndDay());
        } else {
            startDate = startDate + "-01";
            endDate = endDate + "-" + DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)endDate));
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);
            parameterMap.remove("startDate");
            parameterMap.remove("endDate");
            paramMap.put("curYear", endDate.substring(0, 4));
            paramMap.put("lastYearStartDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-01-01");
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-12-31");
        }
        if (null != parameterMap.get("contractCode")) {
            paramMap.put("contractCode", ((Parameter)parameterMap.get("contractCode")).getValue());
        }
        if (null != parameterMap.get("contractName")) {
            paramMap.put("contractName", ((Parameter)parameterMap.get("contractName")).getValue());
        }
        if (null != parameterMap.get("orgName")) {
            paramMap.put("orgName", ((Parameter)parameterMap.get("orgName")).getValue());
        }
        if (null != parameterMap.get("projectName")) {
            paramMap.put("projectName", ((Parameter)parameterMap.get("projectName")).getValue());
        }
        if (null != parameterMap.get("supplierName")) {
            paramMap.put("supplierName", ((Parameter)parameterMap.get("supplierName")).getValue());
        }
        if (Integer.valueOf((totalInfo = this.service.count(paramMap)).get("total").toString()) == 0) {
            resp.put("total", (Object)0);
            resp.put("records", new ArrayList());
            resp.put("current", (Object)queryParam.getPageIndex());
            resp.put("size", (Object)queryParam.getPageSize());
            resp.put("pages", (Object)0);
            resp.put("curTotalSettleMny", (Object)0);
            resp.put("curTotalSettleTaxMny", (Object)0);
            resp.put("totalSettleMnyThisYear", (Object)0);
            resp.put("totalSettleTaxMnyThisYear", (Object)0);
            resp.put("totalStartSettleMny", (Object)0);
            resp.put("totalStartSettleTaxMny", (Object)0);
            return CommonResponse.success((Object)resp);
        }
        Page page = new Page();
        page.setTotal(Long.valueOf(totalInfo.get("total").toString()).longValue());
        page.setSize((long)queryParam.getPageSize());
        page.setCurrent((long)queryParam.getPageIndex());
        resp = (JSONObject)BeanMapper.map((Object)page, JSONObject.class);
        paramMap.put("pageSize", queryParam.getPageSize());
        paramMap.put("startLine", queryParam.getPageIndex() - 1 < 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        this.logger.info("\u5408\u540c\u7ed3\u7b97\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(paramMap));
        List<RentInConSettleReportVO> rsList = this.service.pageList(paramMap);
        HashMap<Long, RentInConSettleReportVO> conIdMap = new HashMap<Long, RentInConSettleReportVO>();
        conIdMap.putAll(rsList.stream().collect(Collectors.toMap(item -> item.getContractId(), item -> item)));
        paramMap.put("contractIds", conIdMap.keySet());
        HashMap<String, Object> queryPayInfoParam = new HashMap<String, Object>();
        queryPayInfoParam.putAll(paramMap);
        queryPayInfoParam.remove("orgIds");
        this.logger.info("\u67e5\u8be2\u5408\u540c\u4ed8\u6b3e\u767b\u8bb0\u4fe1\u606f\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(queryPayInfoParam));
        CommonResponse payInfoResp = this.receiptAndPaymentRegisterApi.getContractPayInfo(JSONObject.toJSONString(queryPayInfoParam));
        if (!payInfoResp.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u4ed8\u6b3e\u767b\u8bb0\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != payInfoResp.getData() && CollectionUtils.isNotEmpty((Collection)((Collection)payInfoResp.getData()))) {
            ((List)payInfoResp.getData()).parallelStream().forEach(payInfo -> {
                RentInConSettleReportVO tmp = (RentInConSettleReportVO)conIdMap.get(Long.valueOf(payInfo.get("contractId").toString()));
                tmp.setCurRegisterMny(null != payInfo.get("curPaidMny") ? new BigDecimal(payInfo.get("curPaidMny").toString()) : BigDecimal.ZERO);
                tmp.setTotalRegisterMnyLastYear(null != payInfo.get("totalPaidMnyLastYear") ? new BigDecimal(payInfo.get("totalPaidMnyLastYear").toString()) : BigDecimal.ZERO);
                tmp.setTotalStartRegisterMny(null != payInfo.get("totalStartPaidMny") ? new BigDecimal(payInfo.get("totalStartPaidMny").toString()) : BigDecimal.ZERO);
                tmp.setRegisterScale(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)tmp.getTotalStartRegisterMny(), (BigDecimal)tmp.getContractTaxMny()), (BigDecimal)new BigDecimal("100")));
                tmp.setOverRegisterMny(ComputeUtil.safeSub((BigDecimal)tmp.getContractTaxMny(), (BigDecimal)tmp.getTotalStartRegisterMny()));
                tmp.setSettleOverRegisterMnyLastYear(ComputeUtil.safeSub((BigDecimal)tmp.getTotalSettleTaxMnyLastYear(), (BigDecimal)tmp.getTotalRegisterMnyLastYear()));
            });
        }
        resp.put("records", rsList);
        resp.put("curTotalSettleMny", (Object)new BigDecimal(totalInfo.get("curTotalSettleMny").toString()));
        resp.put("curTotalSettleTaxMny", (Object)new BigDecimal(totalInfo.get("curTotalSettleTaxMny").toString()));
        resp.put("totalSettleMnyThisYear", (Object)new BigDecimal(totalInfo.get("totalSettleMnyThisYear").toString()));
        resp.put("totalSettleTaxMnyThisYear", (Object)new BigDecimal(totalInfo.get("totalSettleTaxMnyThisYear").toString()));
        resp.put("totalStartSettleMny", (Object)new BigDecimal(totalInfo.get("totalStartSettleMny").toString()));
        resp.put("totalStartSettleTaxMny", (Object)new BigDecimal(totalInfo.get("totalStartSettleTaxMny").toString()));
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"export"})
    public void pageList(@RequestBody QueryParam queryParam, HttpServletResponse response) throws ParseException {
        Map parameterMap = queryParam.getParams();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (null == parameterMap.get("orgId") || null == parameterMap.get("startDate") || null == parameterMap.get("endDate")) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u67e5\u8be2\u8303\u56f4\u53c2\u6570\uff01");
        }
        CommonResponse settingResp = this.costSettingApi.getSettingInfo(InvocationInfoProxy.getOrgId());
        if (!settingResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u6210\u672c\u671f\u95f4\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        SettingVO setting = (SettingVO)settingResp.getData();
        if (null == setting) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u8fdb\u884c\u6210\u672c\u5176\u95f4\u8bbe\u7f6e\uff01");
        }
        String startDate = ((Parameter)parameterMap.get("startDate")).getValue().toString();
        String endDate = ((Parameter)parameterMap.get("endDate")).getValue().toString();
        CommonResponse orgResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(Long.valueOf(((Parameter)parameterMap.get("orgId")).getValue().toString()));
        if (!orgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u672c\u4e0b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        paramMap.put("orgIds", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if ("0".equals(setting.getPeriodRule())) {
            int maxDaysOfEndDate = DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)endDate));
            int maxDaysOfStartDate = DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)startDate));
            endDate = endDate + "-" + (maxDaysOfEndDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfEndDate);
            startDate = startDate + "-" + (maxDaysOfStartDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfStartDate);
            startDate = DateUtil.addDay((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)DateUtil.getLastMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)startDate), (String)"yyyy-MM-dd")), (int)1);
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);
            paramMap.put("curYear", endDate.substring(0, 4));
            paramMap.put("lastYearStartDate", DateUtil.addDay((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)DateUtil.getLastMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)(Integer.valueOf(endDate.substring(0, 4)) - 1 + "-01-" + setting.getEndDay())), (String)"yyyy-MM-dd")), (int)1));
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-12-" + setting.getEndDay());
        } else {
            startDate = startDate + "-01";
            endDate = endDate + "-" + DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)endDate));
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);
            parameterMap.remove("startDate");
            parameterMap.remove("endDate");
            paramMap.put("curYear", endDate.substring(0, 4));
            paramMap.put("lastYearStartDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-01-01");
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-12-31");
        }
        if (null != parameterMap.get("contractCode")) {
            paramMap.put("contractCode", ((Parameter)parameterMap.get("contractCode")).getValue());
        }
        if (null != parameterMap.get("contractName")) {
            paramMap.put("contractName", ((Parameter)parameterMap.get("contractName")).getValue());
        }
        if (null != parameterMap.get("orgName")) {
            paramMap.put("orgName", ((Parameter)parameterMap.get("orgName")).getValue());
        }
        if (null != parameterMap.get("projectName")) {
            paramMap.put("projectName", ((Parameter)parameterMap.get("projectName")).getValue());
        }
        if (null != parameterMap.get("supplierName")) {
            paramMap.put("supplierName", ((Parameter)parameterMap.get("supplierName")).getValue());
        }
        this.logger.info("\u5408\u540c\u7ed3\u7b97\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(paramMap));
        List<RentInConSettleReportVO> rsList = this.service.pageList(paramMap);
        if (CollectionUtils.isNotEmpty(rsList)) {
            HashMap conIdMap = new HashMap();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            rsList.parallelStream().forEach(item -> {
                conIdMap.put(item.getContractId(), item);
                item.setCurSettleDateStr(sdf.format(item.getCurSettleDate()));
            });
            paramMap.put("contractIds", conIdMap.keySet());
            HashMap<String, Object> queryPayInfoParam = new HashMap<String, Object>();
            queryPayInfoParam.putAll(paramMap);
            queryPayInfoParam.remove("orgIds");
            CommonResponse payInfoResp = this.receiptAndPaymentRegisterApi.getContractPayInfo(JSONObject.toJSONString(queryPayInfoParam));
            if (!payInfoResp.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4ed8\u6b3e\u767b\u8bb0\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (null != payInfoResp.getData() && CollectionUtils.isNotEmpty((Collection)((Collection)payInfoResp.getData()))) {
                ((List)payInfoResp.getData()).parallelStream().forEach(payInfo -> {
                    RentInConSettleReportVO tmp = (RentInConSettleReportVO)conIdMap.get(Long.valueOf(payInfo.get("contractId").toString()));
                    tmp.setCurRegisterMny(null != payInfo.get("curPaidMny") ? new BigDecimal(payInfo.get("curPaidMny").toString()) : BigDecimal.ZERO);
                    tmp.setTotalRegisterMnyLastYear(null != payInfo.get("totalPaidMnyLastYear") ? new BigDecimal(payInfo.get("totalPaidMnyLastYear").toString()) : BigDecimal.ZERO);
                    tmp.setTotalStartRegisterMny(null != payInfo.get("totalStartPaidMny") ? new BigDecimal(payInfo.get("totalStartPaidMny").toString()) : BigDecimal.ZERO);
                    tmp.setRegisterScale(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)tmp.getTotalStartRegisterMny(), (BigDecimal)tmp.getContractTaxMny()), (BigDecimal)new BigDecimal("100")));
                    tmp.setOverRegisterMny(ComputeUtil.safeSub((BigDecimal)tmp.getContractTaxMny(), (BigDecimal)tmp.getTotalStartRegisterMny()));
                    tmp.setSettleOverRegisterMnyLastYear(ComputeUtil.safeSub((BigDecimal)tmp.getTotalSettleTaxMnyLastYear(), (BigDecimal)tmp.getTotalRegisterMnyLastYear()));
                });
            }
        }
        HashMap<String, List<RentInConSettleReportVO>> records = new HashMap<String, List<RentInConSettleReportVO>>();
        records.put("records", rsList);
        ExcelExport.getInstance().exportWithTrans("rentInSettleReport-export.xlsx", records, response);
    }
}

