/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractRelieveEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentSettlementEntity;
import com.ejianc.business.proequipmentcorprent.rent.mapper.RentContractRelieveMapper;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractRelieveService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentSettlementService;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="rentContractRelieveService")
public class RentContractRelieveServiceImpl
extends BaseServiceImpl<RentContractRelieveMapper, RentContractRelieveEntity>
implements IRentContractRelieveService {
    @Autowired
    private IRentSettlementService rentSettlementService;
    @Autowired
    private IRentContractService rentContractService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Override
    public ExecutionVO targetCost(RentContractRelieveEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RentSettlementEntity::getContractId, (Object)entity.getContractId());
        wrapper.eq(RentSettlementEntity::getSettlementType, (Object)"0");
        wrapper.in(RentSettlementEntity::getBillState, Arrays.asList(1, 3));
        List list = this.rentSettlementService.list((Wrapper)wrapper);
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(RentSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.getById(entity.getContractId()));
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getCode());
        totalVO.setBillType("BTC220314000000001");
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getCompanyId());
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalSettleMny, (BigDecimal)contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)contractEntity.getContractTaxMny()));
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        totalVO.setLinkUrl(frontendBaseHost + "ejc-proequipment-frontend/#/leaseContractContractRelieveCard?id=" + entity.getId());
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }
}

