/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.settle.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.proequipmentcorprent.ac.bean.ChangeEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.service.IChangeService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractService;
import com.ejianc.business.proequipmentcorprent.settle.bean.SettleDetailEntity;
import com.ejianc.business.proequipmentcorprent.settle.bean.SettleEntity;
import com.ejianc.business.proequipmentcorprent.settle.bean.SettleOtherEntity;
import com.ejianc.business.proequipmentcorprent.settle.enums.SettleTypeEnum;
import com.ejianc.business.proequipmentcorprent.settle.mapper.SettleMapper;
import com.ejianc.business.proequipmentcorprent.settle.service.ISettleDetailService;
import com.ejianc.business.proequipmentcorprent.settle.service.ISettleOtherService;
import com.ejianc.business.proequipmentcorprent.settle.service.ISettleService;
import com.ejianc.business.proequipmentcorprent.settle.vo.SettleRecordVO;
import com.ejianc.business.proequipmentcorprent.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    @Autowired
    private IChangeService changeService;
    @Autowired
    private SettleMapper settleMapper;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettleDetailService detailService;
    @Autowired
    private ISettleOtherService otherService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    private static final String CHECK_PARAM_CODE_GC = "P-lE5KWw55";
    private static final String CHECK_PARAM_CODE_ZZ = "P-9sGUw20157";

    @Override
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType) {
        SettleVO settleVO = new SettleVO();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getContractId, (Object)contractId);
        lambda.eq(SettleEntity::getSettleType, (Object)SettleTypeEnum.\u5b8c\u5de5.getCode());
        lambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        int resultCount = super.count((Wrapper)lambda);
        if (resultCount > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
        }
        QueryWrapper contractQuery = new QueryWrapper();
        contractQuery.eq((Object)"contract_id", (Object)contractId);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        if (null != contractEntity && null != contractEntity.getChangeId() && settleType == 1) {
            LambdaQueryWrapper changeContractLambda = new LambdaQueryWrapper();
            changeContractLambda.eq(BaseEntity::getId, (Object)contractEntity.getChangeId());
            changeContractLambda.and(c -> (LambdaQueryWrapper)c.in(ChangeEntity::getBillState, new Object[]{BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}));
            int changeResultCount = this.changeService.count((Wrapper)changeContractLambda);
            if (changeResultCount > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u6b63\u5728\u8fdb\u884c\u53d8\u66f4\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff01");
            }
        }
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(SettleEntity::getContractId, (Object)contractId);
        settleLambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List resultList = super.list((Wrapper)settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = null != ((SettleEntity)((Object)resultList.get(0))).getSettleType() ? SettleTypeEnum.getDescriptionByCode((Integer)((SettleEntity)((Object)resultList.get(0))).getSettleType()).getDescription() : "";
            return CommonResponse.error((String)("\u5f53\u524d\u5408\u540c\u6709\u672a\u5ba1\u6279\u7684" + settleTypeName + "\u7ed3\u7b97\u5355\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002"));
        }
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.eq((Object)"settle_type", (Object)settleType);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)listQuery);
        BigDecimal settleScale = BigDecimal.ZERO;
        if (list.size() > 0) {
            settleVO.setSettleScale(((SettleEntity)((Object)list.get(0))).getTotalSettleScale() == null ? BigDecimal.ZERO : ((SettleEntity)((Object)list.get(0))).getTotalSettleScale());
            settleVO.setLastTaxMny(((SettleEntity)((Object)list.get(0))).getTotalTaxMny() == null ? BigDecimal.ZERO : ((SettleEntity)((Object)list.get(0))).getTotalTaxMny());
            settleVO.setLastMny(((SettleEntity)((Object)list.get(0))).getTotalMny() == null ? BigDecimal.ZERO : ((SettleEntity)((Object)list.get(0))).getTotalMny());
        } else {
            settleVO.setLastTaxMny(BigDecimal.ZERO);
            settleVO.setLastMny(BigDecimal.ZERO);
            settleVO.setSettleScale(BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u5f53\u524d\u5408\u540c\u53ef\u7528\uff01", (Object)settleVO);
    }

    @Override
    public SettleRecordVO queryDetailRecord(Long contractId, Integer settleType) {
        SettleEntity lastSettleRecord;
        SettleRecordVO settleRecordVO = new SettleRecordVO();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractId));
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractMny(contract.getContractMny());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)listQuery);
        List settleVOS = BeanMapper.mapList((Iterable)list, SettleVO.class);
        settleVOS.forEach(vo -> {
            if (vo.getSettleType() == 1) {
                vo.setSettleTypeStr("\u5b8c\u5de5\u7ed3\u7b97");
            } else if (vo.getSettleType() == 0) {
                vo.setSettleTypeStr("\u8fc7\u7a0b\u7ed3\u7b97");
            }
            if (vo.getTotalSettleScale() != null) {
                int i = vo.getTotalSettleScale().toString().indexOf(".");
                String substring = vo.getTotalSettleScale().toString().substring(0, i + 3);
                vo.setTotalSettleScaleStr(substring + '%');
            }
        });
        settleRecordVO.setSettleList(settleVOS);
        SettleEntity settleEntity = lastSettleRecord = CollectionUtils.isNotEmpty((Collection)list) ? (SettleEntity)((Object)list.get(0)) : null;
        if (lastSettleRecord != null) {
            settleRecordVO.setTotalSettleMny(lastSettleRecord.getTotalTaxMny());
            settleRecordVO.setSettleRatio(lastSettleRecord.getTotalSettleScale());
        } else {
            settleRecordVO.setTotalSettleMny(BigDecimal.ZERO);
            settleRecordVO.setSettleRatio(BigDecimal.ZERO);
        }
        settleRecordVO.setCanAddNewSettleFlag(StringUtils.isBlank((CharSequence)this.beforeNewSettleCheck(contractId, settleType)));
        return settleRecordVO;
    }

    @Override
    public String beforeNewSettleCheck(Long contractId, Integer settleType) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        ((QueryWrapper)((QueryWrapper)query.and(q -> (QueryWrapper)((QueryWrapper)q.in((Object)"settle_type", new Object[]{SettleTypeEnum.\u8282\u70b9.getCode(), SettleTypeEnum.\u8fc7\u7a0b.getCode()})).in((Object)"bill_state", new Object[]{BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}))).or()).and(q -> (QueryWrapper)q.eq((Object)"settle_type", (Object)SettleTypeEnum.\u5b8c\u5de5));
        List billList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)billList)) {
            if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleType)) {
                return "\u5408\u540c\u5df2\u7ecf\u751f\u6210\u4e86\u5b8c\u5de5\u7ed3\u7b97\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c " + SettleTypeEnum.getDescriptionByCode((Integer)settleType) + "\u7ed3\u7b97";
            }
            return "\u6709\u672a\u751f\u6548\u7684\u8fc7" + SettleTypeEnum.getDescriptionByCode((Integer)SettleTypeEnum.\u8282\u70b9.getCode()) + "\u7b97\u5355\u636e\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c" + SettleTypeEnum.getDescriptionByCode((Integer)settleType) + "\u7ed3\u7b97";
        }
        if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleType)) {
            StringBuffer sp = new StringBuffer();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
            queryParam.getParams().put("bill_state", new Parameter("eq", (Object)BillStateEnum.APPROVING_HAS_STATE));
            QueryWrapper contractQuery = new QueryWrapper();
            contractQuery.eq((Object)"contract_id", (Object)contractId);
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
            if (null != contractEntity && null != contractEntity.getChangeId()) {
                LambdaQueryWrapper changeContractLambda = new LambdaQueryWrapper();
                changeContractLambda.eq(BaseEntity::getId, (Object)contractEntity.getChangeId());
                changeContractLambda.and(c -> (LambdaQueryWrapper)c.in(ChangeEntity::getBillState, new Object[]{BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}));
                int changeResultCount = this.changeService.count((Wrapper)changeContractLambda);
                if (changeResultCount > 0) {
                    return "\u5f53\u524d\u5408\u540c\u6b63\u5728\u8fdb\u884c\u53d8\u66f4\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff01";
                }
            }
        }
        return null;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        spv.setSourceId(id);
        CommonResponse res = this.settlePoolApi.deleteSettle(spv);
        if (res.isSuccess()) {
            this.logger.info("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)id);
            return true;
        }
        this.logger.error("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
        throw new BusinessException("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u5931\u8d25:" + res.getMsg());
    }

    @Override
    public boolean pushSettleToPool(SettleVO settleVO) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
            BeanConvertorUtil.convert((Object)settleVO, (Object)poolVO);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(settleVO, poolVO);
            poolVO.setBillCodeUrl("/ejc-proequipment-frontend/#/settleList/card?id=" + settleVO.getId());
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)settleVO.getId());
                return true;
            }
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)settleVO.getId(), (Object)res.getMsg());
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25:" + res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97-{}\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff0c", (Object)settleVO.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
        }
    }

    private void convertSettleVOToSettlePoolVO(SettleVO settleVO, SettlePoolVO poolVO) {
        if (null == settleVO || null == poolVO) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        poolVO.setSourceType(settleVO.getSettleType() == 0 ? SettleSourceTypeEnum.\u5b89\u62c6\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getCode() : SettleSourceTypeEnum.\u5b89\u62c6\u5408\u540c\u6700\u7ec8\u7ed3\u7b97.getCode());
        poolVO.setSettleProperty(Integer.valueOf(0));
        poolVO.setHandleType(Integer.valueOf(0));
        poolVO.setLastTaxMny(settleVO.getLastTaxMny());
        poolVO.setLastMny(settleVO.getLastMny());
        poolVO.setLastTax(this.getSubStractAbs(settleVO.getLastTaxMny(), settleVO.getLastMny()));
        poolVO.setContractType(ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode());
        poolVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)poolVO.getBillState()).getDescription());
        ContractEntity ce = (ContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
        this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u8fc7\u7a0b\u4e2d\uff0c\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\uff0c\u5408\u540cid-{}", (Object)settleVO.getContractId());
        if (ce == null) {
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u8fc7\u7a0b\u4e2d\uff0c\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\uff0c\u5408\u540cid-{}\uff0c\u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f\uff0c\u6545\u7ed3\u7b97\u5355\u7684 \u4e3b\u5408\u540c/\u7532\u65b9/\u4e59\u65b9/\u7b7e\u8ba2\u65e5\u671f/\u521b\u5efa\u65f6\u95f4\u548c\u4eba\u5458/\u66f4\u65b0\u65f6\u95f4\u548c\u4eba\u5458 \u7b49\u4fe1\u606f\u65e0\u6cd5\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60", (Object)settleVO.getContractId());
            return;
        }
        poolVO.setContractFlag(Integer.valueOf(1));
        poolVO.setMaiContractId(ce.getMainContractId());
        poolVO.setMaiContractName(ce.getMainContractName());
        poolVO.setMaiContractCode(ce.getMainContractCode());
        poolVO.setContractTypeName(ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeName());
        poolVO.setSupplementFlag(ce.getSupplementFlag());
        poolVO.setMemo(ce.getMemo());
        poolVO.setPartyaId(ce.getFirstPartyId());
        poolVO.setPartyaName(ce.getFirstPartyName());
        poolVO.setSignDate(ce.getSignDate());
        poolVO.setCreateTime(settleVO.getCreateTime());
        poolVO.setCreateUserCode(settleVO.getCreateUserCode());
        poolVO.setUpdateTime(settleVO.getUpdateTime());
        poolVO.setUpdateUserCode(settleVO.getUpdateUserCode());
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    @Override
    public ExecutionVO targetCost(SettleVO settleVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        totalVO.setBillType("EJCBT202204000007");
        totalVO.setBussinessType(BussinessTypeEnum.\u5927\u578b\u8bbe\u5907\u5b89\u62c6\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        if (settleVO.getProjectId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setProjectId(settleVO.getProjectId());
        if (settleVO.getOrgId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setOrgId(settleVO.getOrgId());
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SettleEntity::getContractId, (Object)settleVO.getContractId());
        query.in(SettleEntity::getBillState, new Object[]{1, 3});
        query.eq(BaseEntity::getDr, (Object)0);
        List entity = this.settleService.list((Wrapper)query);
        BigDecimal sumMny = BigDecimal.ZERO;
        BigDecimal sumTaxMny = BigDecimal.ZERO;
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
        for (SettleEntity settleEntity : entity) {
            sumMny = ComputeUtil.safeAdd((BigDecimal)sumMny, (BigDecimal)settleEntity.getMny());
            sumTaxMny = ComputeUtil.safeAdd((BigDecimal)sumTaxMny, (BigDecimal)settleEntity.getTaxMny());
        }
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public CommonResponse<SettleVO> pushCost(SettleVO settleVO) {
        SettleEntity entity = (SettleEntity)((Object)((SettleMapper)this.baseMapper).selectById(settleVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getDetailList())) {
            List detailEntityList = BeanMapper.mapList((Iterable)settleVO.getDetailList(), SettleDetailEntity.class);
            entity.setDetailList(detailEntityList);
        }
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getOtherList())) {
            List otherEntityList = BeanMapper.mapList((Iterable)settleVO.getOtherList(), SettleOtherEntity.class);
            entity.setOtherList(otherEntityList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), SettleVO.class));
    }

    @Override
    public void costPush(SettleEntity settleEntity) {
        String oldRelationFlag;
        this.logger.info("\u5f00\u59cbcostPush");
        List<SettleDetailEntity> detailList = settleEntity.getDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getOtherList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (SettleDetailEntity detailEntity : detailList) {
                if (null != detailEntity.getSubjectId() && null != detailEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(otherList)) {
            for (SettleOtherEntity otherEntity : otherList) {
                if (null != otherEntity.getSubjectId() && null != otherEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(detailList) && ListUtil.isEmpty(otherList)) {
            newRelationFlag = "0";
        }
        if ("1".equals(oldRelationFlag = settleEntity.getRelationFlag())) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(settleEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u5b89\u62c6\u7ed3\u7b97Id---{}", (Object)settleEntity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(settleEntity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.saveCost(settleEntity);
        }
        settleEntity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{settleEntity.getId()});
        updateWrapper.set(SettleEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
    }

    private void saveCost(SettleEntity settleEntity) {
        CostDetailVO costDetailVO;
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<SettleOtherEntity> otherlList = settleEntity.getOtherList();
        List<SettleDetailEntity> detailList = settleEntity.getDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (SettleDetailEntity detailEntity : detailList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)detailEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getSettleTaxMny());
                costDetailVO.setHappenMny(detailEntity.getSettleMny());
                costDetailVO.setSourceTabType("SETTLE_EQ_JS_DETAIL");
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(otherlList)) {
            for (SettleOtherEntity settleOtherEntity : otherlList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)settleOtherEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(settleOtherEntity.getId());
                costDetailVO.setHappenTaxMny(settleOtherEntity.getTaxMny());
                costDetailVO.setHappenMny(settleOtherEntity.getMny());
                costDetailVO.setSourceTabType("SETTLE_EQ_JS_OTHER");
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costDetailVOList)) {
            for (CostDetailVO costDetailVO2 : costDetailVOList) {
                costDetailVO2.setSourceBillCode(settleEntity.getBillCode());
                costDetailVO2.setSourceBillName(SourceTypeEnum.\u8bbe\u5907\u5b89\u62c6\u7ed3\u7b97\u5355.getTypeName());
                costDetailVO2.setSourceBillUrl("/ejc-proequipment-frontend/#/settleList/card?id=" + settleEntity.getId());
                costDetailVO2.setSourceId(settleEntity.getId());
                costDetailVO2.setHappenDate(settleEntity.getSettleDate());
                costDetailVO2.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO2.setId(null);
                costDetailVO2.setSourceType("SETTLE_EQ_JS");
                costDetailVO2.setProjectId(settleEntity.getProjectId());
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ParamsCheckVO checkParams(SettleVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (vo.getContractId() != null) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            paramsCheckVOS.addAll(this.checkParamsMny(contractEntity, vo));
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMny(ContractEntity contractEntity, SettleVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        String CHECK_PARAM_CODE = "";
        switch (vo.getSettleType()) {
            case 0: {
                CHECK_PARAM_CODE = CHECK_PARAM_CODE_GC;
                break;
            }
            case 1: {
                CHECK_PARAM_CODE = CHECK_PARAM_CODE_ZZ;
            }
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal totalSettleTaxMny = null == vo.getTotalTaxMny() ? BigDecimal.ZERO : vo.getTotalTaxMny();
                    BigDecimal settleTaxMny = null == vo.getTaxMny() ? BigDecimal.ZERO : vo.getTaxMny();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractEntity.getContractTaxMny(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSettleTaxMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(settleTaxMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalSettleTaxMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.settleService.selectById(id));
        if (1 == settleEntity.getSettleType()) {
            String frontendBaseHost = "";
            frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
            String linkUrl = frontendBaseHost + "ejc-proequipment-frontend/#/settleList/card?id=" + id;
            ExecutionVO executionVO = this.settleService.targetCost((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class), linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public void updateContractPoolSettle(SettleVO vo, Boolean type) {
        if (null != vo.getContractId()) {
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + (type != false ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0csettleEntity={}, \u8fc7\u7a0b\uff080\uff09/\u6700\u7ec8\uff081\uff09={}, type={}", new Object[]{vo, vo.getSettleType(), type});
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
            BigDecimal totalSettleMny = BigDecimal.ZERO;
            BigDecimal totalSettleTax = BigDecimal.ZERO;
            if (type.booleanValue()) {
                totalSettleTaxMny = vo.getTotalTaxMny() == null ? BigDecimal.ZERO : vo.getTotalTaxMny();
                totalSettleMny = vo.getTotalMny() == null ? BigDecimal.ZERO : vo.getTotalMny();
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            } else {
                totalSettleTaxMny = ComputeUtil.safeSub((BigDecimal)vo.getTotalTaxMny(), (BigDecimal)vo.getTaxMny());
                totalSettleMny = ComputeUtil.safeSub((BigDecimal)vo.getTotalMny(), (BigDecimal)vo.getMny());
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            }
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);
            contractPoolVO.setTotalSettleMny(totalSettleMny);
            contractPoolVO.setTotalSettleTax(totalSettleTax);
            if (1 == vo.getSettleType()) {
                if (type.booleanValue()) {
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode());
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                }
            }
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
            CommonResponse updateConPoolRes = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)updateConPoolRes));
        }
    }
}

