package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.asset.vo.AssetAmortizeFinanceDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

/**
 * 固定资产摊销（财务）
 * 
 * @author generator
 * 
 */
public class AssetAmortizeFinanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    //占用
    public static final String PM_ZY = "Y";
    public static final String PM_SF = "N";
    
    private String billCode; // 单据编号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 办理日期
    private Integer billState; // 单据状态
    private Integer financePushState; // 财务推送状态1已推送0未推送
    private Long projectId; // 项目(摊销单位)
    private String projectCode; // 项目编号(摊销单位编码)
    private String projectName; // 项目名称(摊销单位名称)
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long orgId; // 所属项目部
    private String orgCode; // 所属项目部编码
    private String orgName; // 所属项目部名称
    private Date effectTime; // 单据生效时间
    private String amortizeDate; // 摊销周期
    private String lastAmortizeDate; // 上次摊销周期
    private BigDecimal amortizeMny; // 摊销金额
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String memo; // 备注
    private String categoryName; // 材料分类名称
    @ApiModelProperty("单据状态名称")
    private String billStateName;
    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)

    
    private List<AssetAmortizeFinanceDetailVO> assetAmortizeFinanceDetailList = new ArrayList<>(); // 固定资产摊销明细（财务）

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getFinancePushState() {
        return financePushState;
    }

    public void setFinancePushState(Integer financePushState) {
        this.financePushState = financePushState;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getEffectTime() {
        return effectTime;
    }

    public void setEffectTime(Date effectTime) {
        this.effectTime = effectTime;
    }

    public String getAmortizeDate() {
        return amortizeDate;
    }

    public void setAmortizeDate(String amortizeDate) {
        this.amortizeDate = amortizeDate;
    }

    public String getLastAmortizeDate() {
        return lastAmortizeDate;
    }

    public void setLastAmortizeDate(String lastAmortizeDate) {
        this.lastAmortizeDate = lastAmortizeDate;
    }

    public BigDecimal getAmortizeMny() {
        return amortizeMny;
    }

    public void setAmortizeMny(BigDecimal amortizeMny) {
        this.amortizeMny = amortizeMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    
     public List<AssetAmortizeFinanceDetailVO> getAssetAmortizeFinanceDetailList() {
        return assetAmortizeFinanceDetailList;
     }

     public void setAssetAmortizeFinanceDetailList(List<AssetAmortizeFinanceDetailVO> assetAmortizeFinanceDetailList) {
        this.assetAmortizeFinanceDetailList = assetAmortizeFinanceDetailList;
     }
}
