package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.consts.AssetRecordTypeEnum;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.asset.vo.AssetScrapDetailVO;

/**
 * 固定资产报废表
 * 
 * @author generator
 * 
 */
@ApiModel("固定资产报废表")
public class AssetScrapVO extends BaseVO implements IAssetRecord {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("报废项目id")
    private Long projectId;
    @ApiModelProperty("报废项目名称")
    private String projectName;
    @ApiModelProperty("所属项目部Id")
    private Long orgId;
    @ApiModelProperty("所属项目部名称")
    private String orgName;
    @ApiModelProperty("所属项目部编码")
    private String orgCode;
    @ApiModelProperty("项目部上级组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("报废日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date scrapDate;
    @ApiModelProperty("机械设备台数")
    private Integer equipmentNum;
    @ApiModelProperty("设备原值")
    private BigDecimal totalOriginalValue;
    @ApiModelProperty("设备原值(含税)")
    private BigDecimal totalOriginalValueTax;
    @ApiModelProperty("设备净值")
    private BigDecimal totalNetWorth;
    @ApiModelProperty("设备净值(含税)")
    private BigDecimal totalNetWorthTax;
    @ApiModelProperty("设备残值")
    private BigDecimal totalResidualValue;
    @ApiModelProperty("设备残值(含税)")
    private BigDecimal totalResidualValueTax;
    @ApiModelProperty("累计折旧金额")
    private BigDecimal totalLastDepreciationMny;
    @ApiModelProperty("累计折旧金额(含税)")
    private BigDecimal totalLastDepreciationTaxMny;//累计折旧金额(含税)
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long deptId;
    @ApiModelProperty("经办部门名称")
    private String deptName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("报废状态 0-未报废，1-已报废")
    private Integer scrapState;

    @ApiModelProperty("单据状态名称")
    private String billStateName;
    
    @ApiModelProperty("固定资产报废明细表")
    private List<AssetScrapDetailVO> assetScrapDetailList = new ArrayList<>();

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 报废单位id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 报废单位id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 报废日期
     */
    public Date getScrapDate() {
        return scrapDate;
    }

    /**
     * 报废日期
     */
    public void setScrapDate(Date scrapDate) {
        this.scrapDate = scrapDate;
    }
    /**
     * 机械设备台数
     */
    public Integer getEquipmentNum() {
        return equipmentNum;
    }

    /**
     * 机械设备台数
     */
    public void setEquipmentNum(Integer equipmentNum) {
        this.equipmentNum = equipmentNum;
    }
    /**
     * 设备原值
     */
    public BigDecimal getTotalOriginalValue() {
        return totalOriginalValue;
    }

    /**
     * 设备原值
     */
    public void setTotalOriginalValue(BigDecimal totalOriginalValue) {
        this.totalOriginalValue = totalOriginalValue;
    }
    /**
     * 设备原值(含税)
     */
    public BigDecimal getTotalOriginalValueTax() {
        return totalOriginalValueTax;
    }

    /**
     * 设备原值(含税)
     */
    public void setTotalOriginalValueTax(BigDecimal totalOriginalValueTax) {
        this.totalOriginalValueTax = totalOriginalValueTax;
    }
    /**
     * 设备净值
     */
    public BigDecimal getTotalNetWorth() {
        return totalNetWorth;
    }

    /**
     * 设备净值
     */
    public void setTotalNetWorth(BigDecimal totalNetWorth) {
        this.totalNetWorth = totalNetWorth;
    }
    /**
     * 设备净值(含税)
     */
    public BigDecimal getTotalNetWorthTax() {
        return totalNetWorthTax;
    }

    /**
     * 设备净值(含税)
     */
    public void setTotalNetWorthTax(BigDecimal totalNetWorthTax) {
        this.totalNetWorthTax = totalNetWorthTax;
    }
    /**
     * 设备残值
     */
    public BigDecimal getTotalResidualValue() {
        return totalResidualValue;
    }

    /**
     * 设备残值
     */
    public void setTotalResidualValue(BigDecimal totalResidualValue) {
        this.totalResidualValue = totalResidualValue;
    }
    /**
     * 设备残值(含税)
     */
    public BigDecimal getTotalResidualValueTax() {
        return totalResidualValueTax;
    }

    /**
     * 设备残值(含税)
     */
    public void setTotalResidualValueTax(BigDecimal totalResidualValueTax) {
        this.totalResidualValueTax = totalResidualValueTax;
    }

    public BigDecimal getTotalLastDepreciationMny() {
        return totalLastDepreciationMny;
    }

    public void setTotalLastDepreciationMny(BigDecimal totalLastDepreciationMny) {
        this.totalLastDepreciationMny = totalLastDepreciationMny;
    }

    public BigDecimal getTotalLastDepreciationTaxMny() {
        return totalLastDepreciationTaxMny;
    }

    public void setTotalLastDepreciationTaxMny(BigDecimal totalLastDepreciationTaxMny) {
        this.totalLastDepreciationTaxMny = totalLastDepreciationTaxMny;
    }

    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 报废状态 0-未报废，1-已报废
     */
    public Integer getScrapState() {
        return scrapState;
    }

    /**
     * 报废状态 0-未报废，1-已报废
     */
    public void setScrapState(Integer scrapState) {
        this.scrapState = scrapState;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
      * 固定资产报废明细表
      */
      public List<AssetScrapDetailVO> getAssetScrapDetailList() {
         return assetScrapDetailList;
      }
     /**
      * 固定资产报废明细表
      */
     public void setAssetScrapDetailList(List<AssetScrapDetailVO> assetScrapDetailList) {
         this.assetScrapDetailList = assetScrapDetailList;
     }

    @Override
    public List<AssetRecordVO> toRecordList() {
        List<AssetScrapDetailVO> assetScrapDetailList = this.getAssetScrapDetailList();
        ArrayList<AssetRecordVO> assetRecordVOS = new ArrayList<>();
        for (AssetScrapDetailVO assetScrapDetailVO : assetScrapDetailList) {
            AssetRecordVO recordVO = BeanMapper.map(assetScrapDetailVO, AssetRecordVO.class);
            recordVO.setId(null);
            recordVO.setVersion(null);
            recordVO.setBillDate(new Date());
            recordVO.setSourceId(this.getId());
            recordVO.setSourceBillCode(this.getBillCode());
            recordVO.setSourceDetailId(assetScrapDetailVO.getId());
            recordVO.setSourceType(AssetRecordTypeEnum.报废.getCode());
            recordVO.setSourceTypeName(AssetRecordTypeEnum.报废.getName());
            recordVO.setOrgId(this.getOrgId());
            recordVO.setOrgName(this.getOrgName());
            recordVO.setOrgCode(this.getOrgCode());
            recordVO.setParentOrgId(this.getParentOrgId());
            recordVO.setParentOrgName(this.getParentOrgName());
            recordVO.setParentOrgCode(this.getParentOrgCode());
            recordVO.setProjectId(this.getProjectId());
            recordVO.setProjectName(this.getProjectName());
            assetRecordVOS.add(recordVO);
        }
        return assetRecordVOS;
    }
}
