package com.ejianc.business.purchase.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.business.vo.util.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 购置合同-机械设备明细表
 * 
 * @author generator
 * 
 */
public class EquipmentDetailedVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String equipmentType; // 设备类别
    private String equipmentName; // 设备名称
    private String spec; // 规格型号
    private String company; // 单位
    private Long purchaseNum; // 采购数量
    private BigDecimal purchasePrice; // 采购单价
    private BigDecimal purchaseAmount; // 采购金额
    private BigDecimal estimateAmortizeMny; // 预估摊销金额
    private BigDecimal taxRate; // 税率
    private BigDecimal purchasePricetNoTax; // 采购单价(无税)
    private BigDecimal purchaseAmountNoTax; // 采购金额(无税)
    private BigDecimal taxMny; // 税额
    private Integer acceptanceQuantity; // 验收数量
    private String manufacturer; // 生产厂家
    private String detailMemo; // 备注
    private Long sourceId; // 来源数据Id
    private String sourceType; // 来源类型
    private Long contractId; // 所属合同Id(合同表主键相当于pid)
    private Long changeId; // 变更表主键
    private Long changeBid; // 变更子表主键
    private Long parentId; // 父ID
    private String changeType; // 变更类型
    @ReferJsonField(referCode = "equipmentType001",referFields = "code",resultFields = "equipmentTypeCode")
    private Long docCategoryId; // 档案分类id
    private String equipmentTypeCode; // 设备类别编码
    private Long docId; // 档案Id
    private String treeIndex; // 序号
    private String equipmentCode; // 设备编码
    private Integer surplusNum; // 剩余数量
    private BigDecimal signNum;
    private BigDecimal sourcePrice;
    private BigDecimal sourceTaxPrice;
    private BigDecimal initNum;
    private BigDecimal tenderNum;
    private String purchasePriceStr;
    private String purchaseAmountStr;
    private String estimateAmortizeMnyStr;
    private String taxRateStr;
    private String purchasePricetNoTaxStr;
    private String purchaseAmountNoTaxStr;
    private String taxMnyStr;
    private String historyPriceArea;//历史价格区间（无税）
    private String historyTaxPriceArea;//历史价格区间（含税）
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）

    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }

    public BigDecimal getTenderNum() {
        return tenderNum;
    }

    public void setTenderNum(BigDecimal tenderNum) {
        this.tenderNum = tenderNum;
    }

    public BigDecimal getInitNum() {
        return initNum;
    }

    public void setInitNum(BigDecimal initNum) {
        this.initNum = initNum;
    }

    public BigDecimal getSignNum() {
        return signNum;
    }

    public void setSignNum(BigDecimal signNum) {
        this.signNum = signNum;
    }

    public BigDecimal getSourcePrice() {
        return sourcePrice;
    }

    public void setSourcePrice(BigDecimal sourcePrice) {
        this.sourcePrice = sourcePrice;
    }

    public BigDecimal getSourceTaxPrice() {
        return sourceTaxPrice;
    }

    public void setSourceTaxPrice(BigDecimal sourceTaxPrice) {
        this.sourceTaxPrice = sourceTaxPrice;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }

    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public Long getPurchaseNum() {
        return purchaseNum;
    }

    public void setPurchaseNum(Long purchaseNum) {
        this.purchaseNum = purchaseNum;
    }

    public BigDecimal getPurchasePrice() {
        return purchasePrice;
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public BigDecimal getPurchaseAmount() {
        return purchaseAmount;
    }

    public void setPurchaseAmount(BigDecimal purchaseAmount) {
        this.purchaseAmount = purchaseAmount;
    }

    public BigDecimal getEstimateAmortizeMny() {
        return estimateAmortizeMny;
    }

    public void setEstimateAmortizeMny(BigDecimal estimateAmortizeMny) {
        this.estimateAmortizeMny = estimateAmortizeMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Integer getAcceptanceQuantity() {
        return acceptanceQuantity;
    }

    public void setAcceptanceQuantity(Integer acceptanceQuantity) {
        this.acceptanceQuantity = acceptanceQuantity;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }

    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public BigDecimal getPurchasePricetNoTax() {
        return purchasePricetNoTax;
    }

    public void setPurchasePricetNoTax(BigDecimal purchasePricetNoTax) {
        this.purchasePricetNoTax = purchasePricetNoTax;
    }

    public BigDecimal getPurchaseAmountNoTax() {
        return purchaseAmountNoTax;
    }

    public void setPurchaseAmountNoTax(BigDecimal purchaseAmountNoTax) {
        this.purchaseAmountNoTax = purchaseAmountNoTax;
    }

    public Integer getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(Integer surplusNum) {
        this.surplusNum = surplusNum;
    }

    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }


    public String getPurchasePriceStr() {
        return purchasePriceStr;
    }

    public void setPurchasePriceStr(String purchasePriceStr) {
        this.purchasePriceStr = purchasePriceStr;
    }

    public String getPurchaseAmountStr() {
        return purchaseAmountStr;
    }

    public void setPurchaseAmountStr(String purchaseAmountStr) {
        this.purchaseAmountStr = purchaseAmountStr;
    }

    public String getEstimateAmortizeMnyStr() {
        return estimateAmortizeMnyStr;
    }

    public void setEstimateAmortizeMnyStr(String estimateAmortizeMnyStr) {
        this.estimateAmortizeMnyStr = estimateAmortizeMnyStr;
    }

    public String getTaxRateStr() {
        return taxRateStr;
    }

    public void setTaxRateStr(String taxRateStr) {
        this.taxRateStr = taxRateStr;
    }

    public String getPurchasePricetNoTaxStr() {
        return purchasePricetNoTaxStr;
    }

    public void setPurchasePricetNoTaxStr(String purchasePricetNoTaxStr) {
        this.purchasePricetNoTaxStr = purchasePricetNoTaxStr;
    }

    public String getPurchaseAmountNoTaxStr() {
        return purchaseAmountNoTaxStr;
    }

    public void setPurchaseAmountNoTaxStr(String purchaseAmountNoTaxStr) {
        this.purchaseAmountNoTaxStr = purchaseAmountNoTaxStr;
    }

    public String getTaxMnyStr() {
        return taxMnyStr;
    }

    public void setTaxMnyStr(String taxMnyStr) {
        this.taxMnyStr = taxMnyStr;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
}
