package com.ejianc.business.purchase.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 购置合同表
 * 
 * @author generator
 * 
 */
public class ImportContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 合同类型：主合同
     */
    public static final Integer CONTRACT_TYPE_MAIN_CONTRACT = 0;
    /**
     * 合同类型：补充协议
     */
    public static final Integer CONTRACT_TYPE_SUPPLEMENT = 1;
    /**
     * 通用变更类型：0-新增项
     */
    public static final Integer CHANGE_TYPE_ADD = 0;
    /**
     * 通用变更类型：1-删除项
     */
    public static final Integer CHANGE_TYPE_DEL = 1;
    /**
     * 通用变更类型：2-内容便更
     */
    public static final Integer CHANGE_TYPE_CONTENT_CHANGE = 2;

    private String errorMessage;
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long targetResultId; // 定标结果Id
    private String targetResultName; // 定标结果名称
    @ConvertField(targetField = "contractCode")
    private String billCode; // 合同编号
    private String contractCode; // 合同编号
    @ConvertField
    private String contractName; // 合同名称
    @ConvertField
    private String projectName; // 项目名称
    @ConvertField
    private Long projectId; // 项目id
    private String projectAddress; // 项目地址
    private String projectCode; // 项目编号
    private String projectCompany; // 所属单位
    private Long projectCompanyId; // 所属单位id
    @ConvertField(targetField = "categoryName")
    private String contractCategoryName; // 合同类别名称
    @ConvertField(targetField = "categoryId")
    private Long contractCategoryId; // 合同类别Id
    @ConvertField(targetField = "partyaName")
    private String firstPartyName; // 甲方
    @ConvertField(targetField = "partyaId")
    private Long firstPartyId; // 甲方id
    private String firstPartyPsn; // 甲方负责人
    private Long firstPartyPsnId; // 甲方负责人id
    @ConvertField(targetField = "employeeName")
    private String firstPartyEmployee; // 甲方经办人
    @ConvertField(targetField = "employeeId")
    private Long firstPartyEmployeeId; // 甲方经办人id
    private String firstPartyPhone; // 甲方联系电话
    @ConvertField(targetField = "partybName")
    private String supplierName; // 乙方
    @ConvertField(targetField = "partybId")
    private Long supplierId; // 乙方id
    @ConvertField(targetField = "supplierProjectManagerName")
    private String supplierEmployee; // 乙方经办人
    @ConvertField(targetField = "supplierProjectManagerLink")
    private String supplierPhone; // 乙方联系电话
    private String supplierAddress; // 乙方地址
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ConvertField
    private Date signDate; // 签订日期
    @ConvertField
    private BigDecimal taxRate; // 合同税率
    @ConvertField
    private String signPlace; // 供货地点
    private String signatureStatus; // 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
    @ConvertField(targetField = "performanceStatus")
    private String contractPerformanceState; // 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；  不可选择，根据 默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】；
    private String contractFilePath; // 合同附件路径
    private Long contractFileId; // 合同附件Id
    private Long contractTemplateId; // 合同模板Id
    private String contractTemplateName; // 合同模板名称
    private Long contractFileVersionId; // 合同附件版本Id
    private Long contractFileVersion; // 合同附件版本
    @ConvertField
    private BigDecimal contractTaxMny; // 合同金额
    @ConvertField
    private BigDecimal contractMny; // 合同金额（无税)
    @ConvertField
    private BigDecimal contractTax; // 合同税额
    private BigDecimal equipmentTaxMny; // 设备金额
    private BigDecimal equipmentMny; // 设备金额（无税）
    private BigDecimal equipmentTax; // 设备税额
    private BigDecimal otherTaxMny; // 其他金额
    private BigDecimal otherMny; // 其他金额（无税）
    private BigDecimal otherTax; // 其他税额
    private BigDecimal estimateAmortizeTotalMny; // 预计摊销总金额
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    @ConvertField
    private Long orgId; // 项目部Id
    @ConvertField
    private String orgName; // 项目部名称
    @ConvertField
    private Long parentOrgId; // 项目部上级组织Id
    @ConvertField
    private String parentOrgName; // 项目部上级组织名称
    @ConvertField
    private String parentOrgCode; // 项目部上级组织编码
    private String contractFileHighlightPath; // 合同高亮附件路径
    private Long contractFileHighlightId; // 合同高亮附件Id
    private BigDecimal baseMny; // 初始版本金额
    private BigDecimal baseTaxMny; // 初始版本(含税)金额
    private BigDecimal beforeChangeMny; // 变更前金额
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private BigDecimal changingMny; // 变更中金额
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private Long changeId; // 变更主键
    @ConvertField
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @ConvertField
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @ConvertField
    private Long mainContractId; // 主合同Id
    @ConvertField
    private String mainContractCode; // 主合同编码
    @ConvertField
    private String mainContractName; // 主合同名称
    private String supplementDescribe; // 补充项描述
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mainContractCreateDate; // 主合同创建日期（用于合同、补充协议排序）
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private Integer changeContractSignatureStatus; // 变更合同签章状态
    private String changeDraftType; // 变更起草方式：1-上传附件，2-线下签订
    private Long changeFileId; // 变更附件Id
    private String changeContractName; // 变更合同名称
    private Long signedFileId; // 签章完成合同文件Id
    private Boolean addType; // 合同新增方式：参照定标结果新增-1，直接新增-0
    @ConvertField
    private String orgCode; // 项目部编码
    @ConvertField(targetField = "pricingType")
    private String draftType; // 起草方式：1、在线起草2、上传合同3、线下签订；
    private String memo; // 备注
    private Long watermarkContractFileId;
    @ConvertField
    private Integer filingStatus;//是否归档 1：是；0：否
    @ConvertField
    private Integer filingRef;//是否被归档引用 归档 1：是；0：否

    @ConvertField
    private String purchaseId; // 供货内容id
    @ConvertField
    private String purchaseName; // 供货内容名称

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    /**
     * 发票类型Id
     */
    private Long invoiceTypeId;

    /**
     * 发票类型名称
     */
    private String invoiceTypeName;

    /**
     * 线上起草，审批中修改的合同是否已重新进行合同编辑
     */
    private Boolean contractFileSyncFlag = true;
    /**
     * 完工结算单生效日期
     */
    @ConvertField
    private Date finishSettleDate;

    @ConvertField
    private BigDecimal processPaymentRatio; // 过程付款比例

    public BigDecimal getProcessPaymentRatio() {
        return processPaymentRatio;
    }

    public void setProcessPaymentRatio(BigDecimal processPaymentRatio) {
        this.processPaymentRatio = processPaymentRatio;
    }

    public Long getWatermarkContractFileId() {
        return watermarkContractFileId;
    }

    public void setWatermarkContractFileId(Long watermarkContractFileId) {
        this.watermarkContractFileId = watermarkContractFileId;
    }

    public Date getFinishSettleDate() {
        return finishSettleDate;
    }

    public void setFinishSettleDate(Date finishSettleDate) {
        this.finishSettleDate = finishSettleDate;
    }

    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }

    @ReferDeserialTransfer
    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    @ConvertField(targetField = "sourceId,contractId,id")
    private Long id;

    @ConvertField
    private Integer dr;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }

    /**
     * 补充协议集合（不入库）
     */
    private List<ImportContractVO> supplementList;

    public Boolean getContractFileSyncFlag() {
        return contractFileSyncFlag;
    }

    public void setContractFileSyncFlag(Boolean contractFileSyncFlag) {
        this.contractFileSyncFlag = contractFileSyncFlag;
    }

    /**
     * 是否能新增补充协议（不入库）
     */
    private Boolean editFlag;


    /**
     * 补充协议次数（不入库）
     */
    private Integer supplementNum;

    /**
     * 累计补充金额（不入库）
     */
    private BigDecimal allSupplementMny;

    /**
     * 补充金额比例（不入库）
     */
    private BigDecimal supplementMnyRate;


    /**
     * 累计变更次数（不入库）
     */
    private Integer changeNum;

    /**
     * 累计变更金额（不入库）
     */
    private BigDecimal allChangeMny;

    /**
     * 累计变更金额比例（不入库）
     */
    private BigDecimal changeMnyRate;

    /**
     * 变更集合（不入库）
     */
    private List<ChangePurchaseContractVO> changeList;

    /**
     * 单据状态名称（不入库） ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    private String billStateName;

    /**
     * 购置合同-机械设备明细实体
     */
    @SubEntity
    private List<EquipmentDetailedVO> detailList = new ArrayList<>();
    /**
     * 购置合同-合同条款
     */
    private List<PurchaseContractClauseVO> clauseList = new ArrayList<>();
    /**
     * 购置合同-合同支付条款
     */
    @ConvertField(targetField = "contractSubPaymentNodeList", targetFieldType = ConvertField.TargetType.CLASS)
    private List<PurchaseContractPaymentClauseVO> paymentList = new ArrayList<>();

    /**
     * 购置合同-其他费用
     */
    private List<OtherDetailedVO> otherCostList = new ArrayList<>();


    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="refEquipmentsupplierData")
    public Long getTargetResultId() {
        return targetResultId;
    }
    @ReferDeserialTransfer
    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }
    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectCompany() {
        return projectCompany;
    }

    public void setProjectCompany(String projectCompany) {
        this.projectCompany = projectCompany;
    }
    public Long getProjectCompanyId() {
        return projectCompanyId;
    }

    public void setProjectCompanyId(Long projectCompanyId) {
        this.projectCompanyId = projectCompanyId;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getFirstPartyId() {
        return firstPartyId;
    }
    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyPsn() {
        return firstPartyPsn;
    }

    public void setFirstPartyPsn(String firstPartyPsn) {
        this.firstPartyPsn = firstPartyPsn;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getFirstPartyPsnId() {
        return firstPartyPsnId;
    }
    @ReferDeserialTransfer
    public void setFirstPartyPsnId(Long firstPartyPsnId) {
        this.firstPartyPsnId = firstPartyPsnId;
    }
    public String getFirstPartyEmployee() {
        return firstPartyEmployee;
    }

    public void setFirstPartyEmployee(String firstPartyEmployee) {
        this.firstPartyEmployee = firstPartyEmployee;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getFirstPartyEmployeeId() {
        return firstPartyEmployeeId;
    }
    @ReferDeserialTransfer
    public void setFirstPartyEmployeeId(Long firstPartyEmployeeId) {
        this.firstPartyEmployeeId = firstPartyEmployeeId;
    }
    public String getFirstPartyPhone() {
        return firstPartyPhone;
    }

    public void setFirstPartyPhone(String firstPartyPhone) {
        this.firstPartyPhone = firstPartyPhone;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierEmployee() {
        return supplierEmployee;
    }

    public void setSupplierEmployee(String supplierEmployee) {
        this.supplierEmployee = supplierEmployee;
    }
    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }
    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }
    public String getContractPerformanceState() {
        return contractPerformanceState;
    }

    public void setContractPerformanceState(String contractPerformanceState) {
        this.contractPerformanceState = contractPerformanceState;
    }
    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }
    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }
    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }
    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }
    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }
    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public String getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(String signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getEquipmentTaxMny() {
        return equipmentTaxMny;
    }

    public void setEquipmentTaxMny(BigDecimal equipmentTaxMny) {
        this.equipmentTaxMny = equipmentTaxMny;
    }
    public BigDecimal getEquipmentMny() {
        return equipmentMny;
    }

    public void setEquipmentMny(BigDecimal equipmentMny) {
        this.equipmentMny = equipmentMny;
    }
    public BigDecimal getEquipmentTax() {
        return equipmentTax;
    }

    public void setEquipmentTax(BigDecimal equipmentTax) {
        this.equipmentTax = equipmentTax;
    }
    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }
    public BigDecimal getEstimateAmortizeTotalMny() {
        return estimateAmortizeTotalMny;
    }

    public void setEstimateAmortizeTotalMny(BigDecimal estimateAmortizeTotalMny) {
        this.estimateAmortizeTotalMny = estimateAmortizeTotalMny;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }
    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }
    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public Integer getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(Integer changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }
    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }
    public Long getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }
    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }
    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }
    public Boolean getAddType() {
        return addType;
    }

    public void setAddType(Boolean addType) {
        this.addType = addType;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public List<EquipmentDetailedVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<EquipmentDetailedVO> detailList) {
        this.detailList = detailList;
    }

    public List<PurchaseContractClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<PurchaseContractClauseVO> clauseList) {
        this.clauseList = clauseList;
    }

    public List<PurchaseContractPaymentClauseVO> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<PurchaseContractPaymentClauseVO> paymentList) {
        this.paymentList = paymentList;
    }

    public List<OtherDetailedVO> getOtherCostList() {
        return otherCostList;
    }

    public void setOtherCostList(List<OtherDetailedVO> otherCostList) {
        this.otherCostList = otherCostList;
    }

    public List<ImportContractVO> getSupplementList() {
        return supplementList;
    }

    public void setSupplementList(List<ImportContractVO> supplementList) {
        this.supplementList = supplementList;
    }

    public Boolean getEditFlag() {
        return editFlag;
    }

    public void setEditFlag(Boolean editFlag) {
        this.editFlag = editFlag;
    }

    public Integer getSupplementNum() {
        return supplementNum;
    }

    public void setSupplementNum(Integer supplementNum) {
        this.supplementNum = supplementNum;
    }

    public BigDecimal getAllSupplementMny() {
        return allSupplementMny;
    }

    public void setAllSupplementMny(BigDecimal allSupplementMny) {
        this.allSupplementMny = allSupplementMny;
    }

    public BigDecimal getSupplementMnyRate() {
        return supplementMnyRate;
    }

    public void setSupplementMnyRate(BigDecimal supplementMnyRate) {
        this.supplementMnyRate = supplementMnyRate;
    }

    public Integer getChangeNum() {
        return changeNum;
    }

    public void setChangeNum(Integer changeNum) {
        this.changeNum = changeNum;
    }

    public BigDecimal getAllChangeMny() {
        return allChangeMny;
    }

    public void setAllChangeMny(BigDecimal allChangeMny) {
        this.allChangeMny = allChangeMny;
    }

    public BigDecimal getChangeMnyRate() {
        return changeMnyRate;
    }

    public void setChangeMnyRate(BigDecimal changeMnyRate) {
        this.changeMnyRate = changeMnyRate;
    }

    public List<ChangePurchaseContractVO> getChangeList() {
        return changeList;
    }

    public void setChangeList(List<ChangePurchaseContractVO> changeList) {
        this.changeList = changeList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
