package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 固定资产摊销明细表
 *
 * @author generator
 */
@ApiModel("固定资产摊销明细表")
public class AssetAmortizeDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("设备分类id")
    private Long equipmentTypeId;
    @ApiModelProperty("设备分类编码")
    private String equipmentTypeCode;
    @ApiModelProperty("设备分类名称")
    private String equipmentTypeName;
    @ApiModelProperty("设备id")
    private Long equipmentId;
    @ApiModelProperty("设备编码")
    private String equipmentCode;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("资产id")
    private Long assetId;
    @ApiModelProperty("资产编码")
    private String assetCode;
    @ApiModelProperty("资产名称")
    private String assetName;
    @ApiModelProperty("财务资产分类id")
    private String financeTypeId;
    @ApiModelProperty("财务资产id")
    private String financeAssetId;
    @ApiModelProperty("财务资产编码")
    private String financeAssetCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位id")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("原值(无税)")
    private BigDecimal originalValue;
    @ApiModelProperty("原值(含税)")
    private BigDecimal originalValueTax;
    @ApiModelProperty("净值(无税)")
    private BigDecimal netWorth;
    @ApiModelProperty("净值(含税)")
    private BigDecimal netWorthTax;
    @ApiModelProperty("原值单价(无税)")
    private BigDecimal originalValuePrice;
    @ApiModelProperty("原值单价(含税)")
    private BigDecimal originalValuePriceTax;
    @ApiModelProperty("残值(含税)")
    private BigDecimal residualValueTax;
    @ApiModelProperty("残值(无税)")
    private BigDecimal residualValue;
    @ApiModelProperty("上次摊销周期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM", timezone = "GMT+8")
    private Date lastAmortizeDate;
    @ApiModelProperty("本次摊销比例")
    private BigDecimal amortizeRate;
    @ApiModelProperty("本次摊销金额(无税)")
    private BigDecimal amortizeMny;
    @ApiModelProperty("本次摊销金额(含税)")
    private BigDecimal amortizeMnyTax;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("已生效摊销周期数")
    private Integer usedAmortizeNum;
    @ApiModelProperty("使用年限（月）")
    private Integer usePeriod;
    @ApiModelProperty("残值率")
    private BigDecimal residualValueRate;

    @ApiModelProperty("主表id")
    private Long pid;

    @ApiModelProperty("摊销设置id")
    private Long amortizeSetId;

    @ApiModelProperty("本次摊销周期数")
    private Integer thisAmortizeNum;

    /**
     * 根据摊销设置获取本次摊销金额时放错误消息，ep：未获取到对应的摊销设置
     */
    private String errMsg;

    @ApiModelProperty("验收日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate;

    @ApiModelProperty("核算对象id")
    private Long wbsId;
    @ApiModelProperty("核算对象code")
    private String wbsCode;
    @ApiModelProperty("核算对象name")
    private String wbsName;
    @ApiModelProperty("成本科目id")
    private Long subjectId;
    @ApiModelProperty("成本科目code")
    private String subjectCode;
    @ApiModelProperty("成本科目name")
    private String subjectName;
    @ApiModelProperty("上次摊销金额(无税)")
    private BigDecimal lastAmortizeMny;
    @ApiModelProperty("上次摊销金额(含税)")
    private BigDecimal lastAmortizeTaxMny;
    @ApiModelProperty("累计摊销金额(无税)")
    private BigDecimal totalAmortizeMny;
    @ApiModelProperty("累计摊销金额(含税)")
    private BigDecimal totalAmortizeTaxMny;



    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }

    public Integer getThisAmortizeNum() {
        return thisAmortizeNum;
    }

    public void setThisAmortizeNum(Integer thisAmortizeNum) {
        this.thisAmortizeNum = thisAmortizeNum;
    }

    public Long getAmortizeSetId() {
        return amortizeSetId;
    }

    public void setAmortizeSetId(Long amortizeSetId) {
        this.amortizeSetId = amortizeSetId;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }


    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    /**
     * 设备分类id
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 设备分类id
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }

    /**
     * 设备分类编码
     */
    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    /**
     * 设备分类编码
     */
    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }

    /**
     * 设备分类名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 设备分类名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }

    /**
     * 设备id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    /**
     * 设备编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }

    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    /**
     * 资产id
     */
    public Long getAssetId() {
        return assetId;
    }

    /**
     * 资产id
     */
    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }

    /**
     * 资产编码
     */
    public String getAssetCode() {
        return assetCode;
    }

    /**
     * 资产编码
     */
    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }

    /**
     * 资产名称
     */
    public String getAssetName() {
        return assetName;
    }

    /**
     * 资产名称
     */
    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    /**
     * 财务资产分类id
     */
    public String getFinanceTypeId() {
        return financeTypeId;
    }

    /**
     * 财务资产分类id
     */
    public void setFinanceTypeId(String financeTypeId) {
        this.financeTypeId = financeTypeId;
    }

    /**
     * 财务资产id
     */
    public String getFinanceAssetId() {
        return financeAssetId;
    }

    /**
     * 财务资产id
     */
    public void setFinanceAssetId(String financeAssetId) {
        this.financeAssetId = financeAssetId;
    }

    /**
     * 财务资产编码
     */
    public String getFinanceAssetCode() {
        return financeAssetCode;
    }

    /**
     * 财务资产编码
     */
    public void setFinanceAssetCode(String financeAssetCode) {
        this.financeAssetCode = financeAssetCode;
    }

    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }

    /**
     * 计量单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }

    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }

    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * 原值(无税)
     */
    public BigDecimal getOriginalValue() {
        return originalValue;
    }

    /**
     * 原值(无税)
     */
    public void setOriginalValue(BigDecimal originalValue) {
        this.originalValue = originalValue;
    }

    /**
     * 原值(含税)
     */
    public BigDecimal getOriginalValueTax() {
        return originalValueTax;
    }

    /**
     * 原值(含税)
     */
    public void setOriginalValueTax(BigDecimal originalValueTax) {
        this.originalValueTax = originalValueTax;
    }

    /**
     * 净值(无税)
     */
    public BigDecimal getNetWorth() {
        return netWorth;
    }

    /**
     * 净值(无税)
     */
    public void setNetWorth(BigDecimal netWorth) {
        this.netWorth = netWorth;
    }

    /**
     * 净值(含税)
     */
    public BigDecimal getNetWorthTax() {
        return netWorthTax;
    }

    /**
     * 净值(含税)
     */
    public void setNetWorthTax(BigDecimal netWorthTax) {
        this.netWorthTax = netWorthTax;
    }

    /**
     * 原值单价(无税)
     */
    public BigDecimal getOriginalValuePrice() {
        return originalValuePrice;
    }

    /**
     * 原值单价(无税)
     */
    public void setOriginalValuePrice(BigDecimal originalValuePrice) {
        this.originalValuePrice = originalValuePrice;
    }

    /**
     * 原值单价(含税)
     */
    public BigDecimal getOriginalValuePriceTax() {
        return originalValuePriceTax;
    }

    /**
     * 原值单价(含税)
     */
    public void setOriginalValuePriceTax(BigDecimal originalValuePriceTax) {
        this.originalValuePriceTax = originalValuePriceTax;
    }

    /**
     * 残值(含税)
     */
    public BigDecimal getResidualValueTax() {
        return residualValueTax;
    }

    /**
     * 残值(含税)
     */
    public void setResidualValueTax(BigDecimal residualValueTax) {
        this.residualValueTax = residualValueTax;
    }

    /**
     * 残值(无税)
     */
    public BigDecimal getResidualValue() {
        return residualValue;
    }

    /**
     * 残值(无税)
     */
    public void setResidualValue(BigDecimal residualValue) {
        this.residualValue = residualValue;
    }

    /**
     * 上次摊销周期
     */
    public Date getLastAmortizeDate() {
        return lastAmortizeDate;
    }

    /**
     * 上次摊销周期
     */
    public void setLastAmortizeDate(Date lastAmortizeDate) {
        this.lastAmortizeDate = lastAmortizeDate;
    }

    /**
     * 本次摊销比例
     */
    public BigDecimal getAmortizeRate() {
        return amortizeRate;
    }

    /**
     * 本次摊销比例
     */
    public void setAmortizeRate(BigDecimal amortizeRate) {
        this.amortizeRate = amortizeRate;
    }

    /**
     * 本次摊销金额(无税)
     */
    public BigDecimal getAmortizeMny() {
        return amortizeMny;
    }

    /**
     * 本次摊销金额(无税)
     */
    public void setAmortizeMny(BigDecimal amortizeMny) {
        this.amortizeMny = amortizeMny;
    }

    /**
     * 本次摊销金额(含税)
     */
    public BigDecimal getAmortizeMnyTax() {
        return amortizeMnyTax;
    }

    /**
     * 本次摊销金额(含税)
     */
    public void setAmortizeMnyTax(BigDecimal amortizeMnyTax) {
        this.amortizeMnyTax = amortizeMnyTax;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 已生效摊销周期数
     */
    public Integer getUsedAmortizeNum() {
        return usedAmortizeNum;
    }

    /**
     * 已生效摊销周期数
     */
    public void setUsedAmortizeNum(Integer usedAmortizeNum) {
        this.usedAmortizeNum = usedAmortizeNum;
    }

    /**
     * 使用年限（月）
     */
    public Integer getUsePeriod() {
        return usePeriod;
    }

    /**
     * 使用年限（月）
     */
    public void setUsePeriod(Integer usePeriod) {
        this.usePeriod = usePeriod;
    }

    /**
     * 残值率
     */
    public BigDecimal getResidualValueRate() {
        return residualValueRate;
    }

    /**
     * 残值率
     */
    public void setResidualValueRate(BigDecimal residualValueRate) {
        this.residualValueRate = residualValueRate;
    }

    /**
     * 核算对象id
     */
    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }

    /**
     * 核算对象id
     */
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    /**
     * 核算对象code
     */
    public String getWbsCode() {
        return wbsCode;
    }

    /**
     * 核算对象code
     */
    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    /**
     * 核算对象name
     */
    public String getWbsName() {
        return wbsName;
    }

    /**
     * 核算对象name
     */
    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    /**
     * 成本科目id
     */
    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }

    /**
     * 成本科目id
     */
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    /**
     * 成本科目code
     */
    public String getSubjectCode() {
        return subjectCode;
    }

    /**
     * 成本科目code
     */
    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    /**
     * 成本科目name
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目name
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public BigDecimal getLastAmortizeMny() {
        return lastAmortizeMny;
    }

    public void setLastAmortizeMny(BigDecimal lastAmortizeMny) {
        this.lastAmortizeMny = lastAmortizeMny;
    }

    public BigDecimal getLastAmortizeTaxMny() {
        return lastAmortizeTaxMny;
    }

    public void setLastAmortizeTaxMny(BigDecimal lastAmortizeTaxMny) {
        this.lastAmortizeTaxMny = lastAmortizeTaxMny;
    }

    public BigDecimal getTotalAmortizeMny() {
        return totalAmortizeMny;
    }

    public void setTotalAmortizeMny(BigDecimal totalAmortizeMny) {
        this.totalAmortizeMny = totalAmortizeMny;
    }

    public BigDecimal getTotalAmortizeTaxMny() {
        return totalAmortizeTaxMny;
    }

    public void setTotalAmortizeTaxMny(BigDecimal totalAmortizeTaxMny) {
        this.totalAmortizeTaxMny = totalAmortizeTaxMny;
    }
}
