package com.ejianc.business.purchaseplan.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.estimate.bean.PurchaseEstimateDetailedEntity;
import com.ejianc.business.estimate.service.IPurchaseEstimateDetailedService;
import com.ejianc.business.purchase.bean.ChangeEquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.ChangePurchaseContractEntity;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseRecordDetaileEntity;
import com.ejianc.business.purchase.service.IChangeEquipmentDetailedService;
import com.ejianc.business.purchase.service.IEquipmentDetailedService;
import com.ejianc.business.purchase.service.IPurchaseRecordDetaileService;
import com.ejianc.business.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.purchaseplan.bean.PurchasePlanEntity;
import com.ejianc.business.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.purchaseplan.service.IPurchasePlanService;
import com.ejianc.business.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("purchasePlan") 
public class PurchasePlanBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IPurchasePlanService service;
	@Autowired
	private IEquipmentDetailedService detailedService;
	@Autowired
	private IChangeEquipmentDetailedService changeDetailedService;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IPurchaseEstimateDetailedService estimateDetailedService;
	@Value("${contract.generateBillCodeType:common}")
	private String GenerateBillCodeType;
	@Autowired
	private IProjectPoolApi projectPoolApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if("ynjt".equals(GenerateBillCodeType)){
			PurchasePlanEntity planEntity = service.selectById(billId);
			List<PurchasePlanDetailedEntity> subEntityList = planEntity.getDetailList();
			for (PurchasePlanDetailedEntity planDetailedEntity: subEntityList){
				PurchaseEstimateDetailedEntity entity =estimateDetailedService.selectById(planDetailedEntity.getSourceId());
				Long remainingNum =entity.getRemainingNum()-planDetailedEntity.getPlanNum();
				entity.setRemainingNum(remainingNum);
				entity.setAppliedNum(planDetailedEntity.getPlanNum());
				estimateDetailedService.saveOrUpdate(entity);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PurchasePlanEntity planEntity = service.selectById(billId);

		List<PurchasePlanDetailedEntity> subEntityList = planEntity.getDetailList();
		if(CollectionUtils.isNotEmpty(subEntityList)){
			List<Long> batchIds = subEntityList.stream().map(PurchasePlanDetailedEntity::getId).collect(Collectors.toList());
			QueryWrapper<EquipmentDetailedEntity> queryDetaile = new QueryWrapper<EquipmentDetailedEntity>();
			queryDetaile.in("source_id", batchIds);
			queryDetaile.eq("dr", 0);
			List<EquipmentDetailedEntity> equipmentList = detailedService.list(queryDetaile);

			QueryWrapper<ChangeEquipmentDetailedEntity> queryChangeDetaile = new QueryWrapper<ChangeEquipmentDetailedEntity>();
			queryChangeDetaile.in("source_id", batchIds);
			queryChangeDetaile.eq("dr", 0);
			List<ChangeEquipmentDetailedEntity> changeEquipmentList = changeDetailedService.list(queryChangeDetaile);

			if(CollectionUtils.isNotEmpty(equipmentList) || CollectionUtils.isNotEmpty(changeEquipmentList)){
				return CommonResponse.error("清单被下游单据引用，不允许回退!");
			}
			// 如果是待采购，则不判断是否引用
			if (PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState().equals(planEntity.getPlanState())) {
				return CommonResponse.success();
			}

			CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
			if (!resp.isSuccess()) {
//			return CommonResponse.error("无法撤回！" + resp.getMsg());
				return CommonResponse.error("单据被引用不能撤回！");
			}

		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if("ynjt".equals(GenerateBillCodeType)){
			PurchasePlanEntity planEntity = service.selectById(billId);
			List<PurchasePlanDetailedEntity> subEntityList = planEntity.getDetailList();
			for (PurchasePlanDetailedEntity planDetailedEntity: subEntityList){
				PurchaseEstimateDetailedEntity entity =estimateDetailedService.selectById(planDetailedEntity.getSourceId());
				Long remainingNum =entity.getRemainingNum()+planDetailedEntity.getPlanNum();
				entity.setRemainingNum(remainingNum);
				entity.setAppliedNum(entity.getAppliedNum()-planDetailedEntity.getPlanNum());
				estimateDetailedService.saveOrUpdate(entity);
			}
		}
		return CommonResponse.success();
	}
	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			PurchasePlanEntity entity = service.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}
}
