package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.purchase.bean.ChangePurchaseContractEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.bean.PurchaseContractRelieveEntity;
import com.ejianc.business.purchase.enums.DraftTypeEnum;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.service.IPurchaseContractRelieveService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("purchaseContractRelieve") 
public class PurchaseContractRelieveBpmServiceImpl implements ICommonBusinessService {


	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IPurchaseContractRelieveService service;

	@Autowired
	private IPurchaseContractService contractService;

	@Autowired
	private IProjectPoolApi projectPoolApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		PurchaseContractRelieveEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		logger.info("======提交完回调======,{}", JSONObject.toJSONString(e));
		service.saveOrUpdate(e, false);
		return CommonResponse.success("合同解除审批回调处理成功");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PurchaseContractRelieveEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		logger.info("======终审前回调======,{}", JSONObject.toJSONString(e));
		service.saveOrUpdate(e, false);
		return CommonResponse.success("合同解除审批回调处理成功");
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PurchaseContractRelieveEntity entity = service.selectById(billId);
		if (entity != null) {
			// 已签章
			if (entity.getDraftType() == 2) {
				entity.setSignatureStatus("4");
				entity.setPerformanceStatus(Integer.valueOf(ContractPerformanceStateEnum.已作废.getStateCode()));
				entity.setEffectiveDate(new Date());
				service.saveOrUpdate(entity, false);

				QueryParam param = new QueryParam();
				param.getParams().put("id", new Parameter(QueryParam.EQ, entity.getContractId()));
				List<PurchaseContractEntity> contractEntities = contractService.queryList(param, false);
				contractEntities.get(0).setContractPerformanceState(ContractPerformanceStateEnum.已作废.getStateCode());
				logger.info("======终审审核完回调,已签章======,{}", JSONObject.toJSONString(contractEntities.get(0)));
				contractService.saveOrUpdate(contractEntities.get(0), false);
				// 推送合同池
				contractService.pushContract(BeanMapper.map(contractEntities.get(0), PurchaseContractVO.class));
			} else if (entity.getDraftType() == 1) {
				// 初始化成未签章
				entity.setSignatureStatus("1");
				logger.info("======终审审核完回调,初始化成未签章======,{}", JSONObject.toJSONString(entity));
				service.saveOrUpdate(entity, false);
			}
		}

		return CommonResponse.success("合同解除终审审核完回调处理成功!");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("合同解除进入弃审前事件，合同id：{}", billId);
		PurchaseContractRelieveEntity entity = service.selectById(billId);
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}

		// 签章状态：1-待签章,2-待乙方签章,3-待甲方签章,4-已签章（已完成）,5-已退回（已拒签）,6-已撤回,7-已过期,8-其他已签章；  单据新增后默认为待签章
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());
		if (DraftTypeEnum.线上起草.getCode().equals(entity.getDraftType())
				&& !statusList.contains(entity.getSignatureStatus())) {
			return CommonResponse.error("合同解除" + (SignatureStatusEnum.已签章.getCode()
					.equals(entity.getSignatureStatus()) ? "已生效" : "已有签章流程") + "，不允许弃审!");
		}
		else if (SignatureStatusEnum.已签章.getCode().equals(entity.getSignatureStatus())) {
			entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
			service.saveOrUpdate(entity, false);
		}

		// 更新合同履约状态
		PurchaseContractEntity contractEntity = contractService.selectById(entity.getContractId());
		contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.履约中.getStateCode());
		contractService.saveOrUpdate(contractEntity, false);
		// 重新推送合同池
		contractService.pushContract(BeanMapper.map(contractEntity, PurchaseContractVO.class));
		return CommonResponse.success("撤回前校验回调成功！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		PurchaseContractRelieveEntity entity  = service.selectById(billId);

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}

		// 签章状态：1-待签章,2-待乙方签章,3-待甲方签章,4-已签章（已完成）,5-已退回（已拒签）,6-已撤回,7-已过期,8-其他已签章；  单据新增后默认为待签章
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());
		if (DraftTypeEnum.线上起草.getCode().equals(entity.getDraftType())
				&& !statusList.contains(entity.getSignatureStatus())) {
			return CommonResponse.error("合同解除" + (SignatureStatusEnum.已签章.getCode()
					.equals(entity.getSignatureStatus()) ? "已生效" : "已有签章流程") + "，不允许弃审!");
		}
		else if (SignatureStatusEnum.已签章.getCode().equals(entity.getSignatureStatus())) {
			entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
			entity.setPerformanceStatus(Integer.valueOf(ContractPerformanceStateEnum.未签订.getStateCode()));
			service.saveOrUpdate(entity, false);
		}

		// 更新合同履约状态
		PurchaseContractEntity contractEntity = contractService.selectById(entity.getContractId());
		contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.履约中.getStateCode());
		contractService.saveOrUpdate(contractEntity, false);
		// 重新推送合同池
		contractService.pushContract(BeanMapper.map(contractEntity,PurchaseContractVO.class));
		return CommonResponse.success("撤回前校验回调成功！");
	}
	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			PurchaseContractRelieveEntity entity = service.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}
}
