package com.ejianc.business.acceptance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.acceptance.vo.PurchaseAcceptanceVO;

/**
 * 购置验收表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("purchaseAcceptance")
public class PurchaseAcceptanceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SBGZYS";//此处需要根据实际修改

    @Autowired
    private IPurchaseAcceptanceService service;

    @Autowired
    private IPurchaseContractService contractService;
    @Autowired
    private IPurchaseAcceptanceSubService purchaseAcceptanceSubService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseAcceptanceVO> saveOrUpdate(@RequestBody PurchaseAcceptanceVO saveOrUpdateVO) {
    	PurchaseAcceptanceEntity entity = BeanMapper.map(saveOrUpdateVO, PurchaseAcceptanceEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            QueryParam param = new QueryParam();
            param.getParams().put("projectId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getProjectId()));
            param.getParams().put("contractId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getContractId()));
            List<Integer> billStateList = new ArrayList<>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            param.getParams().put("billState",new Parameter(QueryParam.NOT_IN,billStateList));
            param.getParams().put("dr",new Parameter(QueryParam.EQ,0));
            List<PurchaseAcceptanceEntity> entityList = service.queryList(param);
            if(CollectionUtils.isNotEmpty(entityList)){
                throw new BusinessException("存在未生效的验收单！");
            }
        }

        service.saveOrUpdate(entity, false);
    	PurchaseAcceptanceVO vo = BeanMapper.map(entity, PurchaseAcceptanceVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseAcceptanceVO> queryDetail(Long id) {
    	PurchaseAcceptanceEntity entity = service.selectById(id);
    	PurchaseAcceptanceVO vo = BeanMapper.map(entity, PurchaseAcceptanceVO.class);
//        vo.setEquipmentCode(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentCode());
//        vo.setEquipmentType(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentType());
//        vo.setEquipmentName(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentName());
//        vo.setSpec(entity.getPurchaseAcceptanceSubList().get(0).getSpec());
//        vo.setCompany(entity.getPurchaseAcceptanceSubList().get(0).getCompany());
//        vo.setPurchasePrice(entity.getPurchaseAcceptanceSubList().get(0).getPurchasePrice());
//        vo.setContractNum(entity.getPurchaseAcceptanceSubList().get(0).getContractNum());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseAcceptanceVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PurchaseAcceptanceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PurchaseAcceptanceVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchaseAcceptanceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("acceptancePsn");
        param.getFuzzyFields().add("acceptanceDate");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        IPage<PurchaseAcceptanceEntity> page = service.queryPage(param,false);
        IPage<PurchaseAcceptanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseAcceptanceVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PurchaseAcceptanceEntity> list = service.queryList(param);
        List<PurchaseAcceptanceVO> purchaseAcceptanceVOS = BeanMapper.mapList(list, PurchaseAcceptanceVO.class);
        purchaseAcceptanceVOS.forEach(item->{
            item.setBillStatName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", purchaseAcceptanceVOS);
        ExcelExport.getInstance().export("PurchaseAcceptance-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseAcceptanceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseAcceptanceVO>> refPurchaseAcceptanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("equipmentType");
        fuzzyFields.add("equipmentName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("overageSettleTaxMny", new Parameter(QueryParam.GT, 0));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        IPage<PurchaseAcceptanceVO> page = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
//                page = service.refPurchaseAcceptanceData(param,contractId,pageNumber,pageSize);
                param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractId));
                IPage<PurchaseAcceptanceEntity> purchaseAcceptanceEntityIPage = service.queryPage(param);
                List<PurchaseAcceptanceVO> purchaseAcceptanceVOS = BeanMapper.mapList(purchaseAcceptanceEntityIPage.getRecords(), PurchaseAcceptanceVO.class);
                IPage<PurchaseAcceptanceVO> pageData = new Page<>(purchaseAcceptanceEntityIPage.getCurrent(), purchaseAcceptanceEntityIPage.getSize(), purchaseAcceptanceEntityIPage.getTotal());
                pageData.setRecords(purchaseAcceptanceVOS);
                return CommonResponse.success("查询参照数据成功！",pageData);
            }else {
                Long supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                if (supplierId==null){
                    throw new BusinessException("合同和供应商都为空");
                }
                param.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));
                param.getParams().put("isContract",new Parameter(QueryParam.EQ,2));
                IPage<PurchaseAcceptanceEntity> purchaseAcceptanceEntityIPage = service.queryPage(param);
                List<PurchaseAcceptanceVO> purchaseAcceptanceVOS = BeanMapper.mapList(purchaseAcceptanceEntityIPage.getRecords(), PurchaseAcceptanceVO.class);
                IPage<PurchaseAcceptanceVO> pageData = new Page<>(purchaseAcceptanceEntityIPage.getCurrent(), purchaseAcceptanceEntityIPage.getSize(), purchaseAcceptanceEntityIPage.getTotal());
                pageData.setRecords(purchaseAcceptanceVOS);
                return CommonResponse.success("查询参照数据成功！",pageData);
                //throw new BusinessException("合同ID为空");
            }
        }
        return CommonResponse.success("查询列表数据成功！",null);
     }
}
