package com.ejianc.business.asset.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.asset.bean.AssetEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 *  固定资产
 * 
 * @author generator
 * 
 */
public interface IAssetService extends IBaseService<AssetEntity> {

    void pushAsset(Long billId);

    List<AssetVO> queryAssetPage(Page<AssetVO> page, QueryWrapper wrapper,List<Long> orgIs);

    ExecutionVO targetCost(AssetVO assetVO);

    //导入
    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Integer flag);

    CommonResponse<String> updateStatus(List<Long> ids,String assetStatus);

    List<List<String>> getGroupByAssetTypeId(List<Long> orgIds);

    List<List<String>> getSituationStatistics();

    List<List<String>> getUsage();
}
