package com.ejianc.business.asset.controller;

import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.xml.crypto.Data;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 固定资产数据统计
 *
 * @author generator
 */
@Controller
@RequestMapping("assetCountNums")
@Api(value = " 固定资产数据统计", tags = {" 固定资产"})
public class AssetCountNumsController {
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IOrgApi iOrgApi;
    @ApiOperation("各类型固定资产设备统计情况")
    @RequestMapping(value = "/equipmentStatistics",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> equipmentStatistics() {
        List<Long> orgIds = getOrgIds();
        List<Map<String, Object>> ans = assetService.getGroupByAssetTypeId(orgIds);
        return CommonResponse.success("数据查询成功",ans);
    }
    @ApiOperation("各单位固定资产情况统计表")
    @RequestMapping(value = "/situationStatistics",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> situationStatistics(){
        //2.资产情况统计表
        List<Map<String, Object>> maps = assetService.getSituationStatistics();
        return CommonResponse.success("数据查询成功",maps);
    }
    @ApiOperation("固定资产设备使用情况")
    @RequestMapping(value = "/usage",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> usage(){
        //2.资产情况统计表
        List<Map<String, Object>> ans = assetService.getUsage();
        return CommonResponse.success("数据查询成功",ans);
    }
    @ApiOperation("各单位固定资产设备使用情况")
    @RequestMapping(value = "/equipmentUsage",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> equipmentUsage(){
        //2.资产情况统计表
        List<Map<String, Object>> ans = assetService.getEquipmentUsage();
        return CommonResponse.success("数据查询成功",ans);
    }
    @ApiOperation("固定资产设备采购报废情况")
    @RequestMapping(value = "/announce",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> announce(@RequestParam(required = false) String data){
        // 格式化日期为yyyy-MM
        String formattedDate = null;
        if (data != null && !data.isEmpty()) {
            try {
                // 假设传入的data是日期字符串，需要格式化为yyyy-MM
                if (data.length() >= 7) {
                    formattedDate = data.substring(0, 7); // 提取前7个字符，格式为yyyy-MM
                }
            } catch (Exception e) {
                // 处理日期格式异常
                formattedDate = null;
            }
        }
        //2.资产情况统计表
        List<Map<String, Object>> ans = assetService.getAnnounce(formattedDate);
        return CommonResponse.success("数据查询成功",ans);
    }
    private List<Long> getOrgIds() {
        //根据组织数据过滤
        Long parentOrgId = InvocationInfoProxy.getOrgId();
        List<Long> orgIds =
                iOrgApi.findChildrenByParentId(parentOrgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        //2.根据资产类型ID分组查询资产信息
        return orgIds;
    }
}
