package com.ejianc.business.profillreport.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.profillreport.vo.IssuesSystemDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 季度问题隐患和制度措施清单
 * 
 * @author generator
 * 
 */
public class IssuesSystemVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long parentOrgId; // 直管部/分公司id
    private String parentOrgCode; // 直管部/分公司编码
    private String parentOrgName; // 直管部/分公司
    private Long projectId; // 隐患责任单位id
    private String projectName; // 隐患责任单位名称
    private String projectCode; // 隐患责任单位编码
    private String preparer; // 填表人
    private String preparerPhone; // 填表人联系方式
    private String quarter; // 季度
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date preparerTime; // 填表时间
    
    private List<IssuesSystemDetailVO> issuesSystemDetailList = new ArrayList<>(); // 季度问题隐患和制度措施清单-子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getPreparer() {
        return preparer;
    }

    public void setPreparer(String preparer) {
        this.preparer = preparer;
    }
    public String getPreparerPhone() {
        return preparerPhone;
    }

    public void setPreparerPhone(String preparerPhone) {
        this.preparerPhone = preparerPhone;
    }
    public String getQuarter() {
        return quarter;
    }

    public void setQuarter(String quarter) {
        this.quarter = quarter;
    }
    public Date getPreparerTime() {
        return preparerTime;
    }

    public void setPreparerTime(Date preparerTime) {
        this.preparerTime = preparerTime;
    }
    
     public List<IssuesSystemDetailVO> getIssuesSystemDetailList() {
        return issuesSystemDetailList;
     }

     public void setIssuesSystemDetailList(List<IssuesSystemDetailVO> issuesSystemDetailList) {
        this.issuesSystemDetailList = issuesSystemDetailList;
     }
}
