package com.ejianc.business.profillreport.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 成本关门台帐表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_profillreport_cost_close")
public class CostCloseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="first_cost_close_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstCostCloseDate; // 第一次成本关门时间
    @TableField(value="cost_notice_close_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date costNoticeCloseDate; // 成本关门通知关门时间
    @TableField(value="cost_close_delay_num")
    private Integer costCloseDelayNum; // 成本关门滞后时间（天）=第一次成本关门时间-通知关门时间
    @TableField(value="cost_close_urging_num")
    private Integer costCloseUrgingNum; // 成本关门催办次数
    @TableField(value="estimate_cost")
    private BigDecimal estimateCost; // 预估成本
    @TableField(value="two_close_add_cost")
    private BigDecimal twoCloseAddCost; // 二次关门增加的成本金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getFirstCostCloseDate() {
        return firstCostCloseDate;
    }

    public void setFirstCostCloseDate(Date firstCostCloseDate) {
        this.firstCostCloseDate = firstCostCloseDate;
    }
    public Date getCostNoticeCloseDate() {
        return costNoticeCloseDate;
    }

    public void setCostNoticeCloseDate(Date costNoticeCloseDate) {
        this.costNoticeCloseDate = costNoticeCloseDate;
    }
    public Integer getCostCloseDelayNum() {
        return costCloseDelayNum;
    }

    public void setCostCloseDelayNum(Integer costCloseDelayNum) {
        this.costCloseDelayNum = costCloseDelayNum;
    }
    public Integer getCostCloseUrgingNum() {
        return costCloseUrgingNum;
    }

    public void setCostCloseUrgingNum(Integer costCloseUrgingNum) {
        this.costCloseUrgingNum = costCloseUrgingNum;
    }
    public BigDecimal getEstimateCost() {
        return estimateCost;
    }

    public void setEstimateCost(BigDecimal estimateCost) {
        this.estimateCost = estimateCost;
    }
    public BigDecimal getTwoCloseAddCost() {
        return twoCloseAddCost;
    }

    public void setTwoCloseAddCost(BigDecimal twoCloseAddCost) {
        this.twoCloseAddCost = twoCloseAddCost;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    
}
