package com.ejianc.business.profinance.api;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.hystrix.ReceiptAndPaymentRegisterHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;


/**
 * 收款登记和付款登记API
 */
@FeignClient(name = "ejc-profinance-web", url = "${common.env.feign-client-url}", path = "ejc-profinance-web", fallback = ReceiptAndPaymentRegisterHystrix.class)
public interface IReceiptAndPaymentRegisterApi {

    /**
     * 通过根据项目ids查询 收款登记 本次实收金额  付款登记合计 本次付款金额合计
     * @param  queryParam
     * @return
     */
    @PostMapping(value = "/api/receiptAndPaymentRegisterApi/queryReceiptAndPaymentMny")
    CommonResponse<JSONObject> queryReceiptAndPaymentMny(@RequestBody QueryParam queryParam);


    /**
     * 通过根据项目id,合同类型查询付款金额合计
     * @return
     */
    @GetMapping(value = "/api/receiptAndPaymentRegisterApi/queryPayMnyByProjAndContType")
    CommonResponse<JSONObject> queryPayMnyByProjAndContType(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "contractType") String contractType);

    /**
     * 查询指定合同
     *  1、在指定范围内产生付款登记的总金额
     *  2、上一年度付款金额
     *  3、合同开工付款登记总金额
     *
     * @return
     */
    @GetMapping(value = "/api/receiptAndPaymentRegisterApi/getContractPayInfo")
    CommonResponse<List<Map<String, Object>>> getContractPayInfo(@RequestParam String paramJson);

    /**
     * 查询指定合同
     *  1、在指定范围内产生付款登记的总金额
     *  2、上一年度付款金额
     *  3、合同开工付款登记总金额
     *
     * @return
     */
    @PostMapping(value = "/api/receiptAndPaymentRegisterApi/queryContractPayInfo")
    CommonResponse<List<Map<String, Object>>> queryContractPayInfo(@RequestBody MultiValueMap<String, String> param);

    /**
     * 查询指定合同
     * 1、在指定范围内产生收款登记的总金额
     * 2、上一年度收款金额
     * 3、合同开工收款登记总金额
     *
     * @param param
     * @return
     */
    @PostMapping(value = "/api/receiptAndPaymentRegisterApi/queryContractRecInfo")
    CommonResponse<List<Map<String, Object>>> queryContractRecInfo(@RequestBody JSONObject param);
}
