package com.ejianc.business.profinance.api;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.hystrix.PaymentApplyHystrix;
import com.ejianc.business.profinance.hystrix.ReceiptAndPaymentRegisterHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * 收款登记和付款登记API
 */
@FeignClient(name = "ejc-profinance-web", url = "${common.env.feign-client-url}", path = "ejc-profinance-web", fallback = ReceiptAndPaymentRegisterHystrix.class)
public interface IReceiptAndPaymentRegisterApi {

    /**
     * 通过根据项目ids查询 收款登记 本次实收金额  付款登记合计 本次付款金额合计
     * @param  queryParam
     * @return
     */
    @PostMapping(value = "/api/receiptAndPaymentRegisterApi/queryReceiptAndPaymentMny")
    CommonResponse<JSONObject> queryReceiptAndPaymentMny(@RequestBody QueryParam queryParam);


    /**
     * 通过根据项目id,合同类型查询付款金额合计
     * @return
     */
    @GetMapping(value = "/api/receiptAndPaymentRegisterApi/queryPayMnyByProjAndContType")
    CommonResponse<JSONObject> queryPayMnyByProjAndContType(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "contractType") String contractType);

}
