package com.ejianc.business.profinance.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 项目资金计划-临时机械租赁
 *
 * @author baipengyan
 */
public class PlanTemporaryVO extends BaseVO {
	private static final long serialVersionUID = -5141671154530138803L;

	private Integer billState; // 单据状态
	private String billStateName; // 单据状态名称
	private String temporarySettleType; // 结算单类型
	private String temporarySettleTypeName; // 结算单类型名称
	private Long temporarySettleId; // 结算单Id
	private String temporarySettleCode; // 结算单编码
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date temporarySettleDate; // 结算日期
	private String temporarySettleRouteUrl; // 临时机械租赁路由地址
	private Long temporaryPayTypeNoContractId; // 无合同费用类型id
	private String temporaryPayTypeNoContractCode; // 无合同费用类型编码
	private String temporaryPayTypeNoContractName; // 无合同费用类型名称
	private Long temporaryPartybId; // 结算乙方Id
	private String temporaryPartybName; // 收款单位 =结算乙方名称
	private BigDecimal temporarySettleMny; // 结算金额
	private String temporaryPaymentContent; // 付款内容
	private Long temporarySettleModeId; // 结算方式id =自定义档案【大企业收付款登记-结算方式】
	private String temporarySettleModeCode; // 结算方式编码
	private String temporarySettleModeName; // 结算方式名称
	private BigDecimal temporaryAppliedMny; // 已申请金额(不含本次)
	private BigDecimal temporaryCanApplyMny; // 本次可申请金额
	private BigDecimal temporaryPlanPaymentMny; // 本次计划付款金额
	private BigDecimal temporaryTotalApplyPaymentMny; // 累计申请付款金额(含本次)
	private BigDecimal temporaryPaidScale; // 已付款比例%（含本次）
	private String temporaryMemo; // 备注
	private BigDecimal totalActualPaymentMny; // 本次累计实付金额
	private BigDecimal unpaidMny; // 本次未支付金额
	private BigDecimal releaseApplyMny; // 本次释放申请金额
	private String closeState; // 关闭状态 已关闭 未关闭
	private Date closeDateTime; // 关闭时间
	private Long closeUserId; // 关闭人
	private String closeUserName; // 关闭人名称
	private String closeUserCode; // 关闭人编码
	private Long planId; // 项目资金计划id


	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public String getTemporarySettleType() {
		return temporarySettleType;
	}

	public void setTemporarySettleType(String temporarySettleType) {
		this.temporarySettleType = temporarySettleType;
	}

	public String getTemporarySettleTypeName() {
		return temporarySettleTypeName;
	}

	public void setTemporarySettleTypeName(String temporarySettleTypeName) {
		this.temporarySettleTypeName = temporarySettleTypeName;
	}

	public Long getTemporarySettleId() {
		return temporarySettleId;
	}

	public void setTemporarySettleId(Long temporarySettleId) {
		this.temporarySettleId = temporarySettleId;
	}

	public String getTemporarySettleCode() {
		return temporarySettleCode;
	}

	public void setTemporarySettleCode(String temporarySettleCode) {
		this.temporarySettleCode = temporarySettleCode;
	}

	public Date getTemporarySettleDate() {
		return temporarySettleDate;
	}

	public void setTemporarySettleDate(Date temporarySettleDate) {
		this.temporarySettleDate = temporarySettleDate;
	}

	public String getTemporarySettleRouteUrl() {
		return temporarySettleRouteUrl;
	}

	public void setTemporarySettleRouteUrl(String temporarySettleRouteUrl) {
		this.temporarySettleRouteUrl = temporarySettleRouteUrl;
	}

	public Long getTemporaryPayTypeNoContractId() {
		return temporaryPayTypeNoContractId;
	}

	public void setTemporaryPayTypeNoContractId(Long temporaryPayTypeNoContractId) {
		this.temporaryPayTypeNoContractId = temporaryPayTypeNoContractId;
	}

	public String getTemporaryPayTypeNoContractCode() {
		return temporaryPayTypeNoContractCode;
	}

	public void setTemporaryPayTypeNoContractCode(String temporaryPayTypeNoContractCode) {
		this.temporaryPayTypeNoContractCode = temporaryPayTypeNoContractCode;
	}

	public String getTemporaryPayTypeNoContractName() {
		return temporaryPayTypeNoContractName;
	}

	public void setTemporaryPayTypeNoContractName(String temporaryPayTypeNoContractName) {
		this.temporaryPayTypeNoContractName = temporaryPayTypeNoContractName;
	}

	public Long getTemporaryPartybId() {
		return temporaryPartybId;
	}

	public void setTemporaryPartybId(Long temporaryPartybId) {
		this.temporaryPartybId = temporaryPartybId;
	}

	public String getTemporaryPartybName() {
		return temporaryPartybName;
	}

	public void setTemporaryPartybName(String temporaryPartybName) {
		this.temporaryPartybName = temporaryPartybName;
	}

	public BigDecimal getTemporarySettleMny() {
		return temporarySettleMny;
	}

	public void setTemporarySettleMny(BigDecimal temporarySettleMny) {
		this.temporarySettleMny = temporarySettleMny;
	}

	public String getTemporaryPaymentContent() {
		return temporaryPaymentContent;
	}

	public void setTemporaryPaymentContent(String temporaryPaymentContent) {
		this.temporaryPaymentContent = temporaryPaymentContent;
	}

	public Long getTemporarySettleModeId() {
		return temporarySettleModeId;
	}

	@ReferDeserialTransfer
	public void setTemporarySettleModeId(Long temporarySettleModeId) {
		this.temporarySettleModeId = temporarySettleModeId;
	}

	public String getTemporarySettleModeCode() {
		return temporarySettleModeCode;
	}

	public void setTemporarySettleModeCode(String temporarySettleModeCode) {
		this.temporarySettleModeCode = temporarySettleModeCode;
	}

	public String getTemporarySettleModeName() {
		return temporarySettleModeName;
	}

	public void setTemporarySettleModeName(String temporarySettleModeName) {
		this.temporarySettleModeName = temporarySettleModeName;
	}

	public BigDecimal getTemporaryAppliedMny() {
		return temporaryAppliedMny;
	}

	public void setTemporaryAppliedMny(BigDecimal temporaryAppliedMny) {
		this.temporaryAppliedMny = temporaryAppliedMny;
	}

	public BigDecimal getTemporaryCanApplyMny() {
		return temporaryCanApplyMny;
	}

	public void setTemporaryCanApplyMny(BigDecimal temporaryCanApplyMny) {
		this.temporaryCanApplyMny = temporaryCanApplyMny;
	}

	public BigDecimal getTemporaryPlanPaymentMny() {
		return temporaryPlanPaymentMny;
	}

	public void setTemporaryPlanPaymentMny(BigDecimal temporaryPlanPaymentMny) {
		this.temporaryPlanPaymentMny = temporaryPlanPaymentMny;
	}

	public BigDecimal getTemporaryTotalApplyPaymentMny() {
		return temporaryTotalApplyPaymentMny;
	}

	public void setTemporaryTotalApplyPaymentMny(BigDecimal temporaryTotalApplyPaymentMny) {
		this.temporaryTotalApplyPaymentMny = temporaryTotalApplyPaymentMny;
	}

	public BigDecimal getTemporaryPaidScale() {
		return temporaryPaidScale;
	}

	public void setTemporaryPaidScale(BigDecimal temporaryPaidScale) {
		this.temporaryPaidScale = temporaryPaidScale;
	}

	public String getTemporaryMemo() {
		return temporaryMemo;
	}

	public void setTemporaryMemo(String temporaryMemo) {
		this.temporaryMemo = temporaryMemo;
	}

	public BigDecimal getTotalActualPaymentMny() {
		return totalActualPaymentMny;
	}

	public void setTotalActualPaymentMny(BigDecimal totalActualPaymentMny) {
		this.totalActualPaymentMny = totalActualPaymentMny;
	}

	public BigDecimal getUnpaidMny() {
		return unpaidMny;
	}

	public void setUnpaidMny(BigDecimal unpaidMny) {
		this.unpaidMny = unpaidMny;
	}

	public BigDecimal getReleaseApplyMny() {
		return releaseApplyMny;
	}

	public void setReleaseApplyMny(BigDecimal releaseApplyMny) {
		this.releaseApplyMny = releaseApplyMny;
	}

	public String getCloseState() {
		return closeState;
	}

	public void setCloseState(String closeState) {
		this.closeState = closeState;
	}

	public Date getCloseDateTime() {
		return closeDateTime;
	}

	public void setCloseDateTime(Date closeDateTime) {
		this.closeDateTime = closeDateTime;
	}

	public Long getCloseUserId() {
		return closeUserId;
	}

	public void setCloseUserId(Long closeUserId) {
		this.closeUserId = closeUserId;
	}

	public String getCloseUserName() {
		return closeUserName;
	}

	public void setCloseUserName(String closeUserName) {
		this.closeUserName = closeUserName;
	}

	public String getCloseUserCode() {
		return closeUserCode;
	}

	public void setCloseUserCode(String closeUserCode) {
		this.closeUserCode = closeUserCode;
	}

	public Long getPlanId() {
		return planId;
	}

	public void setPlanId(Long planId) {
		this.planId = planId;
	}

}
