package com.ejianc.business.profinance.projectloan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 借款管理-项目还款实体
 *
 * @author baipengyan
 */
public class ProjectRepayVO extends BaseVO {
	private static final long serialVersionUID = -4420247136430039024L;

	private Date commitDate; // 提交日期
	private String commitUserName; // 提交人名称
	private String commitUserCode; // 提交人账号
	private Date effectiveDate; // 生效日期
	private String billCode; // 单据编号
	private String billName; // 单据名称
	private Integer billState; // 单据状态
	private String billStateName; // 单据状态名称
	private Long employeeId; // 经办人id
	private String employeeName; // 经办人名称
	private Long departmentId; // 经办部门id
	private String departmentName; // 经办部门名称
	private Long repayUnitId; // 还款单位id
	private String repayUnitCode; // 还款单位编码
	private String repayUnitName; // 还款单位名称
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date repayDate; // 还款日期
	private Long settleTypeId; // 结算方式id
	private String settleTypeCode; // 结算方式编码
	private String settleTypeName; // 结算方式名称
	private BigDecimal curTotalRepayMny; // 本次还款金额合计
	private String memo; // 备注

	private List<ProjectRepayDetailVO> projectRepayDetailList = new ArrayList<>(); // 借款管理-项目还款明细

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	@ReferDeserialTransfer
	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Long getDepartmentId() {
		return departmentId;
	}

	@ReferDeserialTransfer
	public void setDepartmentId(Long departmentId) {
		this.departmentId = departmentId;
	}

	public String getDepartmentName() {
		return departmentName;
	}

	public void setDepartmentName(String departmentName) {
		this.departmentName = departmentName;
	}

	public Long getRepayUnitId() {
		return repayUnitId;
	}

	@ReferDeserialTransfer
	public void setRepayUnitId(Long repayUnitId) {
		this.repayUnitId = repayUnitId;
	}

	public String getRepayUnitCode() {
		return repayUnitCode;
	}

	public void setRepayUnitCode(String repayUnitCode) {
		this.repayUnitCode = repayUnitCode;
	}

	public String getRepayUnitName() {
		return repayUnitName;
	}

	public void setRepayUnitName(String repayUnitName) {
		this.repayUnitName = repayUnitName;
	}

	public Date getRepayDate() {
		return repayDate;
	}

	public void setRepayDate(Date repayDate) {
		this.repayDate = repayDate;
	}

	public Long getSettleTypeId() {
		return settleTypeId;
	}

	@ReferDeserialTransfer
	public void setSettleTypeId(Long settleTypeId) {
		this.settleTypeId = settleTypeId;
	}

	public String getSettleTypeCode() {
		return settleTypeCode;
	}

	public void setSettleTypeCode(String settleTypeCode) {
		this.settleTypeCode = settleTypeCode;
	}

	public String getSettleTypeName() {
		return settleTypeName;
	}

	public void setSettleTypeName(String settleTypeName) {
		this.settleTypeName = settleTypeName;
	}

	public BigDecimal getCurTotalRepayMny() {
		return curTotalRepayMny;
	}

	public void setCurTotalRepayMny(BigDecimal curTotalRepayMny) {
		this.curTotalRepayMny = curTotalRepayMny;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public List<ProjectRepayDetailVO> getProjectRepayDetailList() {
		return projectRepayDetailList;
	}

	public void setProjectRepayDetailList(List<ProjectRepayDetailVO> projectRepayDetailList) {
		this.projectRepayDetailList = projectRepayDetailList;
	}
}
