package com.ejianc.business.profinance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 付款管理 详情表
 * 
 * @author generator
 * 
 */
public class RegisterDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long createUserId; // 创建者账号
    private String billCode; // 单据编码
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long registerId; // 父id
    private Long sourceId; // 来源结算单号id
    private String sourceCode; // 来源结算单号编码
    private Long sourceParentId; // 来源结算单父id
    private String sourceParentCode; // 来源结算单父编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    private Date planDate;//计划日期
    private Date happenDate;//发生日期
    private BigDecimal settleMny; // 结算金额
    private BigDecimal planMny; // 本次计划付款
    private BigDecimal lastMny; // 已支付金额(不含本次)
    private BigDecimal payableMny; // 本次可支付金额
    private BigDecimal actualMny; // 本次实付金额
    private BigDecimal totalActualMny; // 累计实付金额(含本次)
    private String detailMemo; // 备注
    private String refStatus;//引用状态
    private String detailLinkUrl;//穿透地址
    private String detailLinkName;//穿透名字
    private String sourceBillCode; // 来源单据编号

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public Date getHappenDate() {
        return happenDate;
    }

    public void setHappenDate(Date happenDate) {
        this.happenDate = happenDate;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public String getDetailLinkUrl() {
        return detailLinkUrl;
    }

    public void setDetailLinkUrl(String detailLinkUrl) {
        this.detailLinkUrl = detailLinkUrl;
    }

    public String getDetailLinkName() {
        return detailLinkName;
    }

    public void setDetailLinkName(String detailLinkName) {
        this.detailLinkName = detailLinkName;
    }

    public String getRefStatus() {
        return refStatus;
    }

    public void setRefStatus(String refStatus) {
        this.refStatus = refStatus;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getRegisterId() {
        return registerId;
    }

    public void setRegisterId(Long registerId) {
        this.registerId = registerId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    public Long getSourceParentId() {
        return sourceParentId;
    }

    public void setSourceParentId(Long sourceParentId) {
        this.sourceParentId = sourceParentId;
    }
    public String getSourceParentCode() {
        return sourceParentCode;
    }

    public void setSourceParentCode(String sourceParentCode) {
        this.sourceParentCode = sourceParentCode;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getPlanMny() {
        return planMny;
    }

    public void setPlanMny(BigDecimal planMny) {
        this.planMny = planMny;
    }
    public BigDecimal getLastMny() {
        return lastMny;
    }

    public void setLastMny(BigDecimal lastMny) {
        this.lastMny = lastMny;
    }
    public BigDecimal getPayableMny() {
        return payableMny;
    }

    public void setPayableMny(BigDecimal payableMny) {
        this.payableMny = payableMny;
    }
    public BigDecimal getActualMny() {
        return actualMny;
    }

    public void setActualMny(BigDecimal actualMny) {
        this.actualMny = actualMny;
    }
    public BigDecimal getTotalActualMny() {
        return totalActualMny;
    }

    public void setTotalActualMny(BigDecimal totalActualMny) {
        this.totalActualMny = totalActualMny;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    
}
