package com.ejianc.business.profinance.common.service.impl;

import com.ejianc.business.profinance.common.bean.BillHandleResultEntity;
import com.ejianc.business.profinance.common.mapper.BillHandleResultMapper;
import com.ejianc.business.profinance.common.service.IBillHandleResultService;
import com.ejianc.business.profinance.common.vo.BillHandleResultVO;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author CJ
 * @Description:
 * @date 2022/6/20 19:12
 */
@Service("billHandleService")
public class BillHandleServiceImpl extends BaseServiceImpl<BillHandleResultMapper, BillHandleResultEntity> implements IBillHandleResultService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public boolean sendHandleResult(String handleDataJson, String handleBillIdStr, String handleBillType, String handleCode, String handleMsg) {
        return sendHandleResult(handleDataJson, handleBillIdStr, handleBillType, handleCode, handleMsg, true);
    }

    @Override
    public boolean sendHandleResult(String handleDataJson, String handleBillIdStr, String handleBillType, String handleCode, String handleMsg, boolean handleWithSubService) {
        try {
            BillHandleResultVO record = new BillHandleResultVO();
            record.setBillDataJson(handleDataJson);
            record.setHandleBillType(handleBillType);
            record.setHandleBillIdStr(handleBillIdStr);
            record.setHandleResultCode(handleCode);
            record.setHandleResultMsg(handleMsg);
            record.setHandleWithSubService(handleWithSubService);

            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody(record);
            logger.info("接收单据处理结果信息：{}，放入待处理队列", handleDataJson);
            rabbitTemplate.convertAndSend(BillHandleResultVO.MESSAGE_QUEUE, mqMessage);
            return true;
        } catch (Exception e) {
            logger.error("将单据处理结果-[{}],待处理单据类型-{}, 处理结果状态码-{},处理结果信息-{}发送待处理队列失败！",
                    handleDataJson, handleBillType, handleCode, handleMsg);
            return false;
        }
    }
}
