package com.ejianc.business.profinance.person.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.profinance.person.mapper.PersonLoanMapper;
import com.ejianc.business.profinance.person.bean.PersonLoanEntity;
import com.ejianc.business.profinance.person.service.IPersonLoanService;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 借款管理-个人借款
 * 
 * @author generator
 * 
 */
@Service("personLoanService")
public class PersonLoanServiceImpl extends BaseServiceImpl<PersonLoanMapper, PersonLoanEntity> implements IPersonLoanService{

    @Override
    public Map<String, BigDecimal> fetchTotalMny(QueryParam param) {
//        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        QueryWrapper wrapper = changeToQueryWrapper(param);
//        wrapper.select("SELECT IFNULL ( SUM( loan_mny ), 0 ) AS totalLoanMny,IFNULL ( SUM( repaid_loan_mny ), 0 ) AS totalRepaidLoanMny, IFNULL ( SUM( left_loan_mny ), 0 ) AS totalLeftLoanMny");
        wrapper.select("ifnull(sum(loan_mny), 0) as totalLoanMny, ifnull(sum(repaid_loan_mny), 0) as totalRepaidLoanMny, ifnull(sum(left_loan_mny), 0) as totalLeftLoanMny");

        return super.getMap(wrapper);
    }

    @Override
    public void updateColumnValue(List<Long> ids, String column, String value) {
        UpdateWrapper<PersonLoanEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.in("id", ids);
        updateWrapper.set(column, value);
        super.update(updateWrapper);
    }
}
