package com.ejianc.business.profinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.service.IRegisterDetailService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service("paymentRegister") 
public class PaymentRegisterBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
	private IPaymentRegisterService service;
	private Logger logger = LoggerFactory.getLogger(this.getClass());


	@Autowired
	private IRegisterDetailService detailService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};
	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PaymentRegisterEntity paymentRegisterEntity = service.selectById(billId);
		detailService.updateBillState(billId,state);
		if(paymentRegisterEntity.getPaymentContractFlag()!=0&&paymentRegisterEntity.getPaymentContractFlag()!=1){
			service.updateStatus(paymentRegisterEntity,2);
			service.writeBack(paymentRegisterEntity,true);
		}
		return CommonResponse.success("付款管理终审回调成功！");

	}




	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}


	//撤回、弃审回调方法
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		PaymentRegisterEntity paymentRegisterEntity = service.selectById(billId);
		if (paymentRegisterEntity == null) {
			return CommonResponse.error("查询不到该单据信息！");
		}
		QueryWrapper<PaymentRegisterEntity> listQueryOrderByTime = new QueryWrapper<>();
		//撤回校验  有合同付款申请：项目+合同
		//无合同付款 项目+供应商
		if (paymentRegisterEntity.getPaymentContractFlag()==0){
			//查询当前合同是否存在自由态的单据
			QueryWrapper<PaymentRegisterEntity> listQuery = new QueryWrapper<>();
			listQuery.eq("contract_id", paymentRegisterEntity.getContractId());
			listQuery.in("bill_state", new Integer[]{
					BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
					BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
					BillStateEnum.UNAPPROVED.getBillStateCode(),
					BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
					BillStateEnum.SUSPEND.getBillStateCode()
			});
			int resultCount = service.count(listQuery);
			if (resultCount > 0) {
				return CommonResponse.error("当前合同存在未生效的付款登记 不能弃审/撤回！");
			}
			listQueryOrderByTime.eq("contract_id", paymentRegisterEntity.getContractId());
		} else {
			listQueryOrderByTime.eq("supplier_id", paymentRegisterEntity.getSupplierId());
		}

		listQueryOrderByTime.eq("project_id", paymentRegisterEntity.getProjectId());
		listQueryOrderByTime.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
		listQueryOrderByTime.orderByDesc("create_time");
		List<PaymentRegisterEntity> listOrderByTime = service.list(listQueryOrderByTime);
		if (CollectionUtils.isNotEmpty(listOrderByTime) && null != listOrderByTime.get(0)){
			if (!listOrderByTime.get(0).getId().equals(billId)){
				return CommonResponse.error("当前单据不是最新的付款登记，不能弃审/撤回！");
			}
		}
		if(paymentRegisterEntity.getPaymentContractFlag()!=0&&paymentRegisterEntity.getPaymentContractFlag()!=1){
			service.writeBack(paymentRegisterEntity,true);
			service.updateStatus(paymentRegisterEntity,0);
		}
		detailService.updateBillState(billId,state);
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

}
