package com.ejianc.business.profinance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 付款申请详情实体
 *
 * @author generator
 *
 */
@TableName("ejc_payment_apply_detail")
public class PaymentApplyDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="create_user_id")
    private Long createUserId; // 创建者账号
    @TableField(value="pay_id")
    private Long payId; // 付款申请id
    @TableField(value="source_id")
    private Long sourceId; // 结算id 来源
    @TableField(value="source_bill_code")
    private String sourceBillCode; // 结算单据号
    @TableField(value="source_type")
    private String sourceType; // 来源类型
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="project_org_id")
    private Long projectOrgId; // 项目部所属组织id
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value="settle_date")
    private Date settleDate; // 结算日期
    @TableField(value="current_settle_mny")
    private BigDecimal currentSettleMny; // 本期结算金额
    @TableField(value="current_apply_mny")
    private BigDecimal currentApplyMny; // 本期申请金额
    @TableField(value="already_apply_mny")
    private BigDecimal alreadyApplyMny; // 已申请金额
    @TableField(value="residue_apply_mny")
    private BigDecimal residueApplyMny; // 剩余可申请金额
    @TableField(value="advance_payment_deduction")
    private BigDecimal advancePaymentDeduction; // 预付款扣减分摊
    @TableField(value="actual_payment_mny")
    private BigDecimal actualPaymentMny; // 实际付款金额
    @TableField(value="actual_apply_mny")
    private BigDecimal actualApplyMny; // 实际申请占用金额 默认等于申请金额 关闭后默认等于实际付款
    @TableField(value="memo")
    private String memo; // 备注 非必填，0-500字
    @TableField(value="settle_link_url")
    private String settleLinkUrl;
    @TableField(value = "total_app_mny")
    private BigDecimal totalAppMny;//累计申请金额(含本期)
    @TableField(value = "source_type_name")
    private String sourceTypeName;//结算类型名称
    @TableField(value = "source_type_name_str")
    private String sourceTypeNameStr;//结算类型

    @TableField("total_settle_payment_tax_mny")
    private BigDecimal totalSettlePaymentTaxMny;//累计结算支付金额（含税）

    public String getSourceTypeNameStr() {
        return sourceTypeNameStr;
    }

    public void setSourceTypeNameStr(String sourceTypeNameStr) {
        this.sourceTypeNameStr = sourceTypeNameStr;
    }

    public BigDecimal getTotalSettlePaymentTaxMny() {
        return totalSettlePaymentTaxMny;
    }

    public void setTotalSettlePaymentTaxMny(BigDecimal totalSettlePaymentTaxMny) {
        this.totalSettlePaymentTaxMny = totalSettlePaymentTaxMny;
    }

    public BigDecimal getTotalAppMny() {
        return totalAppMny;
    }

    public void setTotalAppMny(BigDecimal totalAppMny) {
        this.totalAppMny = totalAppMny;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }


    public String getSettleLinkUrl() {
        return settleLinkUrl;
    }

    public void setSettleLinkUrl(String settleLinkUrl) {
        this.settleLinkUrl = settleLinkUrl;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public Long getPayId() {
        return payId;
    }

    public void setPayId(Long payId) {
        this.payId = payId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public BigDecimal getCurrentSettleMny() {
        return currentSettleMny;
    }

    public void setCurrentSettleMny(BigDecimal currentSettleMny) {
        this.currentSettleMny = currentSettleMny;
    }
    public BigDecimal getCurrentApplyMny() {
        return currentApplyMny;
    }

    public void setCurrentApplyMny(BigDecimal currentApplyMny) {
        this.currentApplyMny = currentApplyMny;
    }
    public BigDecimal getAlreadyApplyMny() {
        return alreadyApplyMny;
    }

    public void setAlreadyApplyMny(BigDecimal alreadyApplyMny) {
        this.alreadyApplyMny = alreadyApplyMny;
    }
    public BigDecimal getResidueApplyMny() {
        return residueApplyMny;
    }

    public void setResidueApplyMny(BigDecimal residueApplyMny) {
        this.residueApplyMny = residueApplyMny;
    }
    public BigDecimal getAdvancePaymentDeduction() {
        return advancePaymentDeduction;
    }

    public void setAdvancePaymentDeduction(BigDecimal advancePaymentDeduction) {
        this.advancePaymentDeduction = advancePaymentDeduction;
    }
    public BigDecimal getActualPaymentMny() {
        return actualPaymentMny;
    }

    public void setActualPaymentMny(BigDecimal actualPaymentMny) {
        this.actualPaymentMny = actualPaymentMny;
    }
    public BigDecimal getActualApplyMny() {
        return actualApplyMny;
    }

    public void setActualApplyMny(BigDecimal actualApplyMny) {
        this.actualApplyMny = actualApplyMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
