package com.ejianc.business.receipt.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.receipt.bean.ReceiptRegisterEntity;
import com.ejianc.business.receipt.service.IReceiptRegisterService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;

/**
 * 收款登记api
 *
 * @author generator
 */
@RestController
@RequestMapping("/api/receiptRegisterApi/")
public class ReceiptRegisterApi implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IReceiptRegisterService service;


    /**
     * 通过项目id查询相应的累计收款金额
     * @param projectId
     * @return
     */
    @GetMapping(value = "queryRecMnyByProjectId")
    CommonResponse<BigDecimal> queryRecMnyByProjectId(@RequestParam(value = "projectId") Long projectId){
        QueryWrapper<ReceiptRegisterEntity> listQuery = new QueryWrapper<>();
        listQuery.select("ifnull(sum(sum_received_mny), 0) as sumReceivedMny");
        listQuery.eq("project_id", projectId);
        listQuery.eq("tenant_id", InvocationInfoProxy.getTenantid());
        listQuery.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map<String,Object> resultMap = service.getMap(listQuery);
        BigDecimal sumReceivedMny = BigDecimal.ZERO;
        if (resultMap.containsKey("sumReceivedMny")){
            sumReceivedMny = null != resultMap.get("sumReceivedMny") && !new BigDecimal("0E-8").equals(resultMap.get("sumReceivedMny"))? new BigDecimal(resultMap.get("sumReceivedMny").toString()) : BigDecimal.ZERO;
        }
        return CommonResponse.success("查询累计收款金额成功！", sumReceivedMny);
    }
}
