/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.receipt.bean.ReceiptRegisterEntity;
import com.ejianc.business.receipt.service.IReceiptRegisterService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/receiptAndPaymentRegisterApi/"})
public class ReceiptAndPaymentRegisterApi
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IPaymentRegisterService paymentRegisterService;
    @Autowired
    private IReceiptRegisterService receiptRegisterService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostMapping(value={"/queryReceiptAndPaymentMny"})
    CommonResponse<JSONObject> queryReceiptAndPaymentMny(@RequestBody QueryParam queryParam) {
        JSONObject jsonObject = new JSONObject();
        QueryWrapper paymentWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        paymentWrapper.select(new String[]{"IFNULL(SUM(pay_mny),0) AS payMny"});
        PaymentRegisterEntity paymentRegisterEntity = (PaymentRegisterEntity)((Object)this.paymentRegisterService.getOne((Wrapper)paymentWrapper));
        jsonObject.put("payMny", (Object)paymentRegisterEntity.getPayMny());
        QueryWrapper receiptRegisterWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        receiptRegisterWrapper.select(new String[]{"IFNULL(SUM(sum_received_mny),0) AS sumReceivedMny"});
        ReceiptRegisterEntity receiptRegisterEntity = (ReceiptRegisterEntity)((Object)this.receiptRegisterService.getOne((Wrapper)receiptRegisterWrapper));
        jsonObject.put("sumReceivedMny", (Object)receiptRegisterEntity.getSumReceivedMny());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)jsonObject);
    }

    @GetMapping(value={"/queryPayMnyByProjAndContType"})
    CommonResponse<JSONObject> queryPayMnyByProjAndContType(@RequestParam(value="projectId") Long projectId, @RequestParam(value="contractType") String contractType) {
        JSONObject jsonObject = new JSONObject();
        BigDecimal payMny = BigDecimal.ZERO;
        QueryWrapper paymentWrapper = new QueryWrapper();
        paymentWrapper.eq((Object)"project_id", (Object)projectId);
        paymentWrapper.eq((Object)"source_category_type", (Object)contractType);
        paymentWrapper.eq((Object)"payment_contract_flag", (Object)0);
        paymentWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        paymentWrapper.select(new String[]{"IFNULL(SUM(pay_mny),0) AS payMny"});
        PaymentRegisterEntity paymentRegisterEntity = (PaymentRegisterEntity)((Object)this.paymentRegisterService.getOne((Wrapper)paymentWrapper));
        payMny = ComputeUtil.safeAdd((BigDecimal)payMny, (BigDecimal)paymentRegisterEntity.getPayMny());
        if (ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode().equals(contractType)) {
            QueryWrapper noContQuery = new QueryWrapper();
            noContQuery.eq((Object)"project_id", (Object)projectId);
            noContQuery.eq((Object)"payment_contract_flag", (Object)1);
            noContQuery.eq((Object)"fee_type_code", (Object)"sporadic_material_fee");
            noContQuery.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            noContQuery.select(new String[]{"IFNULL(SUM(pay_mny),0) AS payMny"});
            PaymentRegisterEntity noContEntity = (PaymentRegisterEntity)((Object)this.paymentRegisterService.getOne((Wrapper)noContQuery));
            payMny = ComputeUtil.safeAdd((BigDecimal)payMny, (BigDecimal)noContEntity.getPayMny());
        } else if (ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode().equals(contractType)) {
            QueryWrapper noContQuery = new QueryWrapper();
            noContQuery.eq((Object)"project_id", (Object)projectId);
            noContQuery.eq((Object)"payment_contract_flag", (Object)1);
            noContQuery.eq((Object)"fee_type_code", (Object)"temp_equip_fee");
            noContQuery.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            noContQuery.select(new String[]{"IFNULL(SUM(pay_mny),0) AS payMny"});
            PaymentRegisterEntity noContEntity = (PaymentRegisterEntity)((Object)this.paymentRegisterService.getOne((Wrapper)noContQuery));
            payMny = ComputeUtil.safeAdd((BigDecimal)payMny, (BigDecimal)noContEntity.getPayMny());
        }
        jsonObject.put("payMny", (Object)payMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)jsonObject);
    }

    @PostMapping(value={"queryContractPayInfo"})
    public CommonResponse<List<Map<String, Object>>> queryContractPayInfo(@RequestBody MultiValueMap<String, String> param) {
        return this.getContractPayInfo((String)((List)param.get((Object)"paramJson")).get(0));
    }

    @GetMapping(value={"getContractPayInfo"})
    public CommonResponse<List<Map<String, Object>>> getContractPayInfo(@RequestParam String paramJson) {
        List<Object> resp = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)paramJson)) {
            List contractTypeMap;
            JSONObject param = JSONObject.parseObject((String)paramJson);
            String curStartDate = param.getString("curStartDate");
            String curEndDate = param.getString("curEndDate");
            String curYear = param.getString("curYear");
            String lastYearStartDate = param.getString("lastYearStartDate");
            String lastYearEndDate = param.getString("lastYearEndDate");
            ArrayList<Long> contractIds = null != param.get((Object)"contractIds") ? param.getJSONArray("contractIds").toJavaList(Long.class) : new ArrayList<Long>();
            List list = contractTypeMap = null != param.get((Object)"contractTypeMap") ? param.getJSONArray("contractTypeMap").toJavaList(JSONObject.class) : null;
            if (CollectionUtils.isNotEmpty(contractTypeMap) && CollectionUtils.isEmpty(contractIds)) {
                contractTypeMap.forEach(item -> contractIds.add(item.getLong("contractId")));
            }
            resp = this.paymentRegisterService.getContractPayInfo(curStartDate, curEndDate, lastYearStartDate, lastYearEndDate, contractIds, contractTypeMap, null != param.get((Object)"groupByFields") ? param.getString("groupByFields") : null, curYear);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"queryContractRecInfo"})
    CommonResponse<List<Map<String, Object>>> queryContractRecInfo(@RequestBody JSONObject param) {
        List<Map<String, Object>> resp = this.receiptRegisterService.queryContractRecInfo(param.getString("curStartDate"), param.getString("curEndDate"), param.getString("lastYearStartDate"), param.getString("lastYearEndDate"), param.getJSONArray("contractIds").toJavaList(Long.class), null != param.get((Object)"groupByFields") ? param.getString("groupByFields") : null, param.getString("curYear"));
        return CommonResponse.success(resp);
    }
}

