/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.service.IRegisterDetailService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="paymentRegister")
public class PaymentRegisterBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPaymentRegisterService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRegisterDetailService detailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PaymentRegisterEntity paymentRegisterEntity = (PaymentRegisterEntity)((Object)this.service.selectById(billId));
        this.detailService.updateBillState(billId, state);
        if (paymentRegisterEntity.getPaymentContractFlag() != 0 && paymentRegisterEntity.getPaymentContractFlag() != 1) {
            this.service.updateStatus(paymentRegisterEntity, 2);
            this.service.writeBack(paymentRegisterEntity, true);
        }
        return CommonResponse.success((String)"\u4ed8\u6b3e\u7ba1\u7406\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        PaymentRegisterEntity paymentRegisterEntity = (PaymentRegisterEntity)((Object)this.service.selectById(billId));
        if (paymentRegisterEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u4fe1\u606f\uff01");
        }
        QueryWrapper listQueryOrderByTime = new QueryWrapper();
        if (paymentRegisterEntity.getPaymentContractFlag() == 0) {
            QueryWrapper listQuery = new QueryWrapper();
            listQuery.eq((Object)"contract_id", (Object)paymentRegisterEntity.getContractId());
            listQuery.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(), BillStateEnum.SUSPEND.getBillStateCode()});
            int resultCount = this.service.count((Wrapper)listQuery);
            if (resultCount > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u4ed8\u6b3e\u767b\u8bb0 \u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
            listQueryOrderByTime.eq((Object)"contract_id", (Object)paymentRegisterEntity.getContractId());
        } else {
            listQueryOrderByTime.eq((Object)"supplier_id", (Object)paymentRegisterEntity.getSupplierId());
        }
        listQueryOrderByTime.eq((Object)"project_id", (Object)paymentRegisterEntity.getProjectId());
        listQueryOrderByTime.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQueryOrderByTime.orderByDesc((Object)"create_time");
        List listOrderByTime = this.service.list((Wrapper)listQueryOrderByTime);
        if (CollectionUtils.isNotEmpty((Collection)listOrderByTime) && null != listOrderByTime.get(0) && !((PaymentRegisterEntity)((Object)listOrderByTime.get(0))).getId().equals(billId)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u6700\u65b0\u7684\u4ed8\u6b3e\u767b\u8bb0\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        if (paymentRegisterEntity.getPaymentContractFlag() != 0 && paymentRegisterEntity.getPaymentContractFlag() != 1) {
            this.service.writeBack(paymentRegisterEntity, true);
            this.service.updateStatus(paymentRegisterEntity, 0);
        }
        this.detailService.updateBillState(billId, state);
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

