package com.ejianc.business.profinance.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.profinance.bean.PayrollRegisterEntity;
import com.ejianc.business.profinance.service.IPayrollRegisterService;
import com.ejianc.business.profinance.vo.PayrollRegisterVO;

/**
 * 工资发放登记主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payrollRegister")
public class PayrollRegisterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPayrollRegisterService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayrollRegisterVO> saveOrUpdate(@RequestBody PayrollRegisterVO payrollRegisterVO) {
    	PayrollRegisterVO vo = service.insertOrUpdate(payrollRegisterVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayrollRegisterVO> queryDetail(Long id) {
    	PayrollRegisterEntity entity = service.selectById(id);
    	PayrollRegisterVO vo = BeanMapper.map(entity, PayrollRegisterVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayrollRegisterVO> vos) {
        service.removeByIds(vos.stream().map(PayrollRegisterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayrollRegisterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        //搜索：单据编号，项目名称，合同名称，乙方，经办人

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<PayrollRegisterEntity> page = service.queryPage(param,false);
        IPage<PayrollRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayrollRegisterVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }



    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<PayrollRegisterVO>> commonResponse = queryList(param);
        List<PayrollRegisterVO> salaryVOList = new ArrayList<>();
        if (null != commonResponse.getData()) {
            salaryVOList = (List<PayrollRegisterVO>) commonResponse.getData().getRecords();
            //流程状态
            if (CollectionUtils.isNotEmpty(salaryVOList)){
                for (PayrollRegisterVO payrollRegisterVO : salaryVOList) {
                    payrollRegisterVO.setBillStateName(BillStateEnum.getEnumByStateCode(payrollRegisterVO.getBillState()).getDescription());
                    switch (payrollRegisterVO.getProvideType()) {
                        case 0:
                            payrollRegisterVO.setProvideTypeName("劳务公司直发");
                            break;
                        case 1:
                            payrollRegisterVO.setProvideTypeName("第三方垫付");
                            break;
                        case 2:
                            payrollRegisterVO.setProvideTypeName("总包代发");
                            break;
                    }
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", salaryVOList);
        ExcelExport.getInstance().export("payrollRegister-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "payrollRegisterDetail-import.xlsx", "工人工资单-导入模板");
    }


    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = service.excelImport(request,response);
        return commonResponse;
    }



    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPayrollRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayrollRegisterVO>> refPayrollRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PayrollRegisterEntity> page = service.queryPage(param,false);
        IPage<PayrollRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayrollRegisterVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * @Author yangst
     * @Description  通过支付申请id查询付款登记列表
     * @param
     * @return
     */
    @RequestMapping(value = "/queryPayrollRegisterList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayrollRegisterVO>> queryPayrollRegisterList(@RequestBody QueryParam param) {
        String salaryPayApplyId = "";
        if (param.getParams().get("salaryPayApplyId") != null){
            salaryPayApplyId = String.valueOf(param.getParams().get("salaryPayApplyId").getValue());
        }

        Page<PayrollRegisterVO> pg = new Page<>(1, 10);
        pg.setSize(-1);
        IPage<PayrollRegisterVO> page = service.queryPayrollRegisterList(pg, Long.valueOf(salaryPayApplyId));
        IPage<PayrollRegisterVO> pageData = new Page<>(page.getCurrent(), 10, page.getRecords().size());
        pageData.setRecords(page.getRecords());
        return CommonResponse.success("通过支付申请id查询付款登记列表成功！",pageData);
    }




    /**
     * 测试工资发放登记生成付款登记（测试）
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/generatePaymentRegister")
    @ResponseBody
    public void generatePaymentRegister(HttpServletRequest request, HttpServletResponse response) {
        service.generatePaymentRegister(null);
    }


}
