package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.bean.GlodonProjectRelateDetailEntity;
import com.ejianc.business.profinance.bean.PaymentApplyDetailEntity;
import com.ejianc.business.profinance.mapper.SalaryDetailMapper;
import com.ejianc.business.profinance.service.IGlodonProjectRelateDetailService;
import com.ejianc.business.profinance.service.IGlodonSalaryService;
import com.ejianc.business.profinance.service.ISalaryDetailService;
import com.ejianc.business.profinance.utils.GlodonSalaryApiClient;
import com.ejianc.business.profinance.vo.GlodonSalaryDetailVO;
import com.ejianc.business.profinance.vo.GlodonSalaryVO;
import com.ejianc.business.profinance.vo.SalaryDetailVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 广联达工人工资
 * 
 * @author generator
 * 
 */
@Service("glodonSalaryService")
public class IGlodonSalaryImpl implements IGlodonSalaryService {
    @Autowired
    private SalaryDetailMapper SalaryDetailMapper;

    @Autowired
    private ISalaryDetailService salaryDetailService;

    @Autowired
    private IGlodonProjectRelateDetailService glodonProjectRelateDetailService;


    //工人工资单据
    private static final String SALARY = "/salaryV2/pageV2";

    //工人工资详情
    private static final String WORKER_DETAIL = "/salaryV2/detailV2";

    //获取工人工资单信息
    @Override
    public JSONObject getSalary(String projectId, String year, String month){
        //测试接口用数据，后期删除
        projectId = projectId == null ? "281492017440768" : projectId;
        year = StringUtils.isBlank(year) ? "2020" : year;
        month = StringUtils.isBlank(month) ? "10" : month;

        GlodonSalaryApiClient openApiTestClient = new GlodonSalaryApiClient();
        Map<String, Object> params = new HashMap<>();
        params.put("projectId", projectId);
        params.put("year", year);
        params.put("month", month);
        params.put("pageNum", "1");
        params.put("pageSize", "50");
        String salaryResultStr = openApiTestClient.sendGETRequest(SALARY, params);
        System.out.println(salaryResultStr);
        JSONObject salaryResultObject = new JSONObject();
        if (StringUtils.isNotBlank(salaryResultStr)){
            salaryResultObject = JSONObject.parseObject(salaryResultStr);
        }
        JSONObject page = new JSONObject();
        if (salaryResultObject != null) {
            //判断当前接口返回是否成功
            String success = salaryResultObject.getString("success");
            if (StringUtils.isNotBlank(success) && success.equals("true")){
                String data = salaryResultObject.getString("data");
                if (StringUtils.isNotBlank(data)){
                    JSONObject dataObject = JSONObject.parseObject(data);
                    if (dataObject != null){
                        String total = dataObject.getString("totalElements");
                        String current = dataObject.getString("page");
                        String size = dataObject.getString("size");
                        String pages = dataObject.getString("totalPages");
                        String contentStr = dataObject.getString("content");
                        List<GlodonSalaryVO> salaryList = new ArrayList<>();
                        if (StringUtils.isNotBlank(contentStr)){
                            salaryList = JSONArray.parseArray(contentStr).toJavaList(GlodonSalaryVO.class);
                            // TODO: 2022/4/16 判断当前工资单的id是否在工人工资单子表里存在，如果存在则赋值 ifChose 为 已选择 否则为 未选择
                            HashSet<Long> sourceSalaryIds = new HashSet<>();
                            if (CollectionUtils.isNotEmpty(salaryList)){
                                for (GlodonSalaryVO glodonSalaryVO : salaryList) {
                                    sourceSalaryIds.add(glodonSalaryVO.getId());
                                    //修改字符串
                                    String groupNameListStr = JSONObject.toJSONString(glodonSalaryVO.getGroupNames());
                                    groupNameListStr = groupNameListStr.substring(1, groupNameListStr.length() - 1);
                                    groupNameListStr = groupNameListStr.replace(",", "，");
                                    groupNameListStr = groupNameListStr.replace("\"", "");
                                    glodonSalaryVO.setGroupNameList(groupNameListStr);
                                }

                                List<Long> useSalaryIds = salaryDetailService.selectUseGlodonSalaryIds(sourceSalaryIds);
                                for (GlodonSalaryVO glodonSalaryVO : salaryList) {
                                    glodonSalaryVO.setProjectId(Long.valueOf(projectId));
                                    if (CollectionUtils.isNotEmpty(useSalaryIds) && useSalaryIds.contains(glodonSalaryVO.getId())){
                                        glodonSalaryVO.setIfChose("已选择");
                                    }else {
                                        glodonSalaryVO.setIfChose("未选择");
                                    }
                                }
                            }

                        }
                        page.put("records", salaryList);
                        page.put("total", total);
                        page.put("current", current);
                        page.put("size", size);
                        page.put("pages", pages);
                    }
                }
            }
        }
        return page;
    }


    //获取工人工资信息
    @Override
    public List<SalaryDetailVO> getSalaryDetail(String projectId, Object o, String year, String month, String ids) {
        GlodonSalaryApiClient openApiTestClient = new GlodonSalaryApiClient();
        Map<String, Object> params = new HashMap<>();
        // TODO: 2022/4/18 广联达接口添加根据ids查询数据后添加ids参数进行查询
        params.put("projectId", projectId);
        params.put("year", year);
        params.put("month", month);
        params.put("pageNum", "1");
        params.put("salaryIds", ids);
        params.put("pageSize", "1000");
        String workerDetailResultStr = openApiTestClient.sendGETRequest(WORKER_DETAIL, params);
        JSONObject workerDetailObject = new JSONObject();
        if (StringUtils.isNotBlank(workerDetailResultStr)){
            workerDetailObject = JSONObject.parseObject(workerDetailResultStr);
        }
        List<GlodonSalaryDetailVO> workerDetailList = new ArrayList<>();

        //判断当前接口返回是否成功
        String success = workerDetailObject.getString("success");
        if (StringUtils.isNotBlank(success) && success.equals("true")) {
            //获取接口中的data数据
            String data = workerDetailObject.getString("data");
            if (StringUtils.isNotBlank(data)) {
                JSONObject dataObject = JSONObject.parseObject(data);
                if (dataObject != null) {
                    //获取接口中content内容
                    String contentStr = dataObject.getString("content");
                    if (StringUtils.isNotBlank(contentStr)) {
                        workerDetailList = JSONArray.parseArray(contentStr).toJavaList(GlodonSalaryDetailVO.class);
                    }
                }
            }
        }
        LinkedList<SalaryDetailVO> salaryDetailVOList = new LinkedList<>();
        if (CollectionUtils.isNotEmpty(workerDetailList)){
            //获得该项目名称
            QueryParam projectQueryParam = new QueryParam();
            projectQueryParam.getParams().put("glodonProjectId", new Parameter(QueryParam.EQ, projectId));
            List<GlodonProjectRelateDetailEntity> glodonProjectRelateList =  glodonProjectRelateDetailService.queryList(projectQueryParam);
            String glodonProjectName = "";
            if (CollectionUtils.isNotEmpty(glodonProjectRelateList) && null != glodonProjectRelateList.get(0)){
                glodonProjectName = glodonProjectRelateList.get(0).getGlodonProjectName();
            }
            workerDetailList = workerDetailList.stream().filter(item -> (null != item.getTotalSalaryOfMonth() && BigDecimal.ZERO.compareTo(item.getTotalSalaryOfMonth()) != 0)).collect(Collectors.toList());
            for (GlodonSalaryDetailVO detailVO : workerDetailList) {
                // TODO: 2022/4/18 后期删除根据idsLIst匹配相应字段
                //将广联达的工人工资单适应本地字段
                SalaryDetailVO salaryDetailVO = new SalaryDetailVO();
                salaryDetailVO.setSourceId(detailVO.getId());
                salaryDetailVO.setSourceType(0);
                //将广联达数据主表id赋值给工人工资单子表的来源主表id
                salaryDetailVO.setSourceSalaryId(detailVO.getSalaryId());
                salaryDetailVO.setWorkerId(detailVO.getWorkerId());
                salaryDetailVO.setWorkerName(detailVO.getName());
                salaryDetailVO.setWorkerIdCard(detailVO.getIdentification());
                salaryDetailVO.setTeamName(detailVO.getTeamName());
                salaryDetailVO.setGroupName(detailVO.getGroupName());
                salaryDetailVO.setWorkNum(detailVO.getWorkingQuantityOfMonth());
                salaryDetailVO.setWorkDayCount(detailVO.getWorkDayCount());
                salaryDetailVO.setWorkTypeCode(detailVO.getWorkTypeCode());
                salaryDetailVO.setWorkType(detailVO.getWorkTypeName());
                salaryDetailVO.setAccountNum(detailVO.getBankCode());
                salaryDetailVO.setBankName(detailVO.getBankName());
                salaryDetailVO.setBankProvince(detailVO.getOpenBankProvince());
                salaryDetailVO.setProposedPaymentMny(BigDecimal.ZERO);
                if (null != detailVO.getSalaryWay()){
                    switch (detailVO.getSalaryWay()){
                        case 1 :
                            salaryDetailVO.setMeasureType(0);
                            break;
                        case 2 :
                            salaryDetailVO.setMeasureType(2);
                            break;
                        case 3 :
                            salaryDetailVO.setMeasureType(3);
                            break;
                        case 4 :
                            salaryDetailVO.setMeasureType(1);
                            break;
                        case 0 :
                            salaryDetailVO.setMeasureType(null);
                            break;
                    }
                }
                salaryDetailVO.setPrice(detailVO.getSalaryVerification());
                salaryDetailVO.setActualPrice(detailVO.getSalaryVerificationActual());
                salaryDetailVO.setAward(detailVO.getAward());
                salaryDetailVO.setDeductMny(detailVO.getLoanOfMonth());
                salaryDetailVO.setWorkingDayOfMonth(detailVO.getWorkingDayOfMonth());
                salaryDetailVO.setSalaryMny(detailVO.getTotalSalaryOfMonth());//应发
                salaryDetailVO.setOweSalaryMny(detailVO.getTotalSalaryOfMonth());//欠发

                salaryDetailVO.setMemo(detailVO.getRemark());
                //设置剩余可发金额为工资总额
                salaryDetailVO.setWorkerRemainderTaxMny(salaryDetailVO.getSalaryMny());

                salaryDetailVO.setTotalSalary(detailVO.getBaseSalary());//工资总额
                salaryDetailVO.setOtherDeduct(detailVO.getOtherDeduct());//其他扣款
                salaryDetailVO.setApprovalSalaryMny(detailVO.getPostSalary());//核定工资总额
                salaryDetailVO.setInterBankNum(detailVO.getInterBankNumber());//联行号

                salaryDetailVO.setGlodonProjectId(Long.valueOf(projectId));
                salaryDetailVO.setGlodonProjectName(glodonProjectName);

                salaryDetailVOList.add(salaryDetailVO);
            }
        }
        return salaryDetailVOList;
    }


}
