/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.SalaryDetailEntity;
import com.ejianc.business.profinance.mapper.SalaryDetailMapper;
import com.ejianc.business.profinance.service.ISalaryDetailService;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="salaryDetailService")
public class SalaryDetailServiceImpl
extends BaseServiceImpl<SalaryDetailMapper, SalaryDetailEntity>
implements ISalaryDetailService {
    @Autowired
    private SalaryDetailMapper SalaryDetailMapper;

    @Override
    public List<Long> selectUseGlodonSalaryIds(HashSet<Long> sourceSalaryIds) {
        return this.SalaryDetailMapper.selectUseGlodonSalaryIds(sourceSalaryIds);
    }

    @Override
    public void writeBackSalaryDetail(List<SalaryPayApplyDetailVO> salaryPayApplyDetailVOList) {
        HashMap<Long, BigDecimal> salaryDetailMap = new HashMap<Long, BigDecimal>();
        ArrayList<Long> sourceIdList = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailVOList)) {
            for (SalaryPayApplyDetailVO applyDetail : salaryPayApplyDetailVOList) {
                sourceIdList.add(applyDetail.getSourceId());
                salaryDetailMap.put(applyDetail.getSourceId(), applyDetail.getWorkerActualPaidTaxMny());
            }
        }
        QueryWrapper salaryDetailEntityQueryWrapper = new QueryWrapper();
        salaryDetailEntityQueryWrapper.in((Object)"id", sourceIdList);
        List salaryDetailEntityList = super.list((Wrapper)salaryDetailEntityQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)salaryDetailEntityList)) {
            for (SalaryDetailEntity salaryDetailEntity : salaryDetailEntityList) {
                salaryDetailEntity.setActualSalaryMny((BigDecimal)salaryDetailMap.get(salaryDetailEntity.getId()));
                salaryDetailEntity.setOweSalaryMny(salaryDetailEntity.getSalaryMny().subtract(salaryDetailEntity.getActualSalaryMny()));
                salaryDetailEntity.setPayday(new Date());
            }
        }
        super.saveOrUpdateBatch((Collection)salaryDetailEntityList);
    }

    @Override
    public void modifyWorkerRemainderTaxMny(List<SalaryPayApplyDetailVO> detailVOList) {
        List ids = detailVOList.stream().map(item -> item.getSourceId()).collect(Collectors.toList());
        HashMap<Long, BigDecimal> salaryDetailMap = new HashMap<Long, BigDecimal>();
        for (SalaryPayApplyDetailVO salaryPayApplyDetailVO : detailVOList) {
            salaryDetailMap.put(salaryPayApplyDetailVO.getSourceId(), salaryPayApplyDetailVO.getWorkerApplyTaxMny());
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", ids));
        List salaryDetailList = super.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)salaryDetailList)) {
            for (SalaryDetailEntity salaryDetailEntity : salaryDetailList) {
                BigDecimal workerRemainderTaxMny = null != salaryDetailMap.get(salaryDetailEntity.getId()) ? (BigDecimal)salaryDetailMap.get(salaryDetailEntity.getId()) : BigDecimal.ZERO;
                salaryDetailEntity.setWorkerRemainderTaxMny(salaryDetailEntity.getWorkerRemainderTaxMny().add(workerRemainderTaxMny));
            }
        }
        super.saveOrUpdateBatch((Collection)salaryDetailList);
    }
}

