/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.utils;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlodonSalaryApiClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String APP_ID_PARAM_NAME = "appid";
    private static final String TIMESTAMP_PARAM_NAME = "ts";
    private static final String SIGN_PARAM_NAME = "sign";
    private static final String OPEN_ALI_HOST = "https://glm-test.glodon.com/api/open";
    private static final String PRODUCT_OPEN_ALI_HOST = "https://glm.glodon.com/api/open";
    private static final String DISPATCH_HOST = "https://glm-test.glodon.com/iot";
    private static final String PRODUCT_APPID = "9b4a75e81fc0437ebb74752096153cc7";
    private static final String PRODUCT_SECRET = "ddb091eb6632665cc8adc3012f35cdb1";
    private static final String ALL_WORKER_BASE_INFO = "/worker/allWorkerBaseInfo";
    private static final String SALARY = "/salaryV2/pageV2";
    private static final String WORKER_DETAIL = "/salaryV2/detailV2";
    private static final String PROJECT_LIST = "/admin/project/listByOrgId";
    private String host = "https://glm.glodon.com/api/open";
    private String appId = "9b4a75e81fc0437ebb74752096153cc7";
    private String appSecret = "ddb091eb6632665cc8adc3012f35cdb1";

    public static void main(String[] args) {
        GlodonSalaryApiClient openApiTestClient = new GlodonSalaryApiClient();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", "1438833");
        params.put("orgId", "1441301");
        String salaryResult = openApiTestClient.sendGETRequest(PROJECT_LIST, params);
        System.out.println(salaryResult);
    }

    public String sendGETRequest(String path, Map<String, Object> requestParams) {
        String host = this.host;
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(host + path))).newBuilder();
        requestParams.put(APP_ID_PARAM_NAME, this.appId);
        String sign = this.getSign(requestParams);
        requestParams.put(SIGN_PARAM_NAME, sign);
        requestParams.forEach((s, o) -> urlBuilder.addQueryParameter(s, (String)o));
        this.logger.info("\u5f00\u59cb\u8bf7\u6c42\u63a5\u5165\u670d\u52a1\u7cfb\u7edf\u63a5\u53e3\uff0c\u5730\u5740\u4e3a\uff1a{}", (Object)urlBuilder.build());
        Request request = new Request.Builder().url(urlBuilder.build()).build();
        return this.getResult(request);
    }

    private String getSign(Map<String, Object> paramsMap) {
        ArrayList paramsList = new ArrayList();
        paramsMap.forEach((s, o) -> {
            String stringBuilder = s + o;
            paramsList.add(stringBuilder);
        });
        StringBuilder beforeMd5 = new StringBuilder();
        beforeMd5.append(this.appSecret);
        paramsList.stream().sorted(String::compareTo).collect(Collectors.toList()).forEach(beforeMd5::append);
        beforeMd5.append(this.appSecret);
        return DigestUtils.md5Hex((String)beforeMd5.toString()).toUpperCase();
    }

    public String sendPOSTRequest(String path, Object bodyParam) {
        String host = this.host;
        String jsonString = JSON.toJSONString((Object)bodyParam);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=UTF-8"), (String)jsonString);
        StringBuilder signBuilder = new StringBuilder();
        String time = System.currentTimeMillis() + "";
        signBuilder.append(this.appSecret).append(APP_ID_PARAM_NAME).append(this.appId).append(TIMESTAMP_PARAM_NAME).append(time).append(this.appSecret);
        this.logger.info("\u5f00\u59cb\u8bf7\u6c42\u5f00\u653e\u5e73\u53f0\u670d\u52a1\u7cfb\u7edf\u63a5\u53e3\uff0c\u5730\u5740\u4e3a\uff1a{}", (Object)(host + path));
        Request request = new Request.Builder().addHeader(APP_ID_PARAM_NAME, this.appId).addHeader(TIMESTAMP_PARAM_NAME, time).addHeader(SIGN_PARAM_NAME, DigestUtils.md5Hex((String)signBuilder.toString()).toUpperCase()).url(host + path).post(requestBody).build();
        return this.getResult(request);
    }

    private String getResult(Request request) {
        OkHttpClient client = new OkHttpClient();
        try {
            Response response = client.newCall(request).execute();
            if (response.body() != null) {
                return response.body().string();
            }
            throw new RuntimeException();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }
}

