package com.ejianc.business.profinance.service;

import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.profinance.bean.SalaryDetailEntity;

import java.util.HashSet;
import java.util.List;

/**
 * 工人工资单子实体
 * 
 * @author generator
 * 
 */
public interface ISalaryDetailService extends IBaseService<SalaryDetailEntity> {

    List<Long> selectUseGlodonSalaryIds(HashSet<Long> sourceSalaryIds);

    /**
     * 工资支付申请支付成功后回写工人工资单子表数据
     * @param salaryPayApplyDetailVOList
     */
    void writeBackSalaryDetail(List<SalaryPayApplyDetailVO> salaryPayApplyDetailVOList);

    /**
     * 删除工资支付申请后修改工人工资单的剩可发金额
     * @param detailVOList
     */
    void modifyWorkerRemainderTaxMny(List<SalaryPayApplyDetailVO> detailVOList);
}
