package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.enums.PayStatusEnum;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;

@Service("paymentApply")
public class PaymentApplyBpmServiceImpl implements ICommonBusinessService {

    @Autowired
	private IPaymentApplyService service;
	@Autowired
	private JedisPool jedisPool;
	private long retryInterval = 5000;
	private final int maxRetryTime = 10;
	private final String OPERATE = "PROFINANCE_PAY_RESULT";
	private static final String PROFINANCE_LOCK_KEY_PREFIX = "payment_apply_lock";

	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		// 付款申请日期校验
//        PaymentApplyEntity paymentApplyEntity = service.selectById(billId);
//        if (paymentApplyEntity == null) {
//            return CommonResponse.error("查询不到该单据信息！");
//        }
//        // 打印结算单日志
//        logger.info("付款申请提交前回调，付款申请信息：{}", JSON.toJSONString(paymentApplyEntity));
//
//        CommonResponse<PaymentApplyVO> result = service.queryUnusedPaymentApply(paymentApplyEntity.getPaymentType(), paymentApplyEntity.getProjectId(), paymentApplyEntity.getSupplierId(), paymentApplyEntity.getApplyDate());
//        if (result.isSuccess()){
//			return CommonResponse.success("付款申请-提交前回调成功！");
//		}else {
//			return CommonResponse.error(result.getMsg());
//		}
		return CommonResponse.success("付款申请-提交前回调成功！");
	}

	/**
	 * 终审审核完回调
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PaymentApplyEntity entity = service.selectById(billId);
		if (entity==null){

		}
		entity.setActualApplyMny(entity.getApprovalMny());
		//TODO 对接支付
		if(null!=entity.getPayAccountNum()){
			service.sendPayToNC(entity);
		}
		service.saveOrUpdate(entity,false);
		return CommonResponse.success("付款申请终审回调成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 撤回、弃审回调方法
	 *
	 * @param billId
	 * @param state
	 * @param billTypeCode
	 * @return
	 */
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		logger.info("付款申请单据billId-{}, state-{}, billTypeCode-{}撤回前校验", billId, state, billTypeCode);
		//已关闭的申请不能撤回
		PaymentApplyEntity paymentApplyEntity = service.selectById(billId);
		if (paymentApplyEntity == null) {
			return CommonResponse.error("查询不到该单据信息！");
		}
		logger.info("撤回前付款申请实体信息为：{}", JSONObject.toJSONString(paymentApplyEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
		//有合同付款申请 撤回校验
		if (paymentApplyEntity.getPaymentContractFlag()==0){
			//查询当前合同是否存在自由态的单据
			QueryWrapper<PaymentApplyEntity> listQuery = new QueryWrapper<>();
			listQuery.eq("contract_id", paymentApplyEntity.getContractId());
			listQuery.eq("bill_state",BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
			int resultCount = service.count(listQuery);
			if (resultCount > 0) {
				return CommonResponse.error("当前合同已存在自由态的付款申请 不能弃审/撤回！");
			}
		}
		//已关闭的不能弃审
		if (null != paymentApplyEntity.getCloseState() && paymentApplyEntity.getCloseState().equals(1)) {
			return CommonResponse.error("当前单据已关闭，不能弃审/撤回！");
		}
		//支付状态为 支付中、支付成功、支付失败、退票，这几个状态均不允许做单据撤回
		if (null != paymentApplyEntity.getPaymentStatus()
				&&PayStatusEnum.已支付.getCode().equals(paymentApplyEntity.getPaymentStatus())
				&&PayStatusEnum.支付中.getCode().equals(paymentApplyEntity.getPaymentStatus())
				&&PayStatusEnum.支付成功.getCode().equals(paymentApplyEntity.getPaymentStatus())
				&&PayStatusEnum.支付失败.getCode().equals(paymentApplyEntity.getPaymentStatus())
				&&PayStatusEnum.退票.getCode().equals(paymentApplyEntity.getPaymentStatus())
		){
			return CommonResponse.error("当前单据已付款，不能弃审！");
		}
		if (paymentApplyEntity.getActualMny()!=null){
			if (paymentApplyEntity.getActualMny().compareTo(BigDecimal.ZERO)==1){
				return CommonResponse.error("当前付款单已存在实际支付金额无法弃审");
			}
		}

		//单据状态为推送异常的，需要再去查一次资金接口，如果状态无变化，则可撤回
		if (null != paymentApplyEntity.getPaymentStatus() && (PayStatusEnum.推送异常.getCode() >= paymentApplyEntity.getPaymentStatus())){
			//加锁
			String redisKey = PROFINANCE_LOCK_KEY_PREFIX + "::" + + paymentApplyEntity.getId(); //paymentApplyEntity.getPayOrgCode() + "::"
			Jedis jedis = jedisPool.getResource();
			logger.info("从jedisPool获取jedis对象，jedis对象-{}", jedis);
			boolean lock = getLock(redisKey, jedis);
			if(!lock) {
				logger.info("键-{}尝试获取锁失败,将付款结果-{}重新放入队列进行处理", redisKey);
				return CommonResponse.error("获取锁失败");
			}

			try {
				//TODO 查询对应接口支付情况
//				return CommonResponse.error("当前单据处于 不能撤回");

			}catch (Exception e){
				// TODO 还是推送异常 可以撤回
				return CommonResponse.success("弃审/撤回前校验回调成功！");

			}finally {
				logger.info("redisKey-{}进行Redis锁释放", redisKey);
				unLock(jedis, true, redisKey, OPERATE);
			}
		} else {
			return CommonResponse.error("当前单据处于 不能撤回");
		}

		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

	public boolean getLock(String key, Jedis jedis) {
		int retryTime = 0;
		boolean lock = false;
		while(!lock && retryTime <= maxRetryTime) {
			try {
				if(retryTime >0 ){
					logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
					Thread.sleep(retryTime * retryInterval);
				}
				retryTime++;
				// 在数据维度层面进行加锁
				lock = RedisTool.tryLock(jedis, key, OPERATE, 600);
				if(lock) {
					return true;
				}
			} catch (Exception e) {
				logger.error("根据键-{}获取reids锁异常", JSONObject.toJSONString(key));
				return false;
			}
		}
		return false;
	}

	// 解锁
	public void unLock(Jedis jedis, boolean locked, String key, String operate) {
		try {
			if(locked) {
				RedisTool.releaseLock(jedis, key, operate);
			}
		} finally {
			if(null != jedis) {
				jedis.close();
			}
		}
	}
}
