package com.ejianc.business.profinance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.profinance.bean.SalaryPayApplyDetailEntity;

/**
 * 工人工资支付申请主实体
 *
 * @author generator
 */
@TableName("ejc_profinance_salary_pay_apply")
public class SalaryPayApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "create_user_name")
    private String createUserName; // 创建者名称
    @TableField(value = "update_user_name")
    private String updateUserName; // 修改者名称
    @TableField(value = "salary_id")
    private Long salaryId; // 工人工资单主表ID
    @TableField(value = "salary_detail_id")
    private Long salaryDetailId; // 工人工资单子表ID
    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "bill_code_repeat")
    private String billCodeRepeat; // 重发的单据编码
    @TableField(value = "bill_code_old")
    private String billCodeOld; // 重发的单据编码
    @TableField(value = "is_repeat_bill")
    private Integer isRepeatBill; // 是否为重发的单据，1-是，0-否
    @TableField(value = "pay_state")
    private Integer payState; // 支付状态：0-待支付，1-支付成功，2-部分支付，3-支付失败，4-支付中
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value = "repeat_state")
    private Integer repeatState; // 重发状态：0-无需重发，1-已重发，2-待重发
    @TableField(value = "pay_date")
    private Date payDate; // 支付日期
    @TableField(value = "last_pay_suc_time")
    private Date lastPaySucTime; // 最后支付成功日期  无效字段-后期删除
    @TableField(value = "pay_res_source")
    private String payResSource; // 支付结果来源，0-系统自动推送，1-手动确认
    @TableField(value = "pay_supplier_id")
    private Long paySupplierId; // 收款单位ID
    @TableField(value = "pay_supplier_name")
    private String paySupplierName; // 收款单位名称
    @TableField(value = "apply_id")
    private Long applyId; // 申请人ID
    @TableField(value = "apply_name")
    private String applyName; // 申请人名称
    @TableField(value = "apply_date")
    private Date applyDate; // 申请日期
    @TableField(value = "project_id")
    private Long projectId; // 项目ID
    @TableField(value = "project_code")
    private String projectCode; // 项目编码
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "contract_id")
    private Long contractId; // 合同ID
    @TableField(value = "contract_code")
    private String contractCode; // 合同编码
    @TableField(value = "contract_name")
    private String contractName; // 合同名称
    @TableField(value = "contract_category_id")
    private Long contractCategoryId; // 合同类别ID
    @TableField(value = "contract_category_name")
    private String contractCategoryName; // 合同类别名称
    @TableField(value = "org_id")
    private Long orgId; // 项目所属项目部ID
    @TableField(value = "org_code")
    private String orgCode; // 项目所属项目部编码
    @TableField(value = "org_name")
    private String orgName; // 项目所属项目部名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 项目所属上级组织ID
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 项目所属上级组织编码
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 项目所属上级组织名称
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门ID
    @TableField(value = "department_name")
    private String departmentName; // 经办部门ID
    @TableField(value = "account_id")
    private Long accountId; // 银行账号id
    @TableField(value = "account_num")
    private String accountNum; // 银行账号
    @TableField(value = "account_name")
    private String accountName; // 银行账户名称
    @TableField(value = "bank_name")
    private String bankName; // 开户行
    @TableField(value = "contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额（有税）
    @TableField(value = "contract_mny")
    private BigDecimal contractMny; // 合同金额（无税）
    @TableField(value = "contract_tax")
    private BigDecimal contractTax; // 合同金额（税额）

    @TableField(value = "contract_total_actual_tax_mny")
    private BigDecimal contractTotalActualTaxMny; //合同累计实付金额：所有已生效的付款申请单和已生效的工人工资支付申请单的实付金额的总和；
    @TableField(value = "contract_total_approve_tax_mny")
    private BigDecimal contractTotalApproveTaxMny; //合同累计批复金额：所有已生效的付款申请批复金额+已生效的工人工资支付申请金额

    @TableField(value = "total_should_pay_tax_mny")
    private BigDecimal totalShouldPayTaxMny; // 累计应发金额（有税）
    @TableField(value = "total_should_pay_mny")
    private BigDecimal totalShouldPayMny; // 累计应发金额（无税）
    @TableField(value = "total_should_pay_tax")
    private BigDecimal totalShouldPayTax; // 累计应发金额（税额）
    @TableField(value = "last_apply_tax_mny")
    private BigDecimal lastApplyTaxMny; // 截止上期已申请金额（有税）
    @TableField(value = "last_apply_mny")
    private BigDecimal lastApplyMny; // 截止上期已申请金额（无税）
    @TableField(value = "last_apply_tax")
    private BigDecimal lastApplyTax; // 截止上期已申请金额（税额）
    @TableField(value = "cur_can_apply_tax_mny")
    private BigDecimal curCanApplyTaxMny; // 本期可申请金额（有税）= 累计应发金额-截止截止上期已申请金额
    @TableField(value = "cur_can_apply_mny")
    private BigDecimal curCanApplyMny; // 本期可申请金额（无税）= 累计应发金额-截止截止上期已申请金额
    @TableField(value = "cur_can_apply_tax")
    private BigDecimal curCanApplyTax; // 本期可申请金额（税额）= 累计应发金额-截止截止上期已申请金额
    @TableField(value = "total_actual_paid_tax_mny")
    private BigDecimal totalActualPaidTaxMny; // 累计实付金额（有税）
    @TableField(value = "total_actual_paid_mny")
    private BigDecimal totalActualPaidMny; // 累计实付金额（无税）
    @TableField(value = "total_actual_paid_tax")
    private BigDecimal totalActualPaidTax; // 累计实付金额（税额）
    @TableField(value = "total_process_settle_tax_mny")
    private BigDecimal totalProcessSettleTaxMny; // 累计月度结算金额（有税）
    @TableField(value = "total_process_settle_mny")
    private BigDecimal totalProcessSettleMny; // 累计月度结算金额（无税）
    @TableField(value = "total_process_settle_tax")
    private BigDecimal totalProcessSettleTax; // 累计月度结算金额（税额）
    @TableField(value = "total_node_settle_tax_mny")
    private BigDecimal totalNodeSettleTaxMny; // 累计节点结算金额（有税）
    @TableField(value = "total_node_settle_mny")
    private BigDecimal totalNodeSettleMny; // 累计节点结算金额（无税）
    @TableField(value = "total_node_settle_tax")
    private BigDecimal totalNodeSettleTax; // 累计节点结算金额（税额）
    @TableField(value = "apply_tax_mny")
    private BigDecimal applyTaxMny; // 本次申请金额（有税）
    @TableField(value = "apply_mny")
    private BigDecimal applyMny; // 本次申请金额（无税）
    @TableField(value = "apply_tax")
    private BigDecimal applyTax; // 本次申请金额（税额）
    @TableField(value = "actual_paid_tax_mny")
    private BigDecimal actualPaidTaxMny; // 实际支付金额（有税）
    @TableField(value = "actual_paid_mny")
    private BigDecimal actualPaidMny; // 实际支付金额（无税）
    @TableField(value = "actual_paid_tax")
    private BigDecimal actualPaidTax; // 实际支付金额（税额）
    @TableField(value = "pay_reason")
    private String payReason; // 付款事由
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "contract_link_url")
    private String contractLinkUrl;// 合同穿透URL
    @TableField(value = "contract_source_type")
    private String contractSourceType; // 合同所属大分类 proSub-专业分包合同，laborSub-劳务分包合同
    @TableField(value = "contract_source_type_name")
    private String contractSourceTypeName; //合同所属大分类名称


    public String getContractLinkUrl() {
        return contractLinkUrl;
    }

    public void setContractLinkUrl(String contractLinkUrl) {
        this.contractLinkUrl = contractLinkUrl;
    }

    @TableField(exist = false)
    @SubEntity(serviceName = "salaryPayApplyDetailService",  pidName = "pid")
    private List<SalaryPayApplyDetailEntity> salaryList = new ArrayList<>(); // 工人工资支付申请子实体


    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public Long getSalaryId() {
        return salaryId;
    }

    public void setSalaryId(Long salaryId) {
        this.salaryId = salaryId;
    }

    public Long getSalaryDetailId() {
        return salaryDetailId;
    }

    public void setSalaryDetailId(Long salaryDetailId) {
        this.salaryDetailId = salaryDetailId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getBillCodeRepeat() {
        return billCodeRepeat;
    }

    public void setBillCodeRepeat(String billCodeRepeat) {
        this.billCodeRepeat = billCodeRepeat;
    }


    public String getBillCodeOld() {
        return billCodeOld;
    }

    public void setBillCodeOld(String billCodeOld) {
        this.billCodeOld = billCodeOld;
    }

    public Integer getIsRepeatBill() {
        return isRepeatBill;
    }

    public void setIsRepeatBill(Integer isRepeatBill) {
        this.isRepeatBill = isRepeatBill;
    }

    public Integer getPayState() {
        return payState;
    }

    public void setPayState(Integer payState) {
        this.payState = payState;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getRepeatState() {
        return repeatState;
    }

    public void setRepeatState(Integer repeatState) {
        this.repeatState = repeatState;
    }

    public Date getPayDate() {
        return payDate;
    }

    public void setPayDate(Date payDate) {
        this.payDate = payDate;
    }

    public Date getLastPaySucTime() {
        return lastPaySucTime;
    }

    public void setLastPaySucTime(Date lastPaySucTime) {
        this.lastPaySucTime = lastPaySucTime;
    }

    public String getPayResSource() {
        return payResSource;
    }

    public void setPayResSource(String payResSource) {
        this.payResSource = payResSource;
    }

    public Long getPaySupplierId() {
        return paySupplierId;
    }

    public void setPaySupplierId(Long paySupplierId) {
        this.paySupplierId = paySupplierId;
    }

    public String getPaySupplierName() {
        return paySupplierName;
    }

    public void setPaySupplierName(String paySupplierName) {
        this.paySupplierName = paySupplierName;
    }

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public String getApplyName() {
        return applyName;
    }

    public void setApplyName(String applyName) {
        this.applyName = applyName;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getTotalShouldPayTaxMny() {
        return totalShouldPayTaxMny;
    }

    public void setTotalShouldPayTaxMny(BigDecimal totalShouldPayTaxMny) {
        this.totalShouldPayTaxMny = totalShouldPayTaxMny;
    }

    public BigDecimal getTotalShouldPayMny() {
        return totalShouldPayMny;
    }

    public void setTotalShouldPayMny(BigDecimal totalShouldPayMny) {
        this.totalShouldPayMny = totalShouldPayMny;
    }

    public BigDecimal getTotalShouldPayTax() {
        return totalShouldPayTax;
    }

    public void setTotalShouldPayTax(BigDecimal totalShouldPayTax) {
        this.totalShouldPayTax = totalShouldPayTax;
    }

    public BigDecimal getLastApplyTaxMny() {
        return lastApplyTaxMny;
    }

    public void setLastApplyTaxMny(BigDecimal lastApplyTaxMny) {
        this.lastApplyTaxMny = lastApplyTaxMny;
    }

    public BigDecimal getLastApplyMny() {
        return lastApplyMny;
    }

    public void setLastApplyMny(BigDecimal lastApplyMny) {
        this.lastApplyMny = lastApplyMny;
    }

    public BigDecimal getLastApplyTax() {
        return lastApplyTax;
    }

    public void setLastApplyTax(BigDecimal lastApplyTax) {
        this.lastApplyTax = lastApplyTax;
    }

    public BigDecimal getCurCanApplyTaxMny() {
        return curCanApplyTaxMny;
    }

    public void setCurCanApplyTaxMny(BigDecimal curCanApplyTaxMny) {
        this.curCanApplyTaxMny = curCanApplyTaxMny;
    }

    public BigDecimal getCurCanApplyMny() {
        return curCanApplyMny;
    }

    public void setCurCanApplyMny(BigDecimal curCanApplyMny) {
        this.curCanApplyMny = curCanApplyMny;
    }

    public BigDecimal getCurCanApplyTax() {
        return curCanApplyTax;
    }

    public void setCurCanApplyTax(BigDecimal curCanApplyTax) {
        this.curCanApplyTax = curCanApplyTax;
    }

    public BigDecimal getTotalActualPaidTaxMny() {
        return totalActualPaidTaxMny;
    }

    public void setTotalActualPaidTaxMny(BigDecimal totalActualPaidTaxMny) {
        this.totalActualPaidTaxMny = totalActualPaidTaxMny;
    }

    public BigDecimal getTotalActualPaidMny() {
        return totalActualPaidMny;
    }

    public void setTotalActualPaidMny(BigDecimal totalActualPaidMny) {
        this.totalActualPaidMny = totalActualPaidMny;
    }

    public BigDecimal getTotalActualPaidTax() {
        return totalActualPaidTax;
    }

    public void setTotalActualPaidTax(BigDecimal totalActualPaidTax) {
        this.totalActualPaidTax = totalActualPaidTax;
    }

    public BigDecimal getTotalProcessSettleTaxMny() {
        return totalProcessSettleTaxMny;
    }

    public void setTotalProcessSettleTaxMny(BigDecimal totalProcessSettleTaxMny) {
        this.totalProcessSettleTaxMny = totalProcessSettleTaxMny;
    }

    public BigDecimal getTotalProcessSettleMny() {
        return totalProcessSettleMny;
    }

    public void setTotalProcessSettleMny(BigDecimal totalProcessSettleMny) {
        this.totalProcessSettleMny = totalProcessSettleMny;
    }

    public BigDecimal getTotalProcessSettleTax() {
        return totalProcessSettleTax;
    }

    public void setTotalProcessSettleTax(BigDecimal totalProcessSettleTax) {
        this.totalProcessSettleTax = totalProcessSettleTax;
    }

    public BigDecimal getTotalNodeSettleTaxMny() {
        return totalNodeSettleTaxMny;
    }

    public void setTotalNodeSettleTaxMny(BigDecimal totalNodeSettleTaxMny) {
        this.totalNodeSettleTaxMny = totalNodeSettleTaxMny;
    }

    public BigDecimal getTotalNodeSettleMny() {
        return totalNodeSettleMny;
    }

    public void setTotalNodeSettleMny(BigDecimal totalNodeSettleMny) {
        this.totalNodeSettleMny = totalNodeSettleMny;
    }

    public BigDecimal getTotalNodeSettleTax() {
        return totalNodeSettleTax;
    }

    public void setTotalNodeSettleTax(BigDecimal totalNodeSettleTax) {
        this.totalNodeSettleTax = totalNodeSettleTax;
    }

    public BigDecimal getApplyTaxMny() {
        return applyTaxMny;
    }

    public void setApplyTaxMny(BigDecimal applyTaxMny) {
        this.applyTaxMny = applyTaxMny;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getApplyTax() {
        return applyTax;
    }

    public void setApplyTax(BigDecimal applyTax) {
        this.applyTax = applyTax;
    }

    public BigDecimal getActualPaidTaxMny() {
        return actualPaidTaxMny;
    }

    public void setActualPaidTaxMny(BigDecimal actualPaidTaxMny) {
        this.actualPaidTaxMny = actualPaidTaxMny;
    }

    public BigDecimal getActualPaidMny() {
        return actualPaidMny;
    }

    public void setActualPaidMny(BigDecimal actualPaidMny) {
        this.actualPaidMny = actualPaidMny;
    }

    public BigDecimal getActualPaidTax() {
        return actualPaidTax;
    }

    public void setActualPaidTax(BigDecimal actualPaidTax) {
        this.actualPaidTax = actualPaidTax;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }


    public List<SalaryPayApplyDetailEntity> getSalaryList() {
        return salaryList;
    }

    public void setSalaryList(List<SalaryPayApplyDetailEntity> salaryList) {
        this.salaryList = salaryList;
    }


    public BigDecimal getContractTotalActualTaxMny() {
        return contractTotalActualTaxMny;
    }

    public void setContractTotalActualTaxMny(BigDecimal contractTotalActualTaxMny) {
        this.contractTotalActualTaxMny = contractTotalActualTaxMny;
    }

    public BigDecimal getContractTotalApproveTaxMny() {
        return contractTotalApproveTaxMny;
    }

    public void setContractTotalApproveTaxMny(BigDecimal contractTotalApproveTaxMny) {
        this.contractTotalApproveTaxMny = contractTotalApproveTaxMny;
    }

    public String getContractSourceType() {
        return contractSourceType;
    }

    public void setContractSourceType(String contractSourceType) {
        this.contractSourceType = contractSourceType;
    }

    public String getContractSourceTypeName() {
        return contractSourceTypeName;
    }

    public void setContractSourceTypeName(String contractSourceTypeName) {
        this.contractSourceTypeName = contractSourceTypeName;
    }
}
