package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.enums.ContractFlagEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleUltimateFlagEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.profinance.bean.ContractLawsuitEntity;
import com.ejianc.business.profinance.service.IContractLawsuitService;
import com.ejianc.business.profinance.vo.ContractLawsuitVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springside.modules.nosql.redis.JedisTemplate;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 诉讼费结算实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contractLawsuit")
public class ContractLawsuitController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private CacheManager cacheManager;

    private final String PUSH_POOL_PREFIX = "pushContractLawsuit::";
    @Autowired
    private IContractLawsuitService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractLawsuitVO> saveOrUpdate(@RequestBody ContractLawsuitVO saveOrUpdateVO) {
        //查询是合同是否存在未生效的诉讼费结算单
        QueryWrapper<ContractLawsuitEntity> query = new QueryWrapper<>();
        query.eq("contract_id", saveOrUpdateVO.getContractId());
        query.notIn("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        if(null != saveOrUpdateVO.getId()) {
            query.ne("id", saveOrUpdateVO.getId());
        }
        List<ContractLawsuitEntity> list = service.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error("当前合同存在未生效的单据，请选择其他合同或处理未生效的诉讼费结算单！");
        }

        ContractLawsuitVO vo = service.saveContractLawsuitVO(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractLawsuitVO> queryDetail(Long id) {
    	ContractLawsuitEntity entity = service.selectById(id);
    	ContractLawsuitVO vo = BeanMapper.map(entity, ContractLawsuitVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @GetMapping(value = "/checkExistsUnValidData")
    @ResponseBody
    public CommonResponse<JSONObject> checkExistsUnValidData(@RequestParam Long contractId) {
        JSONObject resp = new JSONObject();
        QueryWrapper<ContractLawsuitEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        List<ContractLawsuitEntity> list = service.list(query);

        List<ContractLawsuitEntity> unValidList = list.stream().filter(item -> !(BillStateEnum.PASSED_STATE.getBillStateCode().equals(item.getBillState())
                && BillStateEnum.COMMITED_STATE.getBillStateCode().equals(item.getBillState()))).collect(Collectors.toList());

        if(CollectionUtils.isNotEmpty(unValidList)) {
            return CommonResponse.error("当前合同存在未生效的单据，请选择其他合同或处理未生效的诉讼费结算单");
        }

        resp.put("lastLawsuitWorkMny", list.stream().map(ContractLawsuitEntity::getLawsuitWorkMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        return CommonResponse.success(resp);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractLawsuitVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ContractLawsuitVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ContractLawsuitVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractLawsuitVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<ContractLawsuitEntity> page = service.queryPage(param,false);
        IPage<ContractLawsuitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractLawsuitVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void ContractLawsuit-export .xlsx
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        CommonResponse<IPage<ContractLawsuitVO>> commonResponse = queryList(param);
        List<ContractLawsuitVO> lawsuitVOS = new ArrayList<>();
        if (null != commonResponse.getData()){
            lawsuitVOS = (List<ContractLawsuitVO>) commonResponse.getData().getRecords();
            if (null != lawsuitVOS && lawsuitVOS.size() > 0){
                SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");
                lawsuitVOS.forEach(c -> {
                    //流程状态
                    c.setSettleDateStr(sdf.format(c.getSettleDate()));
                    c.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
                });
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", lawsuitVOS);
        ExcelExport.getInstance().export("ContractLawsuit-export .xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refContractLawsuitData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> refContractLawsuitData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        //模糊查询字段
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        if (null == condition || org.apache.commons.lang.StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);

        if(null != conditionMap.get("contractId")) {
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, conditionMap.get("contractId")));
        }
        if (null != conditionMap.get("projectId")){
            Long projectId  = Long.parseLong(conditionMap.get("projectId").toString());
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }else{
            //查询本下范围内日的合同
            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,("1,3")));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        IPage<ContractLawsuitEntity> pageData = service.queryPage(param,false);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractLawsuitVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询参照数据成功！",page);
     }


    @PostMapping(value = "/pushLawsuitToPool")
    @ResponseBody
    public CommonResponse<ContractLawsuitVO> pushLawsuitToPool(@RequestBody Long settleId) {
        JedisTemplate jedisTemplate = cacheManager.getJedisTemplate();
        //校验当前合同是否正在进行同步操作
        String contractIdStr = jedisTemplate.get(PUSH_POOL_PREFIX + settleId.toString());
        if(StringUtils.isNotBlank(contractIdStr)) {
            return CommonResponse.error("当前单据数据已处于同步操作中，请勿重复操作！");
        }
        //校验通过，执行合同同步操作
        jedisTemplate.set(PUSH_POOL_PREFIX + settleId.toString(), settleId.toString());

        ContractLawsuitEntity entity = service.selectById(settleId);

        if(null == entity) {
            //删除合同同步控制标签
            jedisTemplate.del(PUSH_POOL_PREFIX + settleId.toString());
            return CommonResponse.error("结算单推送结算池失败，未找到Id-"+ settleId +"匹配的结算单！");
        }
        ContractLawsuitVO s = BeanMapper.map(entity, ContractLawsuitVO.class);

        SettlePoolVO spv = new SettlePoolVO();
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始");
            BeanConvertorUtil.convert(s, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");
            spv.setSourceType(SettleSourceTypeEnum.诉讼费结算.getCode());
            spv.setSettleProperty(0);// 属性类型：支出
            spv.setUltimateFlag(0);// 是否最终结算：否
            spv.setCurMny(s.getSettleMny());
            spv.setCurTax(BigDecimal.ZERO);
            spv.setCreateTime(s.getCreateTime());
            spv.setCreateUserCode(s.getCreateUserCode());
            spv.setBillCodeUrl("/ejc-profinance-frontend/#/lawsuitList/card?id="+s.getId());
            spv.setHandleType(0); //业务系统推送结算池
            spv.setContractFlag(ContractFlagEnum.有合同结算.getContractFlagCode());
            spv.setContractFlagName(ContractFlagEnum.有合同结算.getContractFlagCodeName());
            spv.setUltimateFlag(SettleUltimateFlagEnum.非最终结算.getCode());

            //查询合同分类
            CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(entity.getContractCategoryId());
            if(!categoryResp.isSuccess()) {
                return CommonResponse.error("推送失败，获取合同分类信息失败！");
            }
            spv.setContractType(categoryResp.getData().getCategoryProperty());
            spv.setContractTypeName(categoryResp.getData().getpName());

            logger.info("结算单对象:[{}] -> 结算池对象手动转换完成，下面开始:[{}]推送至结算池", JSONObject.toJSONString(s),JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            if (res.isSuccess()) {
                logger.info("结算单推送至结算池成功！结算单id-{}", s.getId());
                if(BillPushStatusEnum.未成功推送.getStatus().equals(entity.getPushPoolFlag())) {
                    entity.setPushPoolFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity);
                }
                return CommonResponse.success("结算单推送结算池成功！");
            }
        } catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", s.getId(), e);
        } finally {
            //删除合同同步控制标签
            jedisTemplate.del(PUSH_POOL_PREFIX + settleId.toString());
        }
        return CommonResponse.error("结算单推送失败", s);
    }


    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractLawsuitVO> pushCost(@RequestBody ContractLawsuitVO saveOrUpdateVO) {
        return service.pushCost(saveOrUpdateVO);
    }
}
