package com.ejianc.business.profinance.odd.controller;

import java.io.Serializable;

import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.profinance.odd.bean.OddFeeEntity;
import com.ejianc.business.profinance.odd.service.IOddFeeService;
import com.ejianc.business.profinance.odd.vo.OddFeeVO;

/**
 * 零星费用单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("oddFee")
@Api(value = "零星费用单", tags = {"零星费用单"})
public class OddFeeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ODD_FEE_CODE";//此处需要根据实际修改

    @Autowired
    private IOddFeeService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddFeeVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OddFeeVO saveOrUpdateVO) {
    	OddFeeEntity entity = BeanMapper.map(saveOrUpdateVO, OddFeeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	entity.setSurplusAllocatedMny(entity.getFeeMny());
    	entity.setSurplusPayMny(entity.getFeeMny());
    	entity.setSurplusAllocatedTaxMny(entity.getFeeTaxMny());
    	entity.setSurplusPayTaxMny(entity.getFeeTaxMny());
    	service.saveOrUpdate(entity, false);
    	OddFeeVO vo = BeanMapper.map(entity, OddFeeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddFeeVO> queryDetail(@RequestParam Long id) {
    	OddFeeEntity entity = service.selectById(id);
    	OddFeeVO vo = BeanMapper.map(entity, OddFeeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddFeeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OddFeeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OddFeeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("noContractFeeTypeName");
        fuzzyFields.add("businessExplain");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi
                    .findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong)
                            .collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }
        else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi
                    .findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OddFeeEntity> page = service.queryPage(param,false);
        IPage<OddFeeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddFeeVO.class));

        Map<String, BigDecimal> countOddFeeAmount = service.countOddFeeAmount(param);
  		JSONObject pageJson = new JSONObject();
        pageJson.put("records", pageData.getRecords());
        pageJson.put("total", pageData.getTotal());
        pageJson.put("current", pageData.getCurrent());
        pageJson.put("size", pageData.getSize());
        pageJson.put("pages", pageData.getPages());
        pageJson.put("countOddFeeAmount", countOddFeeAmount);

        return CommonResponse.success("查询列表数据成功！",pageJson);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("noContractFeeTypeName");
        fuzzyFields.add("businessExplain");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                .findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId)
                .collect(Collectors.toList())));
        List<OddFeeEntity> list = service.queryList(param);
        List<OddFeeVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, OddFeeVO.class);
            for (OddFeeVO vo : voList) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("OddFee-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOddFeeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OddFeeVO>> refOddFeeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("noContractFeeTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        param.getParams().put("", new Parameter(QueryParam.SQL, " (surplus_allocated_tax_mny > 0.01 or surplus_allocated_tax_mny < -0.01 )"));
//        param.getParams().put("surplusAllocatedTaxMny", new Parameter(QueryParam.GT, new BigDecimal(0.01)));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (!_con.containsKey("queryType")) {
                throw new BusinessException("查询类型不能为空");
            }
            // 零星费用分配查询
//            if ("odd".equals(_con.getString("queryType"))) {
//                param.getParams().put("surplusAllocatedTaxMny", new Parameter(QueryParam.GT, 0));
//            }
            // 付款申请
            if ("pay".equals(_con.getString("queryType"))) {
                param.getParams().put("surplusPayTaxMny", new Parameter(QueryParam.GT, 0));
            }
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            else {
                Long orgId = InvocationInfoProxy.getOrgId();
                //若当前上下文为项目部，则根据项目部Id来进行查询
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
                }
                else {
                    CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                    if (!orgResp.isSuccess()) {
                        logger.error("查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                        throw new BusinessException("查询失败，获取当前本下组织信息失败!失败原因：" + orgResp.getMsg());
                    }
                    param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                            orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                }
            }
        }
        else {
            throw new BusinessException("查询参数不能为空");
        }

        IPage<OddFeeEntity> page = service.queryPage(param,false);
        IPage<OddFeeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddFeeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "OddFee-import.xlsx", "零星费用单-导入模板");
    }


    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = service.excelImport(request,response);
        return commonResponse;
    }

    /**
     * 导入数据保存
     * @param request
     * @param importVOS
     * @return
     */
    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<OddFeeVO> importVOS) {
        return CommonResponse.success(service.saveImportExcel(request, importVOS));
    }

}
