package com.ejianc.business.profinance.odd.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.profinance.odd.bean.OddAllocationEntity;
import com.ejianc.business.profinance.odd.bean.OddFeeEntity;
import com.ejianc.business.profinance.odd.service.IOddAllocationService;
import com.ejianc.business.profinance.odd.service.IOddFeeService;
import com.ejianc.business.profinance.odd.vo.OddAllocationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.List;

@Service("oddAllocation") 
public class OddAllocationBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IOddFeeService oddFeeService;
	@Autowired
	private IOddAllocationService service;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		updateOddFee(true, billId);
		//推送实际成本
		service.costPush(service.selectById(billId));
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		OddAllocationEntity oddAllocationEntity = service.selectById(billId);
		LambdaQueryWrapper<OddAllocationEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
		lambdaQueryWrapper.eq(OddAllocationEntity::getOddFeeId, oddAllocationEntity.getOddFeeId());
		lambdaQueryWrapper.orderByDesc(OddAllocationEntity::getCreateTime);
		List<OddAllocationEntity> list = service.list(lambdaQueryWrapper);
		if(CollectionUtils.isNotEmpty(list)){
			logger.info("最新零星费用分配单id:{},零星费用单id:{}",list.get(0).getId(),list.get(0).getOddFeeId());
			if(!billId.equals(list.get(0).getId())){
				return CommonResponse.error("只能撤回该零星费用单最新的零星费用分配单！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		updateOddFee(false, billId);
		//撤回实际成本
		service.deleteCost(billId);
		return CommonResponse.success();
	}
	/**
	 * 更新零星单金额数据
	 * @param flag true-审批通过   false-撤回
	 */
	public void updateOddFee(Boolean flag, Long billId) {
		OddAllocationVO vo = BeanMapper.map(service.selectById(billId), OddAllocationVO.class);
		logger.info("零星分配id: {}-编码--{},零星单据id: {}--编码--{}" + ( flag ? "审批通过" : "撤回"),vo.getId(),vo.getBillCode(),vo.getOddFeeId(),vo.getOddFeeCode());
		BigDecimal haveAllocatedTaxMny = null==vo.getHaveAllocatedTaxMny()? BigDecimal.ZERO : vo.getHaveAllocatedTaxMny();//已经分摊金额
		BigDecimal haveAllocatedMny = null==vo.getHaveAllocatedMny()? BigDecimal.ZERO : vo.getHaveAllocatedMny();
		BigDecimal surplusAllocatedTaxMny = null==vo.getSurplusAllocatedTaxMny()? BigDecimal.ZERO : vo.getSurplusAllocatedTaxMny();//剩余金额
		BigDecimal surplusAllocatedMny = null==vo.getSurplusAllocatedMny()? BigDecimal.ZERO : vo.getSurplusAllocatedMny();
		BigDecimal totalAllocatedTaxMny = null==vo.getTotalAllocatedTaxMny()? BigDecimal.ZERO : vo.getTotalAllocatedTaxMny();//累计金额
		BigDecimal totalAllocatedMny = null==vo.getTotalAllocatedMny()? BigDecimal.ZERO : vo.getTotalAllocatedMny();
		BigDecimal allocatedTaxMny = null==vo.getAllocatedTaxMny()? BigDecimal.ZERO : vo.getAllocatedTaxMny();//本次金额
		BigDecimal allocatedMny = null==vo.getAllocatedMny()? BigDecimal.ZERO : vo.getAllocatedMny();

		logger.info("零星分配，已分摊金额: {}---{},剩余金额: {}---{},累计金额: {}---{},本次金额：{}--{}",haveAllocatedTaxMny,haveAllocatedMny,surplusAllocatedTaxMny,
				surplusAllocatedMny,totalAllocatedTaxMny,totalAllocatedMny,allocatedTaxMny,allocatedMny);
		if(flag){
			haveAllocatedTaxMny =totalAllocatedTaxMny;
			haveAllocatedMny = totalAllocatedMny;
			surplusAllocatedTaxMny = ComputeUtil.safeSub(surplusAllocatedTaxMny,allocatedTaxMny);
			surplusAllocatedMny = ComputeUtil.safeSub(surplusAllocatedMny,allocatedMny);
		}
		logger.info("修改回显零星单，已分摊金额: {}---{},剩余金额: {}---{}",haveAllocatedTaxMny,haveAllocatedMny,surplusAllocatedTaxMny,
				surplusAllocatedMny);
		LambdaUpdateWrapper<OddFeeEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(OddFeeEntity::getId, vo.getOddFeeId());
		updateWrapper.set(OddFeeEntity::getHaveAllocatedTaxMny, haveAllocatedTaxMny);
		updateWrapper.set(OddFeeEntity::getHaveAllocatedMny,haveAllocatedMny);
		updateWrapper.set(OddFeeEntity::getSurplusAllocatedTaxMny, surplusAllocatedTaxMny);
		updateWrapper.set(OddFeeEntity::getSurplusAllocatedMny,surplusAllocatedMny);
		oddFeeService.update(updateWrapper);
	}

}
